#!/bin/sh

# Test that the helpful advice feature is working correctly.

set -e
set -u
set -x
cd "$(dirname "$0")"

trap "rm -f ./actual.1.txt ./actual.2.txt ./actual.3.txt ./actual.4.txt" EXIT

# invalid Rego query is an extant file
set +e
"$RQ" query ./test.sh > actual.1.txt 2>&1
EC=$?
set -e
if [ "$EC" -eq 0 ] ; then
	echo "rq failed to exit nonzero when given an invalid query" 1>&2
	exit 1
fi
if ! diff expect.1.txt actual.1.txt > /dev/null ; then
	echo "when given an invalid query which was an extant file, rq did not print helpful advice" 1>&2
	diff expect.1.txt actual.1.txt
	exit 1
fi

# invalid format is an extant file
set +e
"$RQ" query -i ./test.sh > actual.2.txt 2>&1
EC=$?
set -e
if [ "$EC" -eq 0 ] ; then
	echo "rq failed to exit nonzero when given an invalid input format" 1>&2
	exit 1
fi
if ! diff expect.2.txt actual.2.txt > /dev/null ; then
	echo "when given an invalid input format which was an extant file, rq did not print helpful advice" 1>&2
	diff expect.2.txt actual.2.txt
	exit 1
fi

# invalid input format looks like a dataspec
set +e
"$RQ" query -i '{"format": "json", "file_path": "/foo"}' > actual.3.txt 2>&1
EC=$?
set -e
if [ "$EC" -eq 0 ] ; then
	echo "rq failed to exit nonzero when given an invalid input format" 1>&2
	exit 1
fi
if ! diff expect.3.txt actual.3.txt > /dev/null ; then
	echo "when given an invalid input format which looked like a dataspec, rq did not print helpful advice" 1>&2
	diff expect.3.txt actual.3.txt
	exit 1
fi

# invalid output format looks like a dataspec
set +e
echo '{}' | "$RQ" query -o '{"format": "json", "file_path": "/foo"}' > actual.4.txt 2>&1
EC=$?
set -e
if [ "$EC" -eq 0 ] ; then
	echo "rq failed to exit nonzero when given an invalid output format" 1>&2
	exit 1
fi
if ! diff expect.4.txt actual.4.txt > /dev/null ; then
	echo "when given an invalid output format which looked like a dataspec, rq did not print helpful advice" 1>&2
	diff expect.4.txt actual.4.txt
	exit 1
fi
