#include <sys/types.h>
#include <unistd.h>
#include "open.h"
#include "byte.h"
#include "cdbread.h"
#include "ip.h"

int find_clientloc(char clientloc[2],const char ip[16])
{
  int i, r, fd;
  char key[64 + 3];
  static struct cdb c;
  static stralloc ipstring = {0};

  fd = open_read("data.cdb");
  if (fd == -1) return 0;
  cdb_init(&c,fd);

  byte_zero(clientloc,2);
  key[0] = 0;
  key[1] = '%';
  if (byte_equal(ip,12,V4mappedprefix)) {
    ip4_bytestring(&ipstring,ip + 12,32);
    byte_copy(key + 2,32,ipstring.s);
    for (i = 0; i < 32; i++) {
      r = cdb_find(&c,key,34 - i);
      if (r == -1) return 0;
      if (r > 0) break;
    }
    if (!r) r = cdb_find(&c,key,2);
    if (r && (cdb_datalen(&c) == 2))
      if (cdb_read(&c,clientloc,2,cdb_datapos(&c)) == -1) return 0;
  } else {
    ip6_bytestring(&ipstring,ip,64);
    byte_copy(key + 2,64,ipstring.s);
    for (i = 0; i < 64; i++) {
      r = cdb_find(&c,key,66 - i);
      if (r == -1)  return 0;
      if (r > 0) break;
    }
    if (!r) r = cdb_find(&c,key,2);
    if (r && (cdb_datalen(&c) == 2))
      if (cdb_read(&c,clientloc,2,cdb_datapos(&c)) == -1) return 0;
  }

  cdb_free(&c);
  close(fd);
  return r;
}
