/* \mainpage

djbdnscurve6
============

is a fork of Dan J. Bernstein's djbdns.

Features
--------

- IPv6 capabilites based on fehQlibs allowing the
  use of compactified IPv6 and LLU addresses.
- Support for TLSA records according to RFC 6698 for tinydns.
- Support for DKIM records according to RFC 6376 for tinydns
  and DNS TXT lookup.
- CurveDNS secured query/response for dnscache.
- CurveDNS enabled servers: tinydns, rbldns, walldns.
  based on NaCl/libsodium applying and improving Matthew Dempsky's patch.
- rbldns supporting IPv6 addresses.
- Multihoming & dualstack capabilities for the servers.
- Miscellaneous improvements in particular for dnscache.
- Siphash cache for dnscache.
- Authoritative DNS responses in split-horizon manner
  evaluating IP client addresses in given CIDR format.
- Installation accordingly to the slashpackage convention.


Requirements
------------

djbdnscurve6 requires

- fehQlibs (basics and IP socket connectivity).
- NaCl or libsodium for encryption/decryption services.
- daemontools for startup and environment setting.
- systemd or others (runit, s6) can be used with caution.


Packages removed
----------------

- pickdns has been removed.


User Interface changes
----------------------

- Due to IPv6 support, the tinydns data file uses 
  a '|’ and not the usual ':' as delimitor.
- Unlike Felix von Leitner's implementation,
  IPv6 notation is given by compactified addresses.
 

Unfinished features
-------------------

- tinydns is UDP only and does not provide DNSSec features.
- rts.test has not been fully adjusted yet (it is IPv4 only),
- EDNS0 partially supported by dnscache.


Erwin Hoffmann, February 2023.
