/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/types.h,v $
 * $Id: types.h,v 3.30 1999/10/13 22:28:05 heiner Exp $
 *
 *	Types suitable for a register start with a lower case "r".
 */

#ifndef CHEST_types_h_INCLUDED
#define CHEST_types_h_INCLUDED

#include "bastyp.h"
#include "cnt.h"

#if !INIDEFS_PUT && INIT_GET
# include "initdefs.h"
#endif
#if INIT_GET
# define Iconst		const
#else
# define Iconst		/*empty*/
#endif


/*---------------------------------------------------------------------------*/

typedef int8		 Colour;
typedef int		rColour;

#define white	0
#define black	1
#define empty	2

#if ! CHEST_CURSES_USED
# define border	3	/* name of function function in "<ncurses.h>" */
#endif

#define opp_colour(c)	((c) ^ (white^black))

/*---------------------------------------------------------------------------*/

typedef int8		 Figure;
typedef int		rFigure;

#define bauer		0		/* B, pawn   */
#define springer	1		/* S, knight */
#define laeufer		2		/* L, bishop */
#define turm		3		/* T, rook   */
#define dame		4		/* D, queen  */
#define koenig		5		/* K, king   */

#define no_figure	(-1)

#define MAX_FIGURES	6

/*---------------------------------------------------------------------------*/

#define castle00	0x01
#define castle000	0x02

typedef uint8		 Castle;
typedef unsigned int	rCastle;

/*---------------------------------------------------------------------------*/

typedef int16		 Position;		/* index into board */
typedef int		rPosition;
typedef int8		 StepDelta;		/* single step Position delta */
typedef int		rStepDelta;
typedef int16		 AddrDelta;		/* single step Address delta */
typedef int		rAddrDelta;

/*
 * The fields in the Board are linearized in lines (not columns).
 * Shortened example:
 *		6 7 8
 *		3 4 5
 *		0 1 2
 * Before changing check out all the macros below.
 */

#define B_LINES		24			/* 8 + 2 times 8 border lines */
#define B_COLUMNS	16			/* 8 + 8 border */
#define B_SIZE		(B_LINES * B_COLUMNS)

#define LIN_OFF		((B_LINES   - 8) / 2)	/* apprx. centered */
#define COL_OFF		((B_COLUMNS - 8) / 2)	/* apprx. centered */

#define MK_POS(col, lin) ((col) + COL_OFF + (((lin) + LIN_OFF) * B_COLUMNS))
#define COL(pos)	((int)(((unsigned)(pos)) % B_COLUMNS) - COL_OFF)
#define LIN(pos)	((int)(((unsigned)(pos)) / B_COLUMNS) - LIN_OFF)

#define MK_DELTA(cols,lins)	(MK_POS(cols,lins) - MK_POS(0,0))

#define DELTA_R		MK_DELTA( 1, 0)		/* right */
#define DELTA_L		MK_DELTA(-1, 0)		/* left */
#define DELTA_U		MK_DELTA( 0, 1)		/* up */
#define DELTA_D		MK_DELTA( 0,-1)		/* down */

#define DELTA_LU	MK_DELTA(-1, 1)		/* left/up */
#define DELTA_LD	MK_DELTA(-1,-1)		/* left/down */
#define DELTA_RU	MK_DELTA( 1, 1)		/* right/up */
#define DELTA_RD	MK_DELTA( 1,-1)		/* right/down */

/*
 * Define special type for legal deltas.
 * Take care that MAX_LEGAL_DELTA is consistent with MK_POS.
 */
			/****** MK_POS(7,7) - MK_POS(0,0) ******/
#define MAX_LEGAL_DELTA		(7 * B_COLUMNS + 7)	/* inclusive !! */
#define MIN_LEGAL_DELTA		(-MAX_LEGAL_DELTA)	/* inclusive !! */
#define LEGAL_DELTA_RANGE	(MAX_LEGAL_DELTA - MIN_LEGAL_DELTA + 1)

#if MAX_LEGAL_DELTA < 0x80
  typedef int8		 LegalDelta;	/* delta of legal board positions */
#else
  typedef int16		 LegalDelta;	/* delta of legal board positions */
#endif
typedef int	 	rLegalDelta;

#define NO_POS			(-1)
#define no_pos(pos)		((pos) < 0)

  /**/

#define B64_LINES	8
#define B64_COLUMNS	8
#define B64_SIZE	(B64_LINES * B64_COLUMNS)

typedef  uint8		 Pos64;		/* 0..63 line by line */
typedef ruint8		rPos64;

#define MK_POS64(col,lin)	((col) + ((lin) * 8))	/* do NOT change */
#define COL64(pos)		((pos) % 8)
#define LIN64(pos)		((pos) / 8)

#define NO_POS64		((Pos64) (-1))
#define no_pos64(pos64)		(!!(((Pos64)(pos64)) & ~((Pos64)(B64_SIZE-1))))

					/* take care on negative values: */
					/*   'Pos64' is unsigned!        */
#define MK_DELTA64(cols,lins)	(MK_POS64(cols,lins) - MK_POS64(0,0))

  /**/

#define BAS_LIN(colour)		(((colour) == white) ? 1 : 6)
#define PROM_LIN(colour)	(((colour) == white) ? 7 : 0)
#define STRT_LIN(colour)	(((colour) == white) ? 0 : 7)

/*---------------------------------------------------------------------------*/
/*
 * Directions.  First for D, then for S (to get unique att_dir).
 * On the D-directions we have some arithmetic operations:
 *  opp_dir	opposite
 *  ort_dir	orthogonal
 *  lin_dir	smaller of dir and opp_dir(dir)
 * L- & T-directions form a compact subrange of the D-directions.
 */

#define NO_DIR		(-1)
#define MIN_T_DIR	0		/* inclusive */
#define MAX_T_DIR	4		/* exclusive */
#define MIN_L_DIR	4		/* inclusive */
#define MAX_L_DIR	8		/* exclusive */
#define MIN_D_DIR	0		/* inclusive */
#define MAX_D_DIR	8		/* exclusive */
#define MIN_E_DIR	MIN_D_DIR		/* escape directions */
#define MAX_E_DIR	(MAX_D_DIR + 1)
#define ZERO_DIR	MAX_D_DIR		/* delta 0 for escape sets */
#define MIN_S_DIR	8		/* inclusive */
#define MAX_S_DIR	16		/* exclusive */

#define no_dir(dir)	((dir) < 0)
#define opp_dir(dir)	((dir) ^ 1)		/* LTDK: opposite */
#define ort_dir(dir)	((dir) ^ 2)		/* LTDK: othogonal */
#define lin_dir(dir)	((dir) & ~1)		/* LTDK: line normalized */
#define zero_dir(dir)	((dir) == ZERO_DIR)

#define lfr_dir(dir)	in_range((dir), MIN_L_DIR, MAX_L_DIR)
#define trm_dir(dir)	in_range((dir), MIN_T_DIR, MAX_T_DIR)
#define dam_dir(dir)	in_range((dir), MIN_D_DIR, MAX_D_DIR)
#define spr_dir(dir)	in_range((dir), MIN_S_DIR, MAX_S_DIR)

/*---------------------------------------------------------------------------*/

#define MAX_PIECE	16			/* max. per colour */
#define KING_IDX	0			/* kings index in piece lists */

#define COLOUR_IDX(c)	((c) * MAX_PIECE)
#define IDX_COLOUR(i)	((i) >> 4)

typedef uint32		 PieceSet;	/* set of pieces */
typedef uint32		rPieceSet;

#define COLOUR_MASK(c)	(((PieceSet)0x0000ffff) << COLOUR_IDX(c))
#define SET1(idx)	(((PieceSet)1) << (idx))
#define K_IDX(c)	(KING_IDX + COLOUR_IDX(c))

#define BOTH_KINGS	( SET1(K_IDX(white)) | SET1(K_IDX(black)) )

#define min2elems(set)	(((set) & ((set) - 1)) != 0)
#define max1elems(set)	( ! min2elems(set))

/*---------------------------------------------------------------------------*/

typedef  int8		 PieceIdx;
typedef rint8		rPieceIdx;

#define NO_PIECE	(-1)
#define no_piece(piece)	((piece) < 0)

/*---------------------------------------------------------------------------*/

Extern const StepDelta	spr_mov[];	/* [rel S-dir] */
Extern const StepDelta	dam_mov[];	/* [rel D-dir] */
Extern const StepDelta	bau_mov[];	/* [Colour] */
Extern const StepDelta	bau_left [];	/* [Colour] */
Extern const StepDelta	bau_right[];	/* [Colour] */

Extern const AddrDelta	dam_fmov[];	/* scaled "dam_mov" */
Extern const StepDelta	dam_mov64[];	/* "dam_mov" for Pos64 */

Extern const Position	trm_00 [];	/* [C] org pos of T for 0-0 */
Extern const Position	trm_000[];	/* [C] org pos of T for 0-0-0 */


/*---------------------------------------------------------------------------*/

#ifndef MAX_ANA_DEPTH
# define MAX_ANA_DEPTH	30	/* CF: maximum depth (a 2 moves) of analysis */
#endif

#define ANARES(dep,succ)	(((dep)<<1) | ((succ) & 01))
#define ANADEP(res)		((int)((unsigned)(res) >> 1))
#define ANASUC(res)		((res) & 01)
#define ANA_MANY		(255 >> 2)

#if ! (ANA_MANY >= MAX_ANA_DEPTH)
# include "/// >>>>> MAX_ANA_DEPTH too large <<<<< ///"
#endif

/*---------------------------------------------------------------------------*/
/*
 * Initialization of most of the following tables:
 */
Extern void	ini_extern(void);

/*---------------------------------------------------------------------------*/
/*
 * Relations between non-border board positions, defined by special table.
 */

#define ATT_TAB_MID	B_SIZE

Extern Iconst int8	att_table[ 2*ATT_TAB_MID + 1 ];

#define att_dir(from, to)	(att_table[ATT_TAB_MID + ((to) - (from))])

/*---------------------------------------------------------------------------*/
/*
 * Translate Pos64 into Position/Darkness/BorderCount:
 */

Extern Iconst Position	pos64_pos[];
Extern Iconst int8	pos64_dark[];
Extern Iconst int8	pos64_borders[];

/*---------------------------------------------------------------------------*/
/*
 * Fast search for set bits:
 */

#define LOW_SEARCH_BITS		12

typedef uint8		ShiftCnt;
typedef ruint8		rShiftCnt;

Extern Iconst ShiftCnt	min_0low[];

#define MIN_LOW_ZERO(set) (min_0low[ (set) & ((1 << LOW_SEARCH_BITS) - 1) ])

/*
 * Support set cardinality computation:
 */

#define SUM_BITS	9	/* MUST be >= 9 (for EscSet) */

Extern Iconst int8	bitsum[];	/* SUM_BIT low bits --> bit count */

#define BITSUM32(v)	( bitsum[((unsigned)(v)) >> 24]		\
			+ bitsum[((v) >> 16) & 0x0ff]		\
			+ bitsum[((v) >> 8) & 0x0ff]		\
			+ bitsum[(v) & 0x0ff]				\
			)

/*---------------------------------------------------------------------------*/
/*
 * Support Zobrist-style hash code:
 */
#ifndef WITH_ZHASH
# define WITH_ZHASH	0	/* CF: whether we have a b_zhash */
#endif

typedef  uint32		 Zhash;
typedef ruint32		rZhash;

#if WITH_ZHASH
  Extern const Zhash	zh_tab[2*MAX_FIGURES][64];

# define ZH_INX(c,f)		((c) + ((f) << 1))	/* (colour,figure) */
# define ZH_VAL(c,f,p64)	zh_tab[ZH_INX(c,f)][p64]
# define ZH_UPD(v,c,f,p64)	((v) ^= ZH_VAL(c,f,p64))
#else	/* ! WITH_ZHASH */
# define ZH_UPD(v,c,f,p64)	/*empty*/
#endif	/* ! WITH_ZHASH */

/*---------------------------------------------------------------------------*/
/*
 * Global flags and debug support (export interface of "debug.c"):
 */

Extern int	f_stats;	/* statistics level */
Extern Flag	f_danswer;	/* whether to sort defender's answers */
Extern int	f_mvtrace;	/* how deep to trace executed moves */
Extern Flag	f_fac;		/* whether to do fac heuristic */
Extern Flag	f_mate2;	/* whether to do #2 heuristic */

#if PROD_LEV < 2
  Extern Flag	f_debug;	/* whether debug mode */
#endif
#if ! PROD_LEV
  Extern Flag	f_xdebug;	/* whether extended/special debug mode */
#endif

#define F_ACM_DO	0x01
#define F_ACM_USE	0x02

Extern void CDECL_	panic (const char* fmt, ...);

/*---------------------------------------------------------------------------*/
/*
 * Special version control:
 */

#if ! PROD_LEV
  Extern int	o_hops;
  Extern int	o_heiner;
  Extern int	o_thorak;
# define IF_HEINER_SET(msk,x)	if( o_heiner & (msk) ) { x }
#else	/* PROD_LEV */
# define	o_hops		(0)
# define	o_heiner	(0)
# define	o_thorak	(0)
# define IF_HEINER_SET(msk,x)	/*empty*/
#endif	/* PROD_LEV */

/*---------------------------------------------------------------------------*/
/*
 * Support for Escape-Sets:
 */

typedef uint8		 DirSet;	/* set-of-D/K-directions */
typedef unsigned int	rDirSet;

typedef uint16		 EscSet;	/* escape direction set */
typedef unsigned int	rEscSet;

#define ESCSETS	(1 << 9)		/* so many EscSet values */

typedef uint8		 FigSet;	/* set-of-Figure */
typedef unsigned int	rFigSet;

typedef struct LegDelSet	LegDelSet;
typedef struct EscInfo		EscInfo;

struct LegDelSet			/* set-of-legal-delta */
{
    int		count;			/* how many in "deltas", or -1 */
    LegalDelta*	deltas;			/* there are they, 0-terminated */
};

struct EscInfo				/* per escape [direction] set */
{
    FigSet	figcan;			/* which ones can cover it */
    LegDelSet	fighow[ MAX_FIGURES ];	/* how can they cover it */
#if 0	/* currently unwanted */
    int		filler_[3];		/* for alignment */
#endif
};


Extern Iconst EscInfo*	cov_esc[ ESCSETS ];	/* how to cover escapes */
Extern Iconst EscSet*	fig_cov[MAX_FIGURES];	/* maximal covering, [legdel] */

/*
 * Map position to set of (relative) direction, such that 1 step into
 * these directions does not step onto the border.
 */
Extern Iconst DirSet	pos64_nb_ddirs[64];	/* [64]: {~border rel D-dirs} */
Extern Iconst DirSet	pos64_nb_sdirs[64];	/* [64]: {~border rel S-dirs} */
/*
 * Map Pos64 and (relative) D-direction to the number of steps,
 * which can be taken before stepping onto the border.
 */
Extern Iconst uint8	pos64_nb_steps[64][8];	/* [64][D-dir] #steps ~border */

/*
 * Map Figure and LegalDelta to Set(relative direction), which to follow
 * has a chance to actively hit a K-Environment.  The LegalDelta
 * is centered around the K (center of environment).
 */
Extern Iconst DirSet	ldf_acov_dirs[MAX_FIGURES][LEGAL_DELTA_RANGE];
#define LDF_ACOV_TAB(f)	(&(ldf_acov_dirs[f][0-MIN_LEGAL_DELTA]))

/*---------------------------------------------------------------------------*/
/*
 * Attack-Directions combine relative D- and relative S-Directions.
 */

typedef uint16		 AttDirSet;	/* set-of-LTDS(K)-attack-directions */
typedef unsigned int	rAttDirSet;

#define ATTDIRSET1(dir)	(((AttDirSet)1) << (dir))

/*
 * Conversion between different direction sets.
 * Because of LTD(K)-directions and S-directions are split, it exists
 * an additional argument ('mindir') specifying the relating base direction.
 * + mindir = [MIN_D_DIR,MIN_S_DIR].
 */

#define DirSet_AttDirSet(dirset, mindir)	\
 (((AttDirSet)(dirset)) << (mindir))

#define AttDirSet_DirSet(attdirset, mindir)	\
  ((DirSet)((attdirset) >> (mindir)))

/*---------------------------------------------------------------------------*/
/*
 * fig_attdirset(F)	Those directions into which a Figure F is able
 *			to produce attacks. Hence, B yield an empty set.
 *
 * fig_fardirset(F)	Those directions into which a Figure F is able
 *			to produce (in)direct attacks further away than
 *			just one step.  Hence, BSK yield an empty set.
 *
 * bau_attdirset(C)	Addition to 'fig_attdirset()'. Colour dependant.
 */

#if ( no_figure < 0 )
# define fig_attdirset_idx(fig)		((fig) - no_figure)
#else
# include "/// >>>> no_figure ? <<<< ///"
#endif

#define fig_fardirset_idx(fig)		fig_attdirset_idx(fig)

Extern Iconst AttDirSet	fig_attdirset_tab[ fig_attdirset_idx(MAX_FIGURES) ];
Extern Iconst AttDirSet	fig_fardirset_tab[ fig_fardirset_idx(MAX_FIGURES) ];
Extern Iconst AttDirSet	bau_attdirset_tab[ 2 ];			/* [Colour] */

#define fig_attdirset(fig)	(fig_attdirset_tab[ fig_attdirset_idx(fig) ])
#define fig_fardirset(fig)	(fig_fardirset_tab[ fig_fardirset_idx(fig) ])

#if 0									/*FFS*/
# define bau_attdirset(colour)	bau_attdirset_tab[colour]
#else
# define bau_attdirset(colour)	\
  (((colour) == white) ? ATTDIRSET_W_B : ATTDIRSET_B_B)
#endif

/*---------------------------------------------------------------------------*/
/*
 * attdirset(from,to)	The maximal possible set of directions into which
 *			some piece@from may beat another one at to.
 *			from and to must be non-border fields.
 *			This is a set representation of att_dir,
 *			restricted to legal deltas, sometimes allowing
 *			faster testing (no_dir is just an empty set).
 */

#if ( MIN_LEGAL_DELTA < 0 )
# define attdirset_idx(from,to)	(((to) - (from)) - MIN_LEGAL_DELTA)
#else
# include "/// >>>> MIN_LEGAL_DELTA ? <<<< ///"
#endif

 Extern Iconst AttDirSet	attdirset_tab[ LEGAL_DELTA_RANGE ];
#define attdirset(from,to)	(attdirset_tab[ attdirset_idx(from,to) ])

/*---------------------------------------------------------------------------*/
/*
 * Support for Set-of(Set), especially Set-of(EscSet).
 * These are constructed from a series of "uint32".
 */
#ifndef WITH_SET5
# define WITH_SET5	0	/* CF */
#endif

#if WITH_SET5
Extern Iconst uint32	set5_subsets[1<<5];	/* [set5] all subsets   (incl)*/
Extern Iconst uint32	set5_supsets[1<<5];	/* [set5] all supersets (incl)*/
#endif

/*
 * For compaction we need to map 9 bits and a base mask of the same size
 * into a compacted value.  This a far too much.  It suffices to map
 * 3 bits at a time: 8x8 -> uint3
 */
/*FFS*/

#endif	/* ndef CHEST_types_h_INCLUDED */
