/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/epdio.h,v $
 * $Id: epdio.h,v 1.7 1999/11/05 01:10:26 heiner Exp $
 *
 *	EPD input and output
 */

#ifndef CHEST_epdio_h_INCLUDED
#define CHEST_epdio_h_INCLUDED

#include "types.h"
#include "board.h"

#define EPD_MAX_FYS_LEN	80	/* > 8*8+7, Forsyth part */
#define EPD_MAX_OP_LEN	15	/* max eff length of keywords */
#define EPD_MAX_OPS	60	/* max #(keyword operations) */
#define EPD_MAX_BUF_SIZ	4096	/* string arena size */

typedef int		EpdStr;		/* string index */
typedef struct EpdOp	EpdOp;		/* opcode + operands */
typedef struct EpdJob	EpdJob;

struct EpdOp
{
    char	op[EPD_MAX_OP_LEN+1];	/* keyword */
    EpdStr	rest;			/* --> blank sep string (list) */
};

struct EpdJob
{
    char	fys[EPD_MAX_FYS_LEN+1];	/* FN (Forsyth notation) */
    char	tom[1+1];		/* side to move */
    char	castle[4+1];		/* rights to castle */
    char	ep[2+1];		/* e.p. target */
    int		opfull;			/* #(entries) in oparr */
    int		strfull;		/* next free index into "strbuf" */
    EpdOp	oparr[EPD_MAX_OPS];
    char	strbuf[EPD_MAX_BUF_SIZ];
};

#define EPD_STR_NIL	0
#define EPD_IS_NIL(s)	(!(s))
#define EPD_STR(ejp,x)	(&( (ejp)->strbuf[x] ))

Extern void	epd_clear     (EpdJob*);
Extern int	epd_fill_line (EpdJob*, const char*);	/* -1 | success */
Extern int	epd_get_dep_prog(EpdJob*, int dftdep);	/* 0 | depth */

Extern void	epd_copy_move (EpdJob*, Board*, const Move*, EpdJob*);
Extern void	epd_use_board (EpdJob*, const Board*);

Extern Bool	epd_set_result(EpdJob*,
		    Bool	ismate,		/* otherwise "proven lost" */
		    int		depth,		/* of mate [without preply] */
		    const char*	pv,		/* 0 | PV */
		    double	secs,		/* seconds used */
		    double	nodes );	/* whether all fit into */

Extern Bool	epd_set_bm    (EpdJob*, Board*, const Movelist*);

Extern void	epd_print     (EpdJob*);		/* sorts internally */

#endif	/* ndef CHEST_epdio_h_INCLUDED */
