// Copyright 2013 Prometheus Team
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This is copied and lightly edited from
// github.com/prometheus/client_model/io/prometheus/client/metrics.proto
// and finally converted to proto3 syntax to make it usable for the
// gogo-protobuf approach taken within prometheus/prometheus.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        (unknown)
// source: io/prometheus/client/metrics.proto

//go:build protoopaque

package client

import (
	_ "buf.build/gen/go/gogo/protobuf/protocolbuffers/go/gogoproto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type MetricType int32

const (
	// COUNTER must use the Metric field "counter".
	MetricType_COUNTER MetricType = 0
	// GAUGE must use the Metric field "gauge".
	MetricType_GAUGE MetricType = 1
	// SUMMARY must use the Metric field "summary".
	MetricType_SUMMARY MetricType = 2
	// UNTYPED must use the Metric field "untyped".
	MetricType_UNTYPED MetricType = 3
	// HISTOGRAM must use the Metric field "histogram".
	MetricType_HISTOGRAM MetricType = 4
	// GAUGE_HISTOGRAM must use the Metric field "histogram".
	MetricType_GAUGE_HISTOGRAM MetricType = 5
)

// Enum value maps for MetricType.
var (
	MetricType_name = map[int32]string{
		0: "COUNTER",
		1: "GAUGE",
		2: "SUMMARY",
		3: "UNTYPED",
		4: "HISTOGRAM",
		5: "GAUGE_HISTOGRAM",
	}
	MetricType_value = map[string]int32{
		"COUNTER":         0,
		"GAUGE":           1,
		"SUMMARY":         2,
		"UNTYPED":         3,
		"HISTOGRAM":       4,
		"GAUGE_HISTOGRAM": 5,
	}
)

func (x MetricType) Enum() *MetricType {
	p := new(MetricType)
	*p = x
	return p
}

func (x MetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_io_prometheus_client_metrics_proto_enumTypes[0].Descriptor()
}

func (MetricType) Type() protoreflect.EnumType {
	return &file_io_prometheus_client_metrics_proto_enumTypes[0]
}

func (x MetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type LabelPair struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name  string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Value string                 `protobuf:"bytes,2,opt,name=value,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *LabelPair) Reset() {
	*x = LabelPair{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelPair) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelPair) ProtoMessage() {}

func (x *LabelPair) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *LabelPair) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *LabelPair) GetValue() string {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return ""
}

func (x *LabelPair) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *LabelPair) SetValue(v string) {
	x.xxx_hidden_Value = v
}

type LabelPair_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name  string
	Value string
}

func (b0 LabelPair_builder) Build() *LabelPair {
	m0 := &LabelPair{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Value = b.Value
	return m0
}

type Gauge struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value float64                `protobuf:"fixed64,1,opt,name=value,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *Gauge) Reset() {
	*x = Gauge{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Gauge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Gauge) ProtoMessage() {}

func (x *Gauge) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Gauge) GetValue() float64 {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return 0
}

func (x *Gauge) SetValue(v float64) {
	x.xxx_hidden_Value = v
}

type Gauge_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Value float64
}

func (b0 Gauge_builder) Build() *Gauge {
	m0 := &Gauge{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Value = b.Value
	return m0
}

type Counter struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value            float64                `protobuf:"fixed64,1,opt,name=value,proto3"`
	xxx_hidden_Exemplar         *Exemplar              `protobuf:"bytes,2,opt,name=exemplar,proto3"`
	xxx_hidden_CreatedTimestamp *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_timestamp,json=createdTimestamp,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *Counter) Reset() {
	*x = Counter{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Counter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Counter) ProtoMessage() {}

func (x *Counter) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Counter) GetValue() float64 {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return 0
}

func (x *Counter) GetExemplar() *Exemplar {
	if x != nil {
		return x.xxx_hidden_Exemplar
	}
	return nil
}

func (x *Counter) GetCreatedTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreatedTimestamp
	}
	return nil
}

func (x *Counter) SetValue(v float64) {
	x.xxx_hidden_Value = v
}

func (x *Counter) SetExemplar(v *Exemplar) {
	x.xxx_hidden_Exemplar = v
}

func (x *Counter) SetCreatedTimestamp(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreatedTimestamp = v
}

func (x *Counter) HasExemplar() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Exemplar != nil
}

func (x *Counter) HasCreatedTimestamp() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreatedTimestamp != nil
}

func (x *Counter) ClearExemplar() {
	x.xxx_hidden_Exemplar = nil
}

func (x *Counter) ClearCreatedTimestamp() {
	x.xxx_hidden_CreatedTimestamp = nil
}

type Counter_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Value            float64
	Exemplar         *Exemplar
	CreatedTimestamp *timestamppb.Timestamp
}

func (b0 Counter_builder) Build() *Counter {
	m0 := &Counter{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Value = b.Value
	x.xxx_hidden_Exemplar = b.Exemplar
	x.xxx_hidden_CreatedTimestamp = b.CreatedTimestamp
	return m0
}

type Quantile struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Quantile float64                `protobuf:"fixed64,1,opt,name=quantile,proto3"`
	xxx_hidden_Value    float64                `protobuf:"fixed64,2,opt,name=value,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Quantile) Reset() {
	*x = Quantile{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Quantile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Quantile) ProtoMessage() {}

func (x *Quantile) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Quantile) GetQuantile() float64 {
	if x != nil {
		return x.xxx_hidden_Quantile
	}
	return 0
}

func (x *Quantile) GetValue() float64 {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return 0
}

func (x *Quantile) SetQuantile(v float64) {
	x.xxx_hidden_Quantile = v
}

func (x *Quantile) SetValue(v float64) {
	x.xxx_hidden_Value = v
}

type Quantile_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Quantile float64
	Value    float64
}

func (b0 Quantile_builder) Build() *Quantile {
	m0 := &Quantile{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Quantile = b.Quantile
	x.xxx_hidden_Value = b.Value
	return m0
}

type Summary struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_SampleCount      uint64                 `protobuf:"varint,1,opt,name=sample_count,json=sampleCount,proto3"`
	xxx_hidden_SampleSum        float64                `protobuf:"fixed64,2,opt,name=sample_sum,json=sampleSum,proto3"`
	xxx_hidden_Quantile         *[]*Quantile           `protobuf:"bytes,3,rep,name=quantile,proto3"`
	xxx_hidden_CreatedTimestamp *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=created_timestamp,json=createdTimestamp,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *Summary) Reset() {
	*x = Summary{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Summary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Summary) ProtoMessage() {}

func (x *Summary) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Summary) GetSampleCount() uint64 {
	if x != nil {
		return x.xxx_hidden_SampleCount
	}
	return 0
}

func (x *Summary) GetSampleSum() float64 {
	if x != nil {
		return x.xxx_hidden_SampleSum
	}
	return 0
}

func (x *Summary) GetQuantile() []*Quantile {
	if x != nil {
		if x.xxx_hidden_Quantile != nil {
			return *x.xxx_hidden_Quantile
		}
	}
	return nil
}

func (x *Summary) GetCreatedTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreatedTimestamp
	}
	return nil
}

func (x *Summary) SetSampleCount(v uint64) {
	x.xxx_hidden_SampleCount = v
}

func (x *Summary) SetSampleSum(v float64) {
	x.xxx_hidden_SampleSum = v
}

func (x *Summary) SetQuantile(v []*Quantile) {
	x.xxx_hidden_Quantile = &v
}

func (x *Summary) SetCreatedTimestamp(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreatedTimestamp = v
}

func (x *Summary) HasCreatedTimestamp() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreatedTimestamp != nil
}

func (x *Summary) ClearCreatedTimestamp() {
	x.xxx_hidden_CreatedTimestamp = nil
}

type Summary_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	SampleCount      uint64
	SampleSum        float64
	Quantile         []*Quantile
	CreatedTimestamp *timestamppb.Timestamp
}

func (b0 Summary_builder) Build() *Summary {
	m0 := &Summary{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_SampleCount = b.SampleCount
	x.xxx_hidden_SampleSum = b.SampleSum
	x.xxx_hidden_Quantile = &b.Quantile
	x.xxx_hidden_CreatedTimestamp = b.CreatedTimestamp
	return m0
}

type Untyped struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value float64                `protobuf:"fixed64,1,opt,name=value,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *Untyped) Reset() {
	*x = Untyped{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Untyped) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Untyped) ProtoMessage() {}

func (x *Untyped) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Untyped) GetValue() float64 {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return 0
}

func (x *Untyped) SetValue(v float64) {
	x.xxx_hidden_Value = v
}

type Untyped_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Value float64
}

func (b0 Untyped_builder) Build() *Untyped {
	m0 := &Untyped{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Value = b.Value
	return m0
}

type Histogram struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_SampleCount      uint64                 `protobuf:"varint,1,opt,name=sample_count,json=sampleCount,proto3"`
	xxx_hidden_SampleCountFloat float64                `protobuf:"fixed64,4,opt,name=sample_count_float,json=sampleCountFloat,proto3"`
	xxx_hidden_SampleSum        float64                `protobuf:"fixed64,2,opt,name=sample_sum,json=sampleSum,proto3"`
	xxx_hidden_Bucket           *[]*Bucket             `protobuf:"bytes,3,rep,name=bucket,proto3"`
	xxx_hidden_CreatedTimestamp *timestamppb.Timestamp `protobuf:"bytes,15,opt,name=created_timestamp,json=createdTimestamp,proto3"`
	xxx_hidden_Schema           int32                  `protobuf:"zigzag32,5,opt,name=schema,proto3"`
	xxx_hidden_ZeroThreshold    float64                `protobuf:"fixed64,6,opt,name=zero_threshold,json=zeroThreshold,proto3"`
	xxx_hidden_ZeroCount        uint64                 `protobuf:"varint,7,opt,name=zero_count,json=zeroCount,proto3"`
	xxx_hidden_ZeroCountFloat   float64                `protobuf:"fixed64,8,opt,name=zero_count_float,json=zeroCountFloat,proto3"`
	xxx_hidden_NegativeSpan     *[]*BucketSpan         `protobuf:"bytes,9,rep,name=negative_span,json=negativeSpan,proto3"`
	xxx_hidden_NegativeDelta    []int64                `protobuf:"zigzag64,10,rep,packed,name=negative_delta,json=negativeDelta,proto3"`
	xxx_hidden_NegativeCount    []float64              `protobuf:"fixed64,11,rep,packed,name=negative_count,json=negativeCount,proto3"`
	xxx_hidden_PositiveSpan     *[]*BucketSpan         `protobuf:"bytes,12,rep,name=positive_span,json=positiveSpan,proto3"`
	xxx_hidden_PositiveDelta    []int64                `protobuf:"zigzag64,13,rep,packed,name=positive_delta,json=positiveDelta,proto3"`
	xxx_hidden_PositiveCount    []float64              `protobuf:"fixed64,14,rep,packed,name=positive_count,json=positiveCount,proto3"`
	xxx_hidden_Exemplars        *[]*Exemplar           `protobuf:"bytes,16,rep,name=exemplars,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *Histogram) Reset() {
	*x = Histogram{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Histogram) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Histogram) ProtoMessage() {}

func (x *Histogram) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Histogram) GetSampleCount() uint64 {
	if x != nil {
		return x.xxx_hidden_SampleCount
	}
	return 0
}

func (x *Histogram) GetSampleCountFloat() float64 {
	if x != nil {
		return x.xxx_hidden_SampleCountFloat
	}
	return 0
}

func (x *Histogram) GetSampleSum() float64 {
	if x != nil {
		return x.xxx_hidden_SampleSum
	}
	return 0
}

func (x *Histogram) GetBucket() []*Bucket {
	if x != nil {
		if x.xxx_hidden_Bucket != nil {
			return *x.xxx_hidden_Bucket
		}
	}
	return nil
}

func (x *Histogram) GetCreatedTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreatedTimestamp
	}
	return nil
}

func (x *Histogram) GetSchema() int32 {
	if x != nil {
		return x.xxx_hidden_Schema
	}
	return 0
}

func (x *Histogram) GetZeroThreshold() float64 {
	if x != nil {
		return x.xxx_hidden_ZeroThreshold
	}
	return 0
}

func (x *Histogram) GetZeroCount() uint64 {
	if x != nil {
		return x.xxx_hidden_ZeroCount
	}
	return 0
}

func (x *Histogram) GetZeroCountFloat() float64 {
	if x != nil {
		return x.xxx_hidden_ZeroCountFloat
	}
	return 0
}

func (x *Histogram) GetNegativeSpan() []*BucketSpan {
	if x != nil {
		if x.xxx_hidden_NegativeSpan != nil {
			return *x.xxx_hidden_NegativeSpan
		}
	}
	return nil
}

func (x *Histogram) GetNegativeDelta() []int64 {
	if x != nil {
		return x.xxx_hidden_NegativeDelta
	}
	return nil
}

func (x *Histogram) GetNegativeCount() []float64 {
	if x != nil {
		return x.xxx_hidden_NegativeCount
	}
	return nil
}

func (x *Histogram) GetPositiveSpan() []*BucketSpan {
	if x != nil {
		if x.xxx_hidden_PositiveSpan != nil {
			return *x.xxx_hidden_PositiveSpan
		}
	}
	return nil
}

func (x *Histogram) GetPositiveDelta() []int64 {
	if x != nil {
		return x.xxx_hidden_PositiveDelta
	}
	return nil
}

func (x *Histogram) GetPositiveCount() []float64 {
	if x != nil {
		return x.xxx_hidden_PositiveCount
	}
	return nil
}

func (x *Histogram) GetExemplars() []*Exemplar {
	if x != nil {
		if x.xxx_hidden_Exemplars != nil {
			return *x.xxx_hidden_Exemplars
		}
	}
	return nil
}

func (x *Histogram) SetSampleCount(v uint64) {
	x.xxx_hidden_SampleCount = v
}

func (x *Histogram) SetSampleCountFloat(v float64) {
	x.xxx_hidden_SampleCountFloat = v
}

func (x *Histogram) SetSampleSum(v float64) {
	x.xxx_hidden_SampleSum = v
}

func (x *Histogram) SetBucket(v []*Bucket) {
	x.xxx_hidden_Bucket = &v
}

func (x *Histogram) SetCreatedTimestamp(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreatedTimestamp = v
}

func (x *Histogram) SetSchema(v int32) {
	x.xxx_hidden_Schema = v
}

func (x *Histogram) SetZeroThreshold(v float64) {
	x.xxx_hidden_ZeroThreshold = v
}

func (x *Histogram) SetZeroCount(v uint64) {
	x.xxx_hidden_ZeroCount = v
}

func (x *Histogram) SetZeroCountFloat(v float64) {
	x.xxx_hidden_ZeroCountFloat = v
}

func (x *Histogram) SetNegativeSpan(v []*BucketSpan) {
	x.xxx_hidden_NegativeSpan = &v
}

func (x *Histogram) SetNegativeDelta(v []int64) {
	x.xxx_hidden_NegativeDelta = v
}

func (x *Histogram) SetNegativeCount(v []float64) {
	x.xxx_hidden_NegativeCount = v
}

func (x *Histogram) SetPositiveSpan(v []*BucketSpan) {
	x.xxx_hidden_PositiveSpan = &v
}

func (x *Histogram) SetPositiveDelta(v []int64) {
	x.xxx_hidden_PositiveDelta = v
}

func (x *Histogram) SetPositiveCount(v []float64) {
	x.xxx_hidden_PositiveCount = v
}

func (x *Histogram) SetExemplars(v []*Exemplar) {
	x.xxx_hidden_Exemplars = &v
}

func (x *Histogram) HasCreatedTimestamp() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreatedTimestamp != nil
}

func (x *Histogram) ClearCreatedTimestamp() {
	x.xxx_hidden_CreatedTimestamp = nil
}

type Histogram_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	SampleCount      uint64
	SampleCountFloat float64
	SampleSum        float64
	// Buckets for the classic histogram.
	Bucket           []*Bucket
	CreatedTimestamp *timestamppb.Timestamp
	// schema defines the bucket schema. Currently, valid numbers are -4 <= n <= 8.
	// They are all for base-2 bucket schemas, where 1 is a bucket boundary in each case, and
	// then each power of two is divided into 2^n logarithmic buckets.
	// Or in other words, each bucket boundary is the previous boundary times 2^(2^-n).
	// In the future, more bucket schemas may be added using numbers < -4 or > 8.
	Schema         int32
	ZeroThreshold  float64
	ZeroCount      uint64
	ZeroCountFloat float64
	// Negative buckets for the native histogram.
	NegativeSpan []*BucketSpan
	// Use either "negative_delta" or "negative_count", the former for
	// regular histograms with integer counts, the latter for float
	// histograms.
	NegativeDelta []int64
	NegativeCount []float64
	// Positive buckets for the native histogram.
	// Use a no-op span (offset 0, length 0) for a native histogram without any
	// observations yet and with a zero_threshold of 0. Otherwise, it would be
	// indistinguishable from a classic histogram.
	PositiveSpan []*BucketSpan
	// Use either "positive_delta" or "positive_count", the former for
	// regular histograms with integer counts, the latter for float
	// histograms.
	PositiveDelta []int64
	PositiveCount []float64
	// Only used for native histograms. These exemplars MUST have a timestamp.
	Exemplars []*Exemplar
}

func (b0 Histogram_builder) Build() *Histogram {
	m0 := &Histogram{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_SampleCount = b.SampleCount
	x.xxx_hidden_SampleCountFloat = b.SampleCountFloat
	x.xxx_hidden_SampleSum = b.SampleSum
	x.xxx_hidden_Bucket = &b.Bucket
	x.xxx_hidden_CreatedTimestamp = b.CreatedTimestamp
	x.xxx_hidden_Schema = b.Schema
	x.xxx_hidden_ZeroThreshold = b.ZeroThreshold
	x.xxx_hidden_ZeroCount = b.ZeroCount
	x.xxx_hidden_ZeroCountFloat = b.ZeroCountFloat
	x.xxx_hidden_NegativeSpan = &b.NegativeSpan
	x.xxx_hidden_NegativeDelta = b.NegativeDelta
	x.xxx_hidden_NegativeCount = b.NegativeCount
	x.xxx_hidden_PositiveSpan = &b.PositiveSpan
	x.xxx_hidden_PositiveDelta = b.PositiveDelta
	x.xxx_hidden_PositiveCount = b.PositiveCount
	x.xxx_hidden_Exemplars = &b.Exemplars
	return m0
}

type Bucket struct {
	state                           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_CumulativeCount      uint64                 `protobuf:"varint,1,opt,name=cumulative_count,json=cumulativeCount,proto3"`
	xxx_hidden_CumulativeCountFloat float64                `protobuf:"fixed64,4,opt,name=cumulative_count_float,json=cumulativeCountFloat,proto3"`
	xxx_hidden_UpperBound           float64                `protobuf:"fixed64,2,opt,name=upper_bound,json=upperBound,proto3"`
	xxx_hidden_Exemplar             *Exemplar              `protobuf:"bytes,3,opt,name=exemplar,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *Bucket) Reset() {
	*x = Bucket{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Bucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket) ProtoMessage() {}

func (x *Bucket) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Bucket) GetCumulativeCount() uint64 {
	if x != nil {
		return x.xxx_hidden_CumulativeCount
	}
	return 0
}

func (x *Bucket) GetCumulativeCountFloat() float64 {
	if x != nil {
		return x.xxx_hidden_CumulativeCountFloat
	}
	return 0
}

func (x *Bucket) GetUpperBound() float64 {
	if x != nil {
		return x.xxx_hidden_UpperBound
	}
	return 0
}

func (x *Bucket) GetExemplar() *Exemplar {
	if x != nil {
		return x.xxx_hidden_Exemplar
	}
	return nil
}

func (x *Bucket) SetCumulativeCount(v uint64) {
	x.xxx_hidden_CumulativeCount = v
}

func (x *Bucket) SetCumulativeCountFloat(v float64) {
	x.xxx_hidden_CumulativeCountFloat = v
}

func (x *Bucket) SetUpperBound(v float64) {
	x.xxx_hidden_UpperBound = v
}

func (x *Bucket) SetExemplar(v *Exemplar) {
	x.xxx_hidden_Exemplar = v
}

func (x *Bucket) HasExemplar() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Exemplar != nil
}

func (x *Bucket) ClearExemplar() {
	x.xxx_hidden_Exemplar = nil
}

type Bucket_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	CumulativeCount      uint64
	CumulativeCountFloat float64
	UpperBound           float64
	Exemplar             *Exemplar
}

func (b0 Bucket_builder) Build() *Bucket {
	m0 := &Bucket{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_CumulativeCount = b.CumulativeCount
	x.xxx_hidden_CumulativeCountFloat = b.CumulativeCountFloat
	x.xxx_hidden_UpperBound = b.UpperBound
	x.xxx_hidden_Exemplar = b.Exemplar
	return m0
}

// A BucketSpan defines a number of consecutive buckets in a native
// histogram with their offset. Logically, it would be more
// straightforward to include the bucket counts in the Span. However,
// the protobuf representation is more compact in the way the data is
// structured here (with all the buckets in a single array separate
// from the Spans).
type BucketSpan struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Offset int32                  `protobuf:"zigzag32,1,opt,name=offset,proto3"`
	xxx_hidden_Length uint32                 `protobuf:"varint,2,opt,name=length,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *BucketSpan) Reset() {
	*x = BucketSpan{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BucketSpan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketSpan) ProtoMessage() {}

func (x *BucketSpan) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *BucketSpan) GetOffset() int32 {
	if x != nil {
		return x.xxx_hidden_Offset
	}
	return 0
}

func (x *BucketSpan) GetLength() uint32 {
	if x != nil {
		return x.xxx_hidden_Length
	}
	return 0
}

func (x *BucketSpan) SetOffset(v int32) {
	x.xxx_hidden_Offset = v
}

func (x *BucketSpan) SetLength(v uint32) {
	x.xxx_hidden_Length = v
}

type BucketSpan_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Offset int32
	Length uint32
}

func (b0 BucketSpan_builder) Build() *BucketSpan {
	m0 := &BucketSpan{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Offset = b.Offset
	x.xxx_hidden_Length = b.Length
	return m0
}

type Exemplar struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Label     *[]*LabelPair          `protobuf:"bytes,1,rep,name=label,proto3"`
	xxx_hidden_Value     float64                `protobuf:"fixed64,2,opt,name=value,proto3"`
	xxx_hidden_Timestamp *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=timestamp,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *Exemplar) Reset() {
	*x = Exemplar{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Exemplar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Exemplar) ProtoMessage() {}

func (x *Exemplar) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Exemplar) GetLabel() []*LabelPair {
	if x != nil {
		if x.xxx_hidden_Label != nil {
			return *x.xxx_hidden_Label
		}
	}
	return nil
}

func (x *Exemplar) GetValue() float64 {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return 0
}

func (x *Exemplar) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_Timestamp
	}
	return nil
}

func (x *Exemplar) SetLabel(v []*LabelPair) {
	x.xxx_hidden_Label = &v
}

func (x *Exemplar) SetValue(v float64) {
	x.xxx_hidden_Value = v
}

func (x *Exemplar) SetTimestamp(v *timestamppb.Timestamp) {
	x.xxx_hidden_Timestamp = v
}

func (x *Exemplar) HasTimestamp() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Timestamp != nil
}

func (x *Exemplar) ClearTimestamp() {
	x.xxx_hidden_Timestamp = nil
}

type Exemplar_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Label     []*LabelPair
	Value     float64
	Timestamp *timestamppb.Timestamp
}

func (b0 Exemplar_builder) Build() *Exemplar {
	m0 := &Exemplar{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Label = &b.Label
	x.xxx_hidden_Value = b.Value
	x.xxx_hidden_Timestamp = b.Timestamp
	return m0
}

type Metric struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Label       *[]*LabelPair          `protobuf:"bytes,1,rep,name=label,proto3"`
	xxx_hidden_Gauge       *Gauge                 `protobuf:"bytes,2,opt,name=gauge,proto3"`
	xxx_hidden_Counter     *Counter               `protobuf:"bytes,3,opt,name=counter,proto3"`
	xxx_hidden_Summary     *Summary               `protobuf:"bytes,4,opt,name=summary,proto3"`
	xxx_hidden_Untyped     *Untyped               `protobuf:"bytes,5,opt,name=untyped,proto3"`
	xxx_hidden_Histogram   *Histogram             `protobuf:"bytes,7,opt,name=histogram,proto3"`
	xxx_hidden_TimestampMs int64                  `protobuf:"varint,6,opt,name=timestamp_ms,json=timestampMs,proto3"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *Metric) Reset() {
	*x = Metric{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metric) ProtoMessage() {}

func (x *Metric) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Metric) GetLabel() []*LabelPair {
	if x != nil {
		if x.xxx_hidden_Label != nil {
			return *x.xxx_hidden_Label
		}
	}
	return nil
}

func (x *Metric) GetGauge() *Gauge {
	if x != nil {
		return x.xxx_hidden_Gauge
	}
	return nil
}

func (x *Metric) GetCounter() *Counter {
	if x != nil {
		return x.xxx_hidden_Counter
	}
	return nil
}

func (x *Metric) GetSummary() *Summary {
	if x != nil {
		return x.xxx_hidden_Summary
	}
	return nil
}

func (x *Metric) GetUntyped() *Untyped {
	if x != nil {
		return x.xxx_hidden_Untyped
	}
	return nil
}

func (x *Metric) GetHistogram() *Histogram {
	if x != nil {
		return x.xxx_hidden_Histogram
	}
	return nil
}

func (x *Metric) GetTimestampMs() int64 {
	if x != nil {
		return x.xxx_hidden_TimestampMs
	}
	return 0
}

func (x *Metric) SetLabel(v []*LabelPair) {
	x.xxx_hidden_Label = &v
}

func (x *Metric) SetGauge(v *Gauge) {
	x.xxx_hidden_Gauge = v
}

func (x *Metric) SetCounter(v *Counter) {
	x.xxx_hidden_Counter = v
}

func (x *Metric) SetSummary(v *Summary) {
	x.xxx_hidden_Summary = v
}

func (x *Metric) SetUntyped(v *Untyped) {
	x.xxx_hidden_Untyped = v
}

func (x *Metric) SetHistogram(v *Histogram) {
	x.xxx_hidden_Histogram = v
}

func (x *Metric) SetTimestampMs(v int64) {
	x.xxx_hidden_TimestampMs = v
}

func (x *Metric) HasGauge() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Gauge != nil
}

func (x *Metric) HasCounter() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Counter != nil
}

func (x *Metric) HasSummary() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Summary != nil
}

func (x *Metric) HasUntyped() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Untyped != nil
}

func (x *Metric) HasHistogram() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Histogram != nil
}

func (x *Metric) ClearGauge() {
	x.xxx_hidden_Gauge = nil
}

func (x *Metric) ClearCounter() {
	x.xxx_hidden_Counter = nil
}

func (x *Metric) ClearSummary() {
	x.xxx_hidden_Summary = nil
}

func (x *Metric) ClearUntyped() {
	x.xxx_hidden_Untyped = nil
}

func (x *Metric) ClearHistogram() {
	x.xxx_hidden_Histogram = nil
}

type Metric_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Label       []*LabelPair
	Gauge       *Gauge
	Counter     *Counter
	Summary     *Summary
	Untyped     *Untyped
	Histogram   *Histogram
	TimestampMs int64
}

func (b0 Metric_builder) Build() *Metric {
	m0 := &Metric{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Label = &b.Label
	x.xxx_hidden_Gauge = b.Gauge
	x.xxx_hidden_Counter = b.Counter
	x.xxx_hidden_Summary = b.Summary
	x.xxx_hidden_Untyped = b.Untyped
	x.xxx_hidden_Histogram = b.Histogram
	x.xxx_hidden_TimestampMs = b.TimestampMs
	return m0
}

type MetricFamily struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name   string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Help   string                 `protobuf:"bytes,2,opt,name=help,proto3"`
	xxx_hidden_Type   MetricType             `protobuf:"varint,3,opt,name=type,proto3,enum=io.prometheus.client.MetricType"`
	xxx_hidden_Metric *[]*Metric             `protobuf:"bytes,4,rep,name=metric,proto3"`
	xxx_hidden_Unit   string                 `protobuf:"bytes,5,opt,name=unit,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *MetricFamily) Reset() {
	*x = MetricFamily{}
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricFamily) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricFamily) ProtoMessage() {}

func (x *MetricFamily) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_client_metrics_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MetricFamily) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *MetricFamily) GetHelp() string {
	if x != nil {
		return x.xxx_hidden_Help
	}
	return ""
}

func (x *MetricFamily) GetType() MetricType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return MetricType_COUNTER
}

func (x *MetricFamily) GetMetric() []*Metric {
	if x != nil {
		if x.xxx_hidden_Metric != nil {
			return *x.xxx_hidden_Metric
		}
	}
	return nil
}

func (x *MetricFamily) GetUnit() string {
	if x != nil {
		return x.xxx_hidden_Unit
	}
	return ""
}

func (x *MetricFamily) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *MetricFamily) SetHelp(v string) {
	x.xxx_hidden_Help = v
}

func (x *MetricFamily) SetType(v MetricType) {
	x.xxx_hidden_Type = v
}

func (x *MetricFamily) SetMetric(v []*Metric) {
	x.xxx_hidden_Metric = &v
}

func (x *MetricFamily) SetUnit(v string) {
	x.xxx_hidden_Unit = v
}

type MetricFamily_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name   string
	Help   string
	Type   MetricType
	Metric []*Metric
	Unit   string
}

func (b0 MetricFamily_builder) Build() *MetricFamily {
	m0 := &MetricFamily{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Help = b.Help
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_Metric = &b.Metric
	x.xxx_hidden_Unit = b.Unit
	return m0
}

var File_io_prometheus_client_metrics_proto protoreflect.FileDescriptor

var file_io_prometheus_client_metrics_proto_rawDesc = string([]byte{
	0x0a, 0x22, 0x69, 0x6f, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x14, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68,
	0x65, 0x75, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x1a, 0x14, 0x67, 0x6f, 0x67, 0x6f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x67, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x35, 0x0a, 0x09, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x61, 0x69, 0x72, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x1d, 0x0a, 0x05, 0x47, 0x61, 0x75, 0x67,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x07, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x78, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x69, 0x6f,
	0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x45, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x52, 0x08, 0x65, 0x78, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x72, 0x12, 0x47, 0x0a, 0x11, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x3c,
	0x0a, 0x08, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x71, 0x75,
	0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x71, 0x75,
	0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xd6, 0x01, 0x0a,
	0x07, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x75, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x09, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x75, 0x6d, 0x12, 0x40, 0x0a, 0x08, 0x71, 0x75,
	0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x69,
	0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x42, 0x04, 0xc8, 0xde,
	0x1f, 0x00, 0x52, 0x08, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x12, 0x47, 0x0a, 0x11,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x1f, 0x0a, 0x07, 0x55, 0x6e, 0x74, 0x79, 0x70, 0x65, 0x64,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xfc, 0x05, 0x0a, 0x09, 0x48, 0x69, 0x73, 0x74, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x10, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x46, 0x6c, 0x6f, 0x61, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x73, 0x75, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x73, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x53, 0x75, 0x6d, 0x12, 0x3a, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74,
	0x68, 0x65, 0x75, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x42, 0x04, 0xc8, 0xde, 0x1f, 0x00, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x12, 0x47, 0x0a, 0x11, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x11, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x12, 0x25, 0x0a, 0x0e, 0x7a, 0x65, 0x72, 0x6f, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0d, 0x7a, 0x65, 0x72, 0x6f, 0x54,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x7a, 0x65, 0x72, 0x6f,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x7a, 0x65,
	0x72, 0x6f, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x7a, 0x65, 0x72, 0x6f, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x0e, 0x7a, 0x65, 0x72, 0x6f, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x46, 0x6c, 0x6f, 0x61,
	0x74, 0x12, 0x4b, 0x0a, 0x0d, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x70,
	0x61, 0x6e, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x69, 0x6f, 0x2e, 0x70, 0x72,
	0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x61, 0x6e, 0x42, 0x04, 0xc8, 0xde, 0x1f, 0x00,
	0x52, 0x0c, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x25,
	0x0a, 0x0e, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x74, 0x61,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x12, 0x52, 0x0d, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x44, 0x65, 0x6c, 0x74, 0x61, 0x12, 0x25, 0x0a, 0x0e, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x01, 0x52, 0x0d, 0x6e,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x0d,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x70, 0x61, 0x6e, 0x18, 0x0c, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68,
	0x65, 0x75, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x53, 0x70, 0x61, 0x6e, 0x42, 0x04, 0xc8, 0xde, 0x1f, 0x00, 0x52, 0x0c, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x74, 0x61, 0x18, 0x0d, 0x20, 0x03, 0x28,
	0x12, 0x52, 0x0d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6c, 0x74, 0x61,
	0x12, 0x25, 0x0a, 0x0e, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x01, 0x52, 0x0d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69,
	0x76, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x09, 0x65, 0x78, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x72, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x69, 0x6f, 0x2e,
	0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x45, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x52, 0x09, 0x65, 0x78, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x72, 0x73, 0x22, 0xc6, 0x01, 0x0a, 0x06, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x12, 0x29, 0x0a, 0x10, 0x63, 0x75, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x63, 0x75, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x63,
	0x75, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x66, 0x6c, 0x6f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x14, 0x63, 0x75, 0x6d,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x46, 0x6c, 0x6f, 0x61,
	0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x70, 0x65, 0x72, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74,
	0x68, 0x65, 0x75, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x78, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x72, 0x52, 0x08, 0x65, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x22, 0x3c,
	0x0a, 0x0a, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x16, 0x0a, 0x06,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x11, 0x52, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0x97, 0x01, 0x0a,
	0x08, 0x45, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x12, 0x3b, 0x0a, 0x05, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x69, 0x6f, 0x2e, 0x70, 0x72,
	0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x61, 0x69, 0x72, 0x42, 0x04, 0xc8, 0xde, 0x1f, 0x00, 0x52,
	0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x38, 0x0a, 0x09,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x85, 0x03, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x12, 0x3b, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73,
	0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x61, 0x69,
	0x72, 0x42, 0x04, 0xc8, 0xde, 0x1f, 0x00, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x31,
	0x0a, 0x05, 0x67, 0x61, 0x75, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x47, 0x61, 0x75, 0x67, 0x65, 0x52, 0x05, 0x67, 0x61, 0x75, 0x67,
	0x65, 0x12, 0x37, 0x0a, 0x07, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65,
	0x75, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65,
	0x72, 0x52, 0x07, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x37, 0x0a, 0x07, 0x73, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x69, 0x6f,
	0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x12, 0x37, 0x0a, 0x07, 0x75, 0x6e, 0x74, 0x79, 0x70, 0x65, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74,
	0x68, 0x65, 0x75, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x55, 0x6e, 0x74, 0x79,
	0x70, 0x65, 0x64, 0x52, 0x07, 0x75, 0x6e, 0x74, 0x79, 0x70, 0x65, 0x64, 0x12, 0x3d, 0x0a, 0x09,
	0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x52, 0x09, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x21, 0x0a, 0x0c, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4d, 0x73, 0x22, 0xbc,
	0x01, 0x0a, 0x0c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x65, 0x6c, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x68, 0x65, 0x6c, 0x70, 0x12, 0x34, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65,
	0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x3a, 0x0a,
	0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x42, 0x04, 0xc8, 0xde, 0x1f,
	0x00, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x2a, 0x62, 0x0a,
	0x0a, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x43,
	0x4f, 0x55, 0x4e, 0x54, 0x45, 0x52, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x47, 0x41, 0x55, 0x47,
	0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x4d, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x02,
	0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x54, 0x59, 0x50, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a,
	0x09, 0x48, 0x49, 0x53, 0x54, 0x4f, 0x47, 0x52, 0x41, 0x4d, 0x10, 0x04, 0x12, 0x13, 0x0a, 0x0f,
	0x47, 0x41, 0x55, 0x47, 0x45, 0x5f, 0x48, 0x49, 0x53, 0x54, 0x4f, 0x47, 0x52, 0x41, 0x4d, 0x10,
	0x05, 0x42, 0x50, 0x5a, 0x4e, 0x62, 0x75, 0x66, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x67,
	0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73,
	0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2f, 0x67, 0x6f, 0x2f, 0x69,
	0x6f, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var file_io_prometheus_client_metrics_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_io_prometheus_client_metrics_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_io_prometheus_client_metrics_proto_goTypes = []any{
	(MetricType)(0),               // 0: io.prometheus.client.MetricType
	(*LabelPair)(nil),             // 1: io.prometheus.client.LabelPair
	(*Gauge)(nil),                 // 2: io.prometheus.client.Gauge
	(*Counter)(nil),               // 3: io.prometheus.client.Counter
	(*Quantile)(nil),              // 4: io.prometheus.client.Quantile
	(*Summary)(nil),               // 5: io.prometheus.client.Summary
	(*Untyped)(nil),               // 6: io.prometheus.client.Untyped
	(*Histogram)(nil),             // 7: io.prometheus.client.Histogram
	(*Bucket)(nil),                // 8: io.prometheus.client.Bucket
	(*BucketSpan)(nil),            // 9: io.prometheus.client.BucketSpan
	(*Exemplar)(nil),              // 10: io.prometheus.client.Exemplar
	(*Metric)(nil),                // 11: io.prometheus.client.Metric
	(*MetricFamily)(nil),          // 12: io.prometheus.client.MetricFamily
	(*timestamppb.Timestamp)(nil), // 13: google.protobuf.Timestamp
}
var file_io_prometheus_client_metrics_proto_depIdxs = []int32{
	10, // 0: io.prometheus.client.Counter.exemplar:type_name -> io.prometheus.client.Exemplar
	13, // 1: io.prometheus.client.Counter.created_timestamp:type_name -> google.protobuf.Timestamp
	4,  // 2: io.prometheus.client.Summary.quantile:type_name -> io.prometheus.client.Quantile
	13, // 3: io.prometheus.client.Summary.created_timestamp:type_name -> google.protobuf.Timestamp
	8,  // 4: io.prometheus.client.Histogram.bucket:type_name -> io.prometheus.client.Bucket
	13, // 5: io.prometheus.client.Histogram.created_timestamp:type_name -> google.protobuf.Timestamp
	9,  // 6: io.prometheus.client.Histogram.negative_span:type_name -> io.prometheus.client.BucketSpan
	9,  // 7: io.prometheus.client.Histogram.positive_span:type_name -> io.prometheus.client.BucketSpan
	10, // 8: io.prometheus.client.Histogram.exemplars:type_name -> io.prometheus.client.Exemplar
	10, // 9: io.prometheus.client.Bucket.exemplar:type_name -> io.prometheus.client.Exemplar
	1,  // 10: io.prometheus.client.Exemplar.label:type_name -> io.prometheus.client.LabelPair
	13, // 11: io.prometheus.client.Exemplar.timestamp:type_name -> google.protobuf.Timestamp
	1,  // 12: io.prometheus.client.Metric.label:type_name -> io.prometheus.client.LabelPair
	2,  // 13: io.prometheus.client.Metric.gauge:type_name -> io.prometheus.client.Gauge
	3,  // 14: io.prometheus.client.Metric.counter:type_name -> io.prometheus.client.Counter
	5,  // 15: io.prometheus.client.Metric.summary:type_name -> io.prometheus.client.Summary
	6,  // 16: io.prometheus.client.Metric.untyped:type_name -> io.prometheus.client.Untyped
	7,  // 17: io.prometheus.client.Metric.histogram:type_name -> io.prometheus.client.Histogram
	0,  // 18: io.prometheus.client.MetricFamily.type:type_name -> io.prometheus.client.MetricType
	11, // 19: io.prometheus.client.MetricFamily.metric:type_name -> io.prometheus.client.Metric
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_io_prometheus_client_metrics_proto_init() }
func file_io_prometheus_client_metrics_proto_init() {
	if File_io_prometheus_client_metrics_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_io_prometheus_client_metrics_proto_rawDesc), len(file_io_prometheus_client_metrics_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_io_prometheus_client_metrics_proto_goTypes,
		DependencyIndexes: file_io_prometheus_client_metrics_proto_depIdxs,
		EnumInfos:         file_io_prometheus_client_metrics_proto_enumTypes,
		MessageInfos:      file_io_prometheus_client_metrics_proto_msgTypes,
	}.Build()
	File_io_prometheus_client_metrics_proto = out.File
	file_io_prometheus_client_metrics_proto_goTypes = nil
	file_io_prometheus_client_metrics_proto_depIdxs = nil
}
