# The WAMP DAO: Preamble

The Web Application Messaging Protocol (WAMP) is an application messaging protocol that aims to free and shield **application developers** and decouple application code and application communication from the details of

* *programming languages and run-times*,
* *networking infrastructures, transport protocols and payload serializations*,
* *deployment* of application code to compute infrastructures (**“distributed”**),

and free and unbind application users and operators from

* *operational dependencies* between each other (**“decentralized”**).

## Application-oriented Decentralized Dataplane

In it’s most general form, a WAMP based application runs over a network of interconnected (via “Router-to-Router Links”) WAMP router nodes and operated by one or more node operators, and WAMP application clients connected to these nodes. The WAMP routers route and forward WAMP messages to provide a transparent view from the WAMP application clients with Remote-Procedure-Call and Publish-Subscribe messaging patterns to allow uniform and seamless integration of application components. This way, WAMP enables distributed and decentralized components of an application to act and work as a whole, removing limits and making boundaries invisible to application code developers. WAMP Clients, WAMP Routers and WAMP Applications can be controlled, owned and operated by and isolated between different parties but still integrate seamlessly. Thus, WAMP provides the communication
infrastructure for an *Application-oriented Decentralized Dataplane (ADD)*.

WAMP enables self-sovereign use and hosting of the respective application resources by each party, and applications that are governed to be:

1. open
2. permissionless
3. censorship-resistant
4. decentralized
5. trustless (non-custodial)
6. privacy-respecting
7. anti-fragile

## Antifragility

The goal is to get the protocol to a point where it is resistant to capture, whether from a nation state or an individual malicious actor. The goal is to remove (all) central points of control and thereby ensure the protocol cannot be censored or captured. Ultimately this is the dimension on which every decentralised protocol must be measured: is it unstoppable?

In order for the protocol to deliver on its potential it must become an open and unstoppable protocol. But further, we must ensure that it is not just robust against attack, but antifragile. It must gain from being attacked.

*Source: adapted from Kain Warwick (Founder Synthetix) on [Transition to decentralised governance](https://blog.synthetix.io/transition-to-decentralised-governance/).*
