/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

public class DriverPathSvg
extends DriverShadowedG2d
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverPathSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        UPath shape = (UPath)ushape;
        String color = StringUtils.getAsSvg(mapper, param.getColor());
        if (shape.isOpenIconic()) {
            svg.setFillColor(color);
            svg.setStrokeColor("");
            svg.setStrokeWidth(0.0, "");
        } else {
            HtmlColor back = param.getBackcolor();
            if (back instanceof HtmlColorGradient) {
                HtmlColorGradient gr = (HtmlColorGradient)back;
                String id = svg.createSvgGradient(StringUtils.getAsHtml(mapper.getMappedColor(gr.getColor1())), StringUtils.getAsHtml(mapper.getMappedColor(gr.getColor2())), gr.getPolicy());
                svg.setFillColor("url(#" + id + ")");
            } else {
                String backcolor = StringUtils.getAsSvg(mapper, back);
                svg.setFillColor(backcolor);
            }
            svg.setStrokeColor(color);
            svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        }
        svg.svgPath(x, y, shape, shape.getDeltaShadow());
    }
}

