/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.SnakeDirection;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.CompressionTransform;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Snake
implements UShape {
    private final List<Point2D.Double> points = new ArrayList<Point2D.Double>();
    private final UPolygon endDecoration;
    private final HtmlColor color;
    private TextBlock textBlock;
    private boolean mergeable = true;
    private Direction emphasizeDirection;

    public Snake transformX(CompressionTransform compressionTransform) {
        Snake result = new Snake(this.color, this.endDecoration);
        result.textBlock = this.textBlock;
        result.mergeable = this.mergeable;
        result.emphasizeDirection = this.emphasizeDirection;
        for (Point2D.Double pt : this.points) {
            double x = compressionTransform.transform(pt.x);
            double y = pt.y;
            result.addPoint(x, y);
        }
        return result;
    }

    public Snake(HtmlColor color, UPolygon endDecoration) {
        this.endDecoration = endDecoration;
        this.color = color;
    }

    public Snake(HtmlColor color) {
        this(color, null);
    }

    public void setLabel(TextBlock label) {
        this.textBlock = label;
    }

    public Snake move(double dx, double dy) {
        Snake result = new Snake(this.color, this.endDecoration);
        for (Point2D point2D : this.points) {
            result.addPoint(point2D.getX() + dx, point2D.getY() + dy);
        }
        result.textBlock = this.textBlock;
        result.mergeable = this.mergeable;
        result.emphasizeDirection = this.emphasizeDirection;
        return result;
    }

    public Snake translate(UTranslate translate) {
        return this.move(translate.getDx(), translate.getDy());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            result.append((Object)((Object)this.getDirectionAtPoint(i)) + " ");
        }
        return result + this.points.toString();
    }

    SnakeDirection getDirection() {
        if (this.points.size() < 2) {
            throw new IllegalStateException();
        }
        return SnakeDirection.getDirection(this.points.get(0), this.points.get(1));
    }

    public void addPoint(double x, double y) {
        this.points.add(new Point2D.Double(x, y));
    }

    public void addPoint(Point2D p) {
        this.addPoint(p.getX(), p.getY());
    }

    public void drawInternal(UGraphic ug) {
        ug = ug.apply(new UChangeColor(this.color));
        ug = ug.apply(new UChangeBackColor(this.color));
        ug = ug.apply(new UStroke(1.5));
        boolean drawn = false;
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D.Double p1 = this.points.get(i);
            Point2D.Double p2 = this.points.get(i + 1);
            Line2D.Double line = new Line2D.Double(p1, p2);
            if (!drawn && this.emphasizeDirection != null && Direction.fromVector(p1, p2) == this.emphasizeDirection) {
                this.drawLine(ug, line, this.emphasizeDirection);
                drawn = true;
                continue;
            }
            this.drawLine(ug, line, null);
        }
        if (this.endDecoration != null) {
            Point2D end = this.points.get(this.points.size() - 1);
            ug.apply(new UTranslate(end)).apply(new UStroke()).draw(this.endDecoration);
        }
        if (this.textBlock != null) {
            Point2D position = this.getTextBlockPosition(ug.getStringBounder());
            this.textBlock.drawU(ug.apply(new UTranslate(position)));
        }
    }

    public double getMaxX(StringBounder stringBounder) {
        double result = -1.7976931348623157E308;
        for (Point2D point2D : this.points) {
            result = Math.max(result, point2D.getX());
        }
        if (this.textBlock != null) {
            Point2D position = this.getTextBlockPosition(stringBounder);
            Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
            result = Math.max(result, position.getX() + dimension2D.getWidth());
        }
        return result;
    }

    private Point2D getTextBlockPosition(StringBounder stringBounder) {
        Point2D pt1 = this.points.get(0);
        Point2D pt2 = this.points.get(1);
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        double y = (pt1.getY() + pt2.getY()) / 2.0 - dim.getHeight() / 2.0;
        return new Point2D.Double(Math.max(pt1.getX(), pt2.getX()) + 4.0, y);
    }

    public List<Line2D> getHorizontalLines() {
        ArrayList<Line2D> result = new ArrayList<Line2D>();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D pt1 = this.points.get(i);
            Point2D pt2 = this.points.get(i + 1);
            if (pt1.getY() != pt2.getY()) continue;
            Line2D.Double line = new Line2D.Double(pt1, pt2);
            result.add(line);
        }
        return result;
    }

    private Point2D getFirst() {
        return this.points.get(0);
    }

    public Point2D getLast() {
        return this.points.get(this.points.size() - 1);
    }

    private boolean same(Point2D pt1, Point2D pt2) {
        return pt1.distance(pt2) < 0.001;
    }

    public Snake merge(Snake other) {
        if (!this.mergeable || !other.mergeable) {
            return null;
        }
        if (!TextBlockUtils.isEmpty(other.textBlock)) {
            return null;
        }
        if (this.same(this.getLast(), other.getFirst())) {
            UPolygon oneOf = this.endDecoration == null ? other.endDecoration : this.endDecoration;
            Snake result = new Snake(this.color, oneOf);
            result.textBlock = this.textBlock == null ? other.textBlock : this.textBlock;
            result.emphasizeDirection = this.emphasizeDirection == null ? other.emphasizeDirection : this.emphasizeDirection;
            result.points.addAll(this.points);
            result.points.addAll(other.points);
            result.mergeMe();
            return result;
        }
        if (this.same(this.getFirst(), other.getLast())) {
            return other.merge(this);
        }
        return null;
    }

    private void mergeMe() {
        boolean change = false;
        do {
            change = (change = false) || this.removeNullVector();
            change = change || this.removeRedondantDirection();
            change = change || this.removePattern1();
            change = change || this.removePattern2();
            change = change || this.removePattern3();
            change = change || this.removePattern4();
            change = change || this.removePattern5();
            change = change || this.removePattern6();
        } while (change = change || this.removePattern7());
    }

    private boolean removeNullVector() {
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Direction dir = this.getDirectionAtPoint(i);
            if (dir != null) continue;
            this.points.remove(i);
            return true;
        }
        return false;
    }

    private boolean removeRedondantDirection() {
        for (int i = 0; i < this.points.size() - 2; ++i) {
            Direction dir2;
            Direction dir1 = this.getDirectionAtPoint(i);
            if (dir1 != (dir2 = this.getDirectionAtPoint(i + 1))) continue;
            this.points.remove(i + 1);
            return true;
        }
        return false;
    }

    private boolean removePattern1() {
        for (int i = 0; i < this.points.size() - 5; ++i) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (!Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.RIGHT).equals(patternAt) && !Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.LEFT).equals(patternAt)) continue;
            Point2D.Double newPoint = new Point2D.Double(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, newPoint);
            return true;
        }
        return false;
    }

    private boolean removePattern7() {
        if (this.points.size() > 4) {
            boolean i = false;
            List<Direction> patternAt = this.getPatternAt(0);
            if (Arrays.asList(Direction.RIGHT, Direction.DOWN, Direction.LEFT, Direction.DOWN).equals(patternAt) && this.points.get((int)3).x > this.points.get((int)0).x) {
                Point2D.Double newPoint = new Point2D.Double(this.points.get((int)3).x, this.points.get((int)0).y);
                this.points.remove(2);
                this.points.remove(1);
                this.points.add(1, newPoint);
                return true;
            }
        }
        return false;
    }

    private boolean removePattern2() {
        for (int i = 0; i < this.points.size() - 5; ++i) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (!Arrays.asList(Direction.RIGHT, Direction.DOWN, Direction.RIGHT, Direction.UP).equals(patternAt) && !Arrays.asList(Direction.LEFT, Direction.DOWN, Direction.LEFT, Direction.UP).equals(patternAt)) continue;
            Point2D.Double newPoint = new Point2D.Double(this.points.get((int)(i + 3)).x, this.points.get((int)(i + 1)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, newPoint);
            return true;
        }
        return false;
    }

    private boolean removePattern3() {
        for (int i = 0; i < this.points.size() - 4; ++i) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (!Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.RIGHT).equals(patternAt) && !Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.LEFT).equals(patternAt)) continue;
            Point2D.Double newPoint = new Point2D.Double(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, newPoint);
            return true;
        }
        return false;
    }

    private boolean removePattern4() {
        int i = this.points.size() - 5;
        if (i >= 0) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.RIGHT).equals(patternAt)) {
                Point2D.Double p1 = this.points.get(i + 1);
                Point2D.Double p4 = this.points.get(i + 4);
                if (p4.x > p1.x) {
                    Point2D.Double newPoint = new Point2D.Double(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
                    this.points.remove(i + 3);
                    this.points.remove(i + 2);
                    this.points.remove(i + 1);
                    this.points.add(i + 1, newPoint);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean removePattern5() {
        int i = this.points.size() - 5;
        if (i >= 0) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.LEFT).equals(patternAt)) {
                Point2D.Double p1 = this.points.get(i + 1);
                Point2D.Double p4 = this.points.get(i + 4);
                if (p4.x + 4.0 < p1.x) {
                    Point2D.Double newPoint = new Point2D.Double(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
                    this.points.remove(i + 3);
                    this.points.remove(i + 2);
                    this.points.remove(i + 1);
                    this.points.add(i + 1, newPoint);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean removePattern6() {
        for (int i = 0; i < this.points.size() - 2; ++i) {
            if (!this.isForwardAndBackwardAt(i)) continue;
            this.points.remove(i + 1);
            return true;
        }
        return false;
    }

    private List<Direction> getPatternAt(int i) {
        return Arrays.asList(this.getDirectionAtPoint(i), this.getDirectionAtPoint(i + 1), this.getDirectionAtPoint(i + 2), this.getDirectionAtPoint(i + 3));
    }

    private boolean isForwardAndBackwardAt(int i) {
        return this.getDirectionAtPoint(i) == this.getDirectionAtPoint(i + 1).getInv();
    }

    private Direction getDirectionAtPoint(int i) {
        return Direction.fromVector(this.points.get(i), this.points.get(i + 1));
    }

    private void drawLine(UGraphic ug, Line2D line, Direction direction) {
        this.drawLine(ug, line.getX1(), line.getY1(), line.getX2(), line.getY2(), direction);
    }

    private void drawLine(UGraphic ug, double x1, double y1, double x2, double y2, Direction direction) {
        ug = ug.apply(new UTranslate(x1, y1));
        if (direction != null) {
            ug.apply(new UTranslate((x2 - x1) / 2.0, (y2 - y1) / 2.0)).draw(Arrows.asTo(direction));
        }
        ug.draw(new ULine(x2 - x1, y2 - y1));
    }

    public void goUnmergeable() {
        this.mergeable = false;
    }

    public void emphasizeDirection(Direction direction) {
        this.emphasizeDirection = direction;
    }
}

