/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.activitydiagram.ConditionalContext;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.utils.UniqueSequence;

public class ActivityDiagram
extends CucaDiagram {
    private IEntity lastEntityConsulted;
    private IEntity lastEntityBrancheConsulted;
    private ConditionalContext currentContext;

    @Override
    public ILeaf getOrCreateLeaf(Code code, LeafType type, USymbol symbol) {
        return this.getOrCreateLeafDefault(code, type, symbol);
    }

    private String getAutoBranch() {
        return "#" + UniqueSequence.getValue();
    }

    public IEntity getOrCreate(Code code, Display display, LeafType type) {
        ILeaf result;
        if (this.leafExist(code)) {
            result = this.getOrCreateLeafDefault(code, type, null);
            if (result.getEntityType() != type) {
                return null;
            }
        } else {
            result = this.createLeaf(code, display, type, null);
        }
        this.updateLasts(result);
        return result;
    }

    public void startIf(Code optionalCode) {
        ILeaf br = this.createLeaf(optionalCode == null ? Code.of(this.getAutoBranch()) : optionalCode, Display.create(""), LeafType.BRANCH, null);
        this.currentContext = new ConditionalContext(this.currentContext, br, Direction.DOWN);
    }

    public void endif() {
        this.currentContext = this.currentContext.getParent();
    }

    public ILeaf getStart() {
        return (ILeaf)this.getOrCreate(Code.of("start"), Display.getWithNewlines("start"), LeafType.CIRCLE_START);
    }

    public ILeaf getEnd(String suppId) {
        Code code = suppId == null ? Code.of("end") : Code.of("end$" + suppId);
        return (ILeaf)this.getOrCreate(code, Display.getWithNewlines("end"), LeafType.CIRCLE_END);
    }

    private void updateLasts(IEntity result) {
        if (result.getEntityType() == LeafType.NOTE) {
            return;
        }
        this.lastEntityConsulted = result;
        if (result.getEntityType() == LeafType.BRANCH) {
            this.lastEntityBrancheConsulted = result;
        }
    }

    @Override
    public ILeaf createLeaf(Code code, Display display, LeafType type, USymbol symbol) {
        ILeaf result = super.createLeaf(code, display, type, symbol);
        this.updateLasts(result);
        return result;
    }

    public IEntity createNote(Code code, Display display) {
        return super.createLeaf(code, display, LeafType.NOTE, null);
    }

    @Override
    protected final List<String> getDotStrings() {
        return Arrays.asList("nodesep=.20;", "ranksep=0.4;", "edge [fontsize=11,labelfontsize=11];", "node [fontsize=11];");
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(" + this.getLeafssize() + " activities)", this.getClass());
    }

    public IEntity getLastEntityConsulted() {
        return this.lastEntityConsulted;
    }

    @Deprecated
    public IEntity getLastEntityBrancheConsulted() {
        return this.lastEntityBrancheConsulted;
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.ACTIVITY;
    }

    public final ConditionalContext getCurrentContext() {
        return this.currentContext;
    }

    public final void setLastEntityConsulted(IEntity lastEntityConsulted) {
        this.lastEntityConsulted = lastEntityConsulted;
    }

    public IEntity createInnerActivity() {
        Code code = Code.of("##" + UniqueSequence.getValue());
        IGroup g = this.getOrCreateGroup(code, Display.getWithNewlines(code), GroupType.INNER_ACTIVITY, this.getCurrentGroup());
        this.lastEntityConsulted = null;
        this.lastEntityBrancheConsulted = null;
        return g;
    }

    public void concurrentActivity(String name) {
        if (this.getCurrentGroup().getGroupType() == GroupType.CONCURRENT_ACTIVITY) {
            this.endGroup();
        }
        Code code = Code.of("##" + UniqueSequence.getValue());
        if (this.getCurrentGroup().getGroupType() != GroupType.INNER_ACTIVITY) {
            throw new IllegalStateException("type=" + (Object)((Object)this.getCurrentGroup().getGroupType()));
        }
        this.getOrCreateGroup(code, Display.getWithNewlines("code"), GroupType.CONCURRENT_ACTIVITY, this.getCurrentGroup());
        this.lastEntityConsulted = null;
        this.lastEntityBrancheConsulted = null;
    }
}

