
macro(use_static_libs ID)
	if(${ID}_USE_STATIC_LIBS)
		set(_UseStaticLibs_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES ${CMAKE_FIND_LIBRARY_SUFFIXES})
		if(WIN32)
			set(CMAKE_FIND_LIBRARY_SUFFIXES _a.lib .lib .a ${CMAKE_FIND_LIBRARY_SUFFIXES})
		else()
			set(CMAKE_FIND_LIBRARY_SUFFIXES .a)
		endif()
		if(ARGC GREATER 1)
			set(prefix "${ARGV1}")
			set(${prefix}_LIBRARIES     "${${prefix}_STATIC_LIBRARIES}")
			set(${prefix}_LIBRARY_DIRS  "${${prefix}_STATIC_LIBRARY_DIRS}")
			set(${prefix}_LDFLAGS       "${${prefix}_STATIC_LDFLAGS}")
			set(${prefix}_LDFLAGS_OTHER "${${prefix}_STATIC_LDFLAGS_OTHER}")
			set(${prefix}_INCLUDE_DIRS  "${${prefix}_STATIC_INCLUDE_DIRS}")
			set(${prefix}_CFLAGS        "${${prefix}_STATIC_CFLAGS}")
			set(${prefix}_CFLAGS_OTHER  "${${prefix}_STATIC_CFLAGS_OTHER}")
		endif()
	endif()
endmacro()

macro(use_static_libs_restore)
	if(DEFINED _UseStaticLibs_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES)
		set(CMAKE_FIND_LIBRARY_SUFFIXES ${_UseStaticLibs_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES})
		unset(_UseStaticLibs_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES)
	endif()
endmacro()

macro(has_static_libs PREFIX LIBS)
	if(WIN32)
		# On Windows we can't really tell import libraries from proper static libraries.
		set(${PREFIX}_HAS_STATIC_LIBS ${${PREFIX}_USE_STATIC_LIBS})
	else()
		set(${PREFIX}_HAS_STATIC_LIBS 0)
		foreach(lib IN LISTS ${LIBS})
			if(lib MATCHES "\\.a$")
				set(${PREFIX}_HAS_STATIC_LIBS 1)
				break()
			endif()
		endforeach()
	endif()
endmacro()
