% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integer64.R
\name{xor.integer64}
\alias{xor.integer64}
\alias{binattr}
\alias{+.integer64}
\alias{-.integer64}
\alias{\%/\%.integer64}
\alias{\%\%.integer64}
\alias{*.integer64}
\alias{^.integer64}
\alias{/.integer64}
\alias{==.integer64}
\alias{!=.integer64}
\alias{<.integer64}
\alias{<=.integer64}
\alias{>.integer64}
\alias{>=.integer64}
\alias{&.integer64}
\alias{|.integer64}
\title{Binary operators for integer64 vectors}
\usage{
binattr(e1, e2)

\method{+}{integer64}(e1, e2)

\method{-}{integer64}(e1, e2)

\method{\%/\%}{integer64}(e1, e2)

\method{\%\%}{integer64}(e1, e2)

\method{*}{integer64}(e1, e2)

\method{^}{integer64}(e1, e2)

\method{/}{integer64}(e1, e2)

\method{==}{integer64}(e1, e2)

\method{!=}{integer64}(e1, e2)

\method{<}{integer64}(e1, e2)

\method{<=}{integer64}(e1, e2)

\method{>}{integer64}(e1, e2)

\method{>=}{integer64}(e1, e2)

\method{&}{integer64}(e1, e2)

\method{|}{integer64}(e1, e2)

\method{xor}{integer64}(x, y)
}
\arguments{
\item{e1}{an atomic vector of class 'integer64'}

\item{e2}{an atomic vector of class 'integer64'}

\item{x}{an atomic vector of class 'integer64'}

\item{y}{an atomic vector of class 'integer64'}
}
\value{
\code{\link{&}}, \code{\link{|}}, \code{\link[=xor]{xor()}}, \code{\link{!=}}, \code{\link{==}},
\code{\link{<}}, \code{\link{<=}}, \code{\link{>}}, \code{\link{>=}} return a logical vector

\code{\link{^}} and \code{\link{/}} return a double vector

\code{\link{+}}, \code{\link{-}}, \code{\link{*}}, \code{\link{\%/\%}}, \code{\link{\%\%}}
return a vector of class 'integer64'
}
\description{
Binary operators for integer64 vectors.
}
\examples{
  as.integer64(1:12) - 1
  options(integer64_semantics="new")
  d <- 2.5
  i <- as.integer64(5)
  d/i  # new 0.5
  d*i  # new 13
  i*d  # new 13
  options(integer64_semantics="old")
  d/i  # old: 0.4
  d*i  # old: 10
  i*d  # old: 13
}
\seealso{
\code{\link[=format.integer64]{format.integer64()}} \code{\link[=integer64]{integer64()}}
}
\keyword{classes}
\keyword{manip}
