/* $XFree86: xc/programs/Xserver/hw/xfree86/accel/mach64/ativga.c,v 3.7.2.2 2000/02/15 03:47:02 tsi Exp $ */
/***************************************************************************
 * Start of VGA font saving and restoration code.
 * Created: Sun Jun 27 12:50:09 1993 by faith@cs.unc.edu
 *
 * Reference used:
 *   "VGA WONDER Programmer's Reference,"
 *      ATI Technologies, 1991.
 *      Release 1.2 -- Reference #PRG28800
 *      (Part No. 10709B0412)
 *
 * Some code from xf86/vga256/drivers/ati/driver.c, which was written by:
 * Thomas Roell (roell@informatik.tu-muenchen.de), Per Lindqvist
 * (pgd@compuram.bbt.se), Doug Evans (dje@sspiff.UUCP), and Rik Faith
 * (faith@cs.unc.edu).
 *
 * Copyright 1990,91 by Thomas Roell, Dinkelscherben, Germany.
 * Copyright 1993 by Rickard E. Faith
 * Copyright 1993,1994 by Kevin E. Martin, Chapel Hill, North Carolina.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Thomas Roell not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Thomas Roell makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * THOMAS ROELL, PER LINDQVIST, DOUG EVANS, RICKARD E. FAITH AND KEVIN
 * E. MARTIN DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THOMAS ROELL, PER LINDQVIST, DOUG EVANS, RICKARD E. FAITH
 * OR KEVIN E. MARTIN BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 *
 * Modified for the Mach64 by Kevin E. Martin (martin@cs.unc.edu)
 */
/* $XConsortium: ativga.c /main/7 1996/04/01 18:05:35 kaleb $ */

#include "X.h"
#include "misc.h"
#include "input.h"
#include "dix.h"
#include "os.h"
#include "xf86.h"
#include "xf86_OSlib.h"
#include "vga.h"
#include "regmach64.h"
#include "mach64.h"

typedef struct {
   vgaHWRec std;
   unsigned char shadow_crtc[25];
   unsigned char ATIExtRegBank[11]; /* ATI Registers B0,B1,B2,B3,
				       B5, B6,B8,B9, BE,A6,A7 */
} SaveBlock;

pointer        vgaBase  = NULL;
pointer        vgaNewVideoState = NULL;

#define save   ((SaveBlock *)vgaNewVideoState)

int            vgaIOBase;
int            vgaInterlaceType = VGA_DIVIDE_VERT;

/* Keep vgaHW.c happy */
void (*vgaSaveScreenFunc)() = vgaHWSaveScreen;

#define ER_B0   0               /* Extended Register indices (ATIExtRegBank) */
#define ER_B1   1
#define ER_B2   2
#define ER_B3   3
#define ER_B5   4
#define ER_B6   5
#define ER_B8   6
#define ER_B9   7
#define ER_BE   8
#define ER_A6   9
#define ER_A7   10

#define ATIReg0  ATIExtRegBank[ER_B0]
#define ATIReg1  ATIExtRegBank[ER_B1]
#define ATIReg2  ATIExtRegBank[ER_B2]
#define ATIReg3  ATIExtRegBank[ER_B3]
#define ATIReg5  ATIExtRegBank[ER_B5]
#define ATIReg6  ATIExtRegBank[ER_B6]
#define ATIReg8  ATIExtRegBank[ER_B8]
#define ATIReg9  ATIExtRegBank[ER_B9]
#define ATIRegE  ATIExtRegBank[ER_BE]
#define ATIRegA6 ATIExtRegBank[ER_A6]
#define ATIRegA7 ATIExtRegBank[ER_A7]

static int inATI(index)
     int index;
{
   outb(ATIExtReg, index);
   return inb(ATIExtReg + 1);
}

void mach64SaveVGAInfo(screen_idx)
     int screen_idx;
{
   unsigned long saved_lcd_gen_ctrl = 0, lcd_gen_ctrl = 0;
   unsigned char b2_save;
   unsigned char b8_save;
   int i;

   if (!vgaBase) {
      vgaBase = xf86MapVidMem(screen_idx, VGA_REGION, (pointer)0xa0000,
			      64 * 1024);
   }

   vgaIOBase = (inb(0x3cc) & 0x01) ? 0x3D0 : 0x3B0;
   
   if (!mach64IntegratedController) {
     /* Unlock ATI specials */
     outw(ATIExtReg, (((b8_save = inATI(0xb8)) & 0xC0) << 8) | 0xb8);

     b2_save = inATI(0xb2);
     outw(ATIExtReg, 0x00b2);	/* segment select 0 */
   }

   if (mach64LCDPanelID >= 0) {
      if (mach64ChipType == MACH64_LG_ID) {
	 saved_lcd_gen_ctrl = regr(LCD_GEN_CTRL);
	 lcd_gen_ctrl = saved_lcd_gen_ctrl &
	    ~(CRTC_RW_SELECT | SHADOW_EN | SHADOW_RW_EN);
	 regw(LCD_GEN_CTRL, lcd_gen_ctrl);
      } else {
	 outb(ioLCD_INDEX, LCD_GEN_CNTL);
	 saved_lcd_gen_ctrl = inl(ioLCD_DATA);
	 lcd_gen_ctrl = saved_lcd_gen_ctrl &
	    ~(CRTC_RW_SELECT | SHADOW_EN | SHADOW_RW_EN);
	 outl(ioLCD_DATA, lcd_gen_ctrl);
      }
   }

   vgaNewVideoState = vgaHWSave(vgaNewVideoState, sizeof(SaveBlock));
   /* Unlock VGA CRTC */
   outw(vgaIOBase + 4, ((save->std.CRTC[17] & 0x7F) << 8) | 17);

   if (mach64LCDPanelID >= 0) {
      lcd_gen_ctrl |= SHADOW_EN | SHADOW_RW_EN;
      if (mach64ChipType == MACH64_LG_ID) {
	 regw(LCD_GEN_CTRL, lcd_gen_ctrl);
      } else {
	 outb(ioLCD_INDEX, LCD_GEN_CNTL);
	 outl(ioLCD_DATA, lcd_gen_ctrl);
      }

      for (i=0; i<25; i++) {
	 outb(vgaIOBase + 4, i);
	 save->shadow_crtc[i] = inb(vgaIOBase + 5);
      }
      /* Unlock shadow VGA CRTC */
      outw(vgaIOBase + 4, ((save->shadow_crtc[17] & 0x7F) << 8) | 17);

      if (mach64ChipType == MACH64_LG_ID) {
	 regw(LCD_GEN_CTRL, saved_lcd_gen_ctrl);
      } else {
	 outb(ioLCD_INDEX, LCD_GEN_CNTL);
	 outl(ioLCD_DATA, saved_lcd_gen_ctrl);
      }
   }

   if (!mach64IntegratedController) {
     save->ATIReg0  = inATI(0xb0);
     save->ATIReg1  = inATI(0xb1);
     save->ATIReg2  = b2_save;
     save->ATIReg5  = inATI(0xb5);
     save->ATIReg6  = inATI(0xb6);
     save->ATIReg3  = inATI(0xb3);
     save->ATIReg8  = b8_save;
     save->ATIRegE  = inATI(0xbe);
     save->ATIReg9  = inATI(0xb9);
     save->ATIRegA6 = inATI(0xa6);
     save->ATIRegA7 = inATI(0xa7);
   }
   
#if 0
  /*
   * TvR: don't know whether this is neccesary for mach64
   * Should be removed if it isn't needed. 
   */
   /* Enable video */
   inb(vgaIOBase + 0x0A); /* reset flip-flop */
   outb( 0x3c0, 0x20 );
#endif
}

void mach64RestoreVGAInfo()
{
   unsigned long saved_lcd_gen_ctrl = 0, lcd_gen_ctrl = 0;
   int i;

   if (!mach64IntegratedController) {
     /* Unlock ATI specials */
     outw(ATIExtReg, ((inATI(0xb8) & 0xC0) << 8) | 0xb8);

     /* Load ATI Extended registers */
     outw(ATIExtReg, (save->ATIReg0 << 8) | 0xb0);
     outw(ATIExtReg, (save->ATIReg1 << 8) | 0xb1);
     outw(ATIExtReg, (save->ATIReg2 << 8) | 0xb2);
     outw(ATIExtReg, (save->ATIReg3 << 8) | 0xb3);
     outw(ATIExtReg, (save->ATIReg5 << 8) | 0xb5);
     outw(ATIExtReg, (save->ATIReg6 << 8) | 0xb6);
     outw(ATIExtReg, (save->ATIRegE << 8) | 0xbE);
     outw(ATIExtReg, (save->ATIReg9 << 8) | 0xb9);
     outw(ATIExtReg, (save->ATIRegA6 << 8) | 0xa6);
     outw(ATIExtReg, (save->ATIRegA7 << 8) | 0xa7);

     /*
      * Last but not least ATIReg8 -- according to vgadoc's this lock the 
      * ATI special registers
      */
     outw(ATIExtReg, (save->ATIReg8 << 8) | 0xb8);
   }

   if (mach64LCDPanelID >= 0) {
      if (mach64ChipType == MACH64_LG_ID) {
	 saved_lcd_gen_ctrl = regr(LCD_GEN_CTRL);
	 lcd_gen_ctrl = saved_lcd_gen_ctrl &
	    ~(CRTC_RW_SELECT | SHADOW_EN | SHADOW_RW_EN);
	 regw(LCD_GEN_CTRL, lcd_gen_ctrl);
      } else {
	 outb(ioLCD_INDEX, LCD_GEN_CNTL);
	 saved_lcd_gen_ctrl = inl(ioLCD_DATA);
	 lcd_gen_ctrl = saved_lcd_gen_ctrl &
	    ~(CRTC_RW_SELECT | SHADOW_EN | SHADOW_RW_EN);
	 outl(ioLCD_DATA, lcd_gen_ctrl);
      }
   }

   /*
    * Restore the generic vga registers
    */
   vgaHWRestore((vgaHWPtr)save);

   if (mach64LCDPanelID >= 0) {
      lcd_gen_ctrl |= SHADOW_EN | SHADOW_RW_EN;
      if (mach64ChipType == MACH64_LG_ID) {
	 regw(LCD_GEN_CTRL, lcd_gen_ctrl);
      } else {
	 outb(ioLCD_INDEX, LCD_GEN_CNTL);
	 outl(ioLCD_DATA, lcd_gen_ctrl);
      }

      outw(vgaIOBase + 4, ((save->shadow_crtc[17] & 0x7F) << 8) | 17);
      for (i=0; i<25; i++) outw(vgaIOBase + 4, (save->shadow_crtc[i] << 8) | i);

      if (mach64ChipType == MACH64_LG_ID) {
	 regw(LCD_GEN_CTRL, saved_lcd_gen_ctrl);
      } else {
	 outb(ioLCD_INDEX, LCD_GEN_CNTL);
	 outl(ioLCD_DATA, saved_lcd_gen_ctrl);
      }
   }
}

/*
 * End of VGA font saving and restoration code.
 *
 ***************************************************************************/
