/*
 *  XScrabble - X version of the popular board game, for 1 to 4 players.
 *
 * This software comes with NO warranty whatsoever. I therefore take no
 * responsibility for any damages, losses or problems caused through use
 * or misuse of this program.
 *
 * I hereby grant permission for this program to be freely copied and
 * distributed by any means, provided no charge is made for it.
 *
 * Matt Chapman, matt@belgarath.demon.co.uk
 *    Oct 1994.
 */

/* widgets.c - define widgets */

#include "scrab.h"
#include "globals.h"

#include "dot.xbm"

void set_board(Widget top,int dnum)
{
	int ac,dn,bn;
	char wname[6],lett[3];

	Widget sur[BOARDSIZE*2],edg[BOARDSIZE*2];
	Widget boardw;

	all = XtVaCreateManagedWidget("all", formWidgetClass,top, NULL);
	title = XtVaCreateManagedWidget("title", labelWidgetClass, all, NULL);

	SetupMenu(all,dnum);

	boardw = XtVaCreateManagedWidget("board", formWidgetClass, all, NULL);

	/* board surround */
	for (ac=0; ac<BOARDSIZE; ac++)
	{
		sprintf(lett,"%c",ac+'A');
		sur[ac]=XtVaCreateManagedWidget("surr",labelWidgetClass,boardw,XtNlabel,
				lett,NULL);
		if (ac>0)
			XtVaSetValues(sur[ac],XtNfromHoriz,sur[ac-1],NULL);
		else
			XtVaSetValues(sur[ac],XtNhorizDistance,18,NULL);
	}


	/* squares on board */
	for (dn=0; dn<BOARDSIZE; dn++)
	{
		sprintf(lett,"%d",dn);
		edg[dn]=XtVaCreateManagedWidget("edg",labelWidgetClass,boardw,
				XtNlabel,lett,NULL);
		if (dn>0)
			XtVaSetValues(edg[dn],XtNfromVert,edg[dn-1],NULL);
		else
			XtVaSetValues(edg[dn],XtNfromVert,sur[0],NULL);

		for (ac=0; ac<BOARDSIZE; ac++)
		{
			sprintf(wname,"%d-%d",ac,dn);
			sq[dnum][ac][dn]=XtVaCreateManagedWidget(wname,commandWidgetClass,
					boardw, XtNlabel," ", NULL);
			if (ac>0)
				XtVaSetValues(sq[dnum][ac][dn],XtNfromHoriz,sq[dnum][ac-1][dn],NULL);
			else
				XtVaSetValues(sq[dnum][ac][dn],XtNfromHoriz,edg[dn],NULL);

			if (dn>0)
				XtVaSetValues(sq[dnum][ac][dn],XtNfromVert,sq[dnum][ac][dn-1],NULL);
			else
				XtVaSetValues(sq[dnum][ac][dn],XtNfromVert,sur[ac],NULL);

		}
		edg[dn+BOARDSIZE]=XtVaCreateManagedWidget("edg",labelWidgetClass,boardw,
				XtNlabel,lett,XtNfromHoriz,sq[dnum][BOARDSIZE-1][dn],NULL);
		if (dn>0)
		    XtVaSetValues(edg[dn+BOARDSIZE],XtNfromVert,edg[dn+BOARDSIZE-1],NULL);
		else
		    XtVaSetValues(edg[dn+BOARDSIZE],XtNfromVert,sur[0],NULL);
	}
	
	/* board surround */
	for (ac=0; ac<BOARDSIZE; ac++)
	{
		sprintf(lett,"%c",ac+'A');
		sur[ac+BOARDSIZE]=XtVaCreateManagedWidget("surr",labelWidgetClass,
				boardw,XtNlabel,lett,XtNfromVert,sq[dnum][ac][BOARDSIZE-1],NULL);
		if (ac>0)
			XtVaSetValues(sur[ac+BOARDSIZE],XtNfromHoriz,sur[ac+BOARDSIZE-1],
					NULL);
		else
			XtVaSetValues(sur[ac+BOARDSIZE],XtNhorizDistance,18,NULL);
	}

	scoretitle = XtVaCreateManagedWidget("scoretitle", labelWidgetClass, all,
			NULL);
	scorebox[dnum] = XtVaCreateManagedWidget("scorebox", labelWidgetClass, all, NULL);

	tilesleft[dnum] = XtVaCreateManagedWidget("tilesleft", labelWidgetClass, all, NULL);

	if (time_limit>0)
		timeleft[dnum] = XtVaCreateManagedWidget("timeleft",
			xfwfCircularPercentageWidgetClass,all,NULL);

	barw[dnum] = XtVaCreateManagedWidget("bar", formWidgetClass, all, NULL);
	message[dnum] = XtVaCreateManagedWidget("message", labelWidgetClass, all, NULL);

	/* squares in bar */
	for (bn=0; bn<LONGBAR; bn++)
	{
		bar[dnum][bn]=' ';
		sprintf(wname,"bar%d",bn);
		br[dnum][bn]=XtVaCreateManagedWidget(wname,commandWidgetClass,
				barw[dnum], XtNlabel, " ", NULL);
		if (bn>0)
			XtVaSetValues(br[dnum][bn],XtNfromHoriz,br[dnum][bn-1],NULL);

	}

	/* move buttons */
	finish[dnum] = XtVaCreateManagedWidget("finish", commandWidgetClass,all,
		XtNsensitive,False,NULL);
	change[dnum] = XtVaCreateManagedWidget("change", commandWidgetClass,all,
		XtNsensitive,False,NULL);
	pass[dnum] = XtVaCreateManagedWidget("pass", commandWidgetClass,all,
		XtNsensitive,False,NULL);
	evaluate[dnum] = XtVaCreateManagedWidget("evaluate", commandWidgetClass,all,
		XtNsensitive,False,NULL);

	/* extra buttons */
	revert[dnum] = XtVaCreateManagedWidget("revert",commandWidgetClass,all,NULL);
	juggle[dnum] = XtVaCreateManagedWidget("juggle",commandWidgetClass,all,NULL);

	/* set square colours */
	for (dn=0; dn<BOARDSIZE; dn++)
		for (ac=0; ac<BOARDSIZE; ac++)
			XtVaSetValues(sq[dnum][ac][dn],SETBG(colours[sq_col[ac][dn]]),NULL);

	if (type[dnum]>0) /* computer player */
	{
		XtVaSetValues(all,XtNmappedWhenManaged,False,NULL);
		XtVaSetValues(top,XtNwidth,202,XtNheight,102,NULL);
		compw[dnum] = XtVaCreateManagedWidget("compw",xcBarGraphWidgetClass,top,NULL);
		return;
	}
		
	/* for moving tiles */
	for (dn=0; dn<BOARDSIZE; dn++)
		for (ac=0; ac<BOARDSIZE; ac++)
			XtAddCallback(sq[dnum][ac][dn],XtNcallback,Select_sq,top);				
	for (ac=0; ac<LONGBAR; ac++)
		XtAddCallback(br[dnum][ac],XtNcallback,Select_sq,top);

	/* for buttons around board */
	XtAddCallback(finish[dnum],XtNcallback,FinishGo,top);
	XtAddCallback(evaluate[dnum],XtNcallback,FinishGo,top);
	XtAddCallback(change[dnum],XtNcallback,ChangePopup,top);
	XtAddCallback(pass[dnum],XtNcallback,PassGo,top);
	XtAddCallback(revert[dnum],XtNcallback,RevertToBar,top);
	XtAddCallback(juggle[dnum],XtNcallback,Juggle,top);

	bg_pixmap(all);
	bg_pixmap(title);

	CreateLettValuesPopup(dnum);
	CreateHiScoresPopup(dnum);
	CreateBestgoPopup(dnum);
	CreateAboutPopup(dnum);
	CreateKeyPopup(dnum);
	CreateMess(dnum);
}

void SetupMenu(Widget top,int dnum)
{
	char entry[8];
	int i;

	mark[dnum] = XCreateBitmapFromData(XtDisplay(top),RootWindowOfScreen(XtScreen(top)),
		(char *)dot_bits,dot_width,dot_height);

	menuButton[dnum] = XtVaCreateManagedWidget("menuButton",menuButtonWidgetClass,
    	top,NULL);
   	menu[dnum] = XtVaCreatePopupShell("menu",simpleMenuWidgetClass,
   		menuButton[dnum],NULL);
	for (i=0; i<MENU_ITEMS; i++)
	{
		menu_status[dnum][i]=False;
		sprintf(entry,"entry%d",i);
		menu_item[dnum][i] = XtVaCreateManagedWidget(entry,smeBSBObjectClass,
			menu[dnum],NULL);
		XtAddCallback(menu_item[dnum][i],XtNcallback,ProcessMenu,top);
	}
}

void ProcessMenu(Widget w, XtPointer client_data, XtPointer call_data)
{
	char *name = XtName(w);
	int sel = name[5] - '0';
	int i,dnum=0;
	
	for (i=0; i<num_players; i++)
		if (w==menu_item[i][sel])
			dnum=i;
	if (menu_status[dnum][sel]==False)
		XtVaSetValues(w,XtNleftBitmap,mark[dnum],NULL);
	else
		XtVaSetValues(w,XtNleftBitmap,None,NULL);
	menu_status[dnum][sel]= !menu_status[dnum][sel];

	switch (sel)
	{
		case KEY: KeyPopup(dnum);
			break;
		case LETTVAL: LettValuesPopup(dnum);
			break;
		case HISCORES: HiScoresPopup(dnum);
			break;
		case BESTGOES: BestgoPopup(dnum);
			break;
		case MESSAGE: MessPopup(dnum);
		case ABOUT: AboutPopup(dnum);
		        break;
		case QUIT: Quit(); break;
		default: break;
	}
}

void ChangePopup()
{
	Position x, y;
	int i;
	char chlet[3];

	waiting_for_change=True;	
	changeshell=XtVaCreatePopupShell("changeshell",transientShellWidgetClass,
		topl[curr_player],NULL);
		
	changef=XtVaCreateManagedWidget("changef",formWidgetClass,changeshell,
		NULL);
	changetitle=XtVaCreateManagedWidget("changetitle",labelWidgetClass,changef,
		NULL);

	for (i=0; i<BARLEN; i++)
	{
		sprintf(chlet,"%c",player[curr_player].bar[i]);
		changeletts[i]=XtVaCreateManagedWidget("cl",toggleWidgetClass,changef,
			XtNfromVert,changetitle,XtNlabel,chlet,NULL);
		if (player[curr_player].bar[i] != ' ')
			XtVaSetValues(changeletts[i],SETBG(TILECOL),NULL);
		if (i>0)
			XtVaSetValues(changeletts[i],XtNfromHoriz,changeletts[i-1],NULL);
	}

	changeconfirm=XtVaCreateManagedWidget("changeconfirm",commandWidgetClass,
		changef,XtNfromVert,changeletts[0],NULL);
	changecancel=XtVaCreateManagedWidget("changecancel",commandWidgetClass,
		changef,XtNfromVert,changeletts[0],XtNfromHoriz,changeconfirm,NULL);

	XtTranslateCoords(change[curr_player],(Position) -10,(Position) -10, &x, &y);
	XtVaSetValues(changeshell, XtNx, x, XtNy, y, NULL);
/*	bg_pixmap(changef);*/

	XtPopup(changeshell,XtGrabNonexclusive);

	XtAddCallback(changeconfirm,XtNcallback,ChangePopdown,topLevel);
	XtAddCallback(changecancel,XtNcallback,ChangePopdown,topLevel);
}

void BlankPopup()
{
	Position x, y;
	int i;
	char chlet[3];

	waiting_for_blank=True;	
	blankshell=XtVaCreatePopupShell("blankshell",transientShellWidgetClass,
		topl[curr_player],NULL);
		
	blankf=XtVaCreateManagedWidget("blankf",formWidgetClass,blankshell,
		NULL);
	blanktitle=XtVaCreateManagedWidget("blanktitle",labelWidgetClass,blankf,NULL);

	for (i=0; i<NUMLETTERS; i++)
	{
		sprintf(chlet,"%c",i+'A');
		a2z[i]=XtVaCreateManagedWidget("az",commandWidgetClass,blankf,
			XtNfromVert,blanktitle,XtNlabel,chlet,SETBG(TILECOL),NULL);
		if ((i!=0) && (i!=(NUMLETTERS/2)))
			XtVaSetValues(a2z[i],XtNfromHoriz,a2z[i-1],NULL);
		if (i>(NUMLETTERS/2)-1)
			XtVaSetValues(a2z[i],XtNfromVert,a2z[i-(NUMLETTERS/2)],NULL);
	}

	XtTranslateCoords(finish[curr_player],(Position) -10,(Position) -10, &x, &y);
	XtVaSetValues(blankshell, XtNx, x, XtNy, y, NULL);
/*	bg_pixmap(blankf);*/
	
	XtPopup(blankshell,XtGrabNonexclusive);

	for (i=0; i<NUMLETTERS; i++)
		XtAddCallback(a2z[i],XtNcallback,BlankPopdown,topLevel);
}




void bg_pixmap(Widget w)
{
	XtVaSetValues(w,XtNbackgroundPixmap, (XtArgVal)bgxpm, NULL);
}

/* called on receipt of delete signal */
void Quit(void)
{
    XtDestroyApplicationContext(app_context);
    exit(0);
}



