;;************************************************************************
;; overlay.lsp 
;; contains code for graph overlay
;; copyright (c) 1997 by Forrest W. Young
;;************************************************************************

(defproto vista-graph-overlay-proto 
  '(buttons plot-help color mouse-mode bins normal density smooth 
            box new-x new-y new-z iterate undo equate lefts strings)  
   () graph-overlay-proto)

(defmeth vista-graph-overlay-proto :isnew 
  (&key (help t) (color t) (mouse-mode t) (new-x t) (new-y t) (new-z nil) 
        (normal nil) (density nil) (smooth nil) (bins nil) (box nil) 
        (iterate nil) (undo nil) (equate nil))
  (call-next-method)
  (send self :plot-help help)
  (send self :color color)
  (send self :mouse-mode mouse-mode)
  (send self :new-x new-x)
  (send self :new-y new-y)
  (send self :new-z new-z)
  (send self :bins bins)
  (send self :normal normal)
  (send self :density density)
  (send self :smooth smooth)
  (send self :box box)
  (send self :iterate iterate)
  (send self :undo undo)
  (send self :equate equate) 
  )

(defmeth vista-graph-overlay-proto :buttons (&optional (list nil set))
"Args: (&optional logical)
Sets or returns which buttons are hilited."
  (if set (setf (slot-value 'buttons) list))
  (slot-value 'buttons))

(defmeth vista-graph-overlay-proto :plot-help (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether plot-help button is to be drawn."
  (if set (setf (slot-value 'plot-help) logical))
  (slot-value 'plot-help))

(defmeth vista-graph-overlay-proto :color (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether color button is to be drawn."
  (if set (setf (slot-value 'color) logical))
  (slot-value 'color))

(defmeth vista-graph-overlay-proto :mouse-mode (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether mouse-mode button is to be drawn."
  (if set (setf (slot-value 'mouse-mode) logical))
  (slot-value 'mouse-mode))

(defmeth vista-graph-overlay-proto :bins (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether bins button is to be drawn."
  (if set (setf (slot-value 'bins) logical))
  (slot-value 'bins))

(defmeth vista-graph-overlay-proto :normal (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether normal button is to be drawn."
  (if set (setf (slot-value 'normal) logical))
  (slot-value 'normal))

(defmeth vista-graph-overlay-proto :density (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether density button is to be drawn."
  (if set (setf (slot-value 'density) logical))
  (slot-value 'density))

(defmeth vista-graph-overlay-proto :smooth (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether smooth button is to be drawn."
  (if set (setf (slot-value 'smooth) logical))
  (slot-value 'smooth))

(defmeth vista-graph-overlay-proto :box (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether bins button is to be drawn."
  (if set (setf (slot-value 'box) logical))
  (slot-value 'box))

(defmeth vista-graph-overlay-proto :new-x (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether new-x button is to be drawn."
  (if set (setf (slot-value 'new-x) logical))
  (slot-value 'new-x))

(defmeth vista-graph-overlay-proto :new-y (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether new-y button is to be drawn."
  (if set (setf (slot-value 'new-y) logical))
  (slot-value 'new-y))

(defmeth vista-graph-overlay-proto :new-z (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether new-z button is to be drawn."
  (if set (setf (slot-value 'new-z) logical))
  (slot-value 'new-z))

(defmeth vista-graph-overlay-proto :iterate (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether iterate button is to be drawn."
  (if set (setf (slot-value 'iterate) logical))
  (slot-value 'iterate))

(defmeth vista-graph-overlay-proto :undo (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether undo button is to be drawn."
  (if set (setf (slot-value 'undo) logical))
  (slot-value 'undo))

(defmeth vista-graph-overlay-proto :equate (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether equate button is to be drawn."
  (if set (setf (slot-value 'equate) logical))
  (slot-value 'equate))

(defmeth vista-graph-overlay-proto :lefts (&optional (list nil set))
"Args: (&optional list)
Sets or returns left coordinate of each box on the overlay."
  (if set (setf (slot-value 'lefts) list))
  (slot-value 'lefts))

(defmeth vista-graph-overlay-proto :strings (&optional (list nil set))
"Args: (&optional logical)
Sets or returns list of strings for box names."
  (if set (setf (slot-value 'strings) list))
  (slot-value 'strings))

(defmeth vista-graph-overlay-proto :redraw ()
  (let* ((graph (slot-value 'graph))
         (draw-color (send graph :draw-color))
         (i 0)
         (topy 3)
         (height 10)
         (gap 2)
         (td (send graph :text-descent))
         (bottom (- (second (send graph :margin)) 3))
         )
    (when (not (send self :lefts)) (send self :setup-redraw))
    (if (and (send graph :use-color) (send *vista* :background-color))
        (send graph :draw-color 'toolbar-background)
        (send graph :draw-color 'white))
    (send graph :paint-rect 0 0 (send graph :canvas-width) bottom)
    (send graph :draw-color draw-color)
    (send graph :draw-line 0 bottom (send graph :canvas-width) bottom)
    (when (send self :plot-help) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :color) 
          (send self :draw-button (send graph :use-color) i) 
          (setf i (1+ i)))
    (when (send self :mouse-mode) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :bins) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :normal) 
          (send self :draw-button (send graph :show-normal) i)
          (setf i (1+ i)))
    (when (send self :density) 
          (send self :draw-button (send graph :show-density) i)
          (setf i (1+ i)))
    (when (send self :smooth) 
          (send self :draw-button (send graph :show-smooth) i)
          (setf i (1+ i)))
    (when (send self :box) 
          (send self :draw-button (send graph :show-box) i)
          (setf i (1+ i)))
    (when (send self :new-x) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :new-y) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :new-z) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :iterate) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :undo) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :equate) 
          (send self :draw-button (send graph :equate) i))
    
    ))

(defmeth vista-graph-overlay-proto :setup-redraw ()
  (let* ((graph (slot-value 'graph))
         (lefts nil)
         (strings nil)
         (width  10)
         (button-gap 5)
         (gap 2)
         (topx 5)
         (i 0)
         (s1 "Help")
         (s1a "Color")
         (s2 "Mouse")
         (s3 "Bins")
         (s3a "Normal")
         (s3aa "Curves")
         (s3ab "Smooth")
         (s3b "Box")
         (s4 "X")
         (s5 "Y")
         (s6 "Z")
         (s7 "Iter")
         (s8 "Undo")
         (s9 "Equate")
         (w1 (send graph-proto :text-width s1))
         (w1a (send graph-proto :text-width s1a))
         (w2 (send graph-proto :text-width s2))
         (w3 (send graph-proto :text-width s3))
         (w3a (send graph-proto :text-width s3a))
         (w3aa (send graph-proto :text-width s3aa))
         (w3b (send graph-proto :text-width s3b))
         (w4 (send graph-proto :text-width s4))
         (w5 (send graph-proto :text-width s5))
         (w6 (send graph-proto :text-width s6))
         (w7 (send graph-proto :text-width s7))
         (w8 (send graph-proto :text-width s8))
         (w9 (send graph-proto :text-width s9))
         )
    (when (send self :plot-help)
          (setf lefts (add-element-to-list lefts topx))
          (setf strings (add-element-to-list strings s1))
          (setf topx (+ topx width gap w1 button-gap)))
    (when (send self :color)
          (setf lefts (add-element-to-list lefts topx))
          (setf strings (add-element-to-list strings s1a))
          (setf topx (+ topx width gap w1a button-gap)))
    (when (send self :mouse-mode)
          (setf lefts (add-element-to-list lefts topx))
          (setf strings (add-element-to-list strings s2))
          (setf topx (+ topx width gap w2 button-gap)))
    (when (send self :bins)
          (setf lefts (add-element-to-list lefts topx))
          (setf strings (add-element-to-list strings s3))
          (setf topx (+ topx width gap w3 button-gap))) 
    (when (send self :normal)
          (setf lefts (add-element-to-list lefts topx))
          (setf strings (add-element-to-list strings s3a))
          (setf topx (+ topx width gap w3a button-gap))) 
    (when (send self :density)
          (setf lefts (add-element-to-list lefts topx))
          (setf strings (add-element-to-list strings s3aa))
          (setf topx (+ topx width gap w3aa button-gap))) 
    (when (send self :smooth)
          (setf lefts (add-element-to-list lefts topx))
          (setf strings (add-element-to-list strings s3ab))
          (setf topx (+ topx width gap w3ab button-gap)))
    (when (send self :box)
          (setf lefts (add-element-to-list lefts topx))
          (setf strings (add-element-to-list strings s3b))
          (setf topx (+ topx width gap w3b button-gap))) 
    (when (send self :new-x)
          (setf lefts (add-element-to-list lefts topx))
          (setf strings (add-element-to-list strings s4))
          (setf topx (+ topx width gap w4 button-gap)))
    (when (send self :new-y)
          (setf lefts (add-element-to-list lefts topx))
          (setf strings (add-element-to-list strings s5))
          (setf topx (+ topx width gap w5 button-gap)))
    (when (send self :new-z)
          (setf lefts (add-element-to-list lefts topx))
          (setf strings (add-element-to-list strings s6))
          (setf topx (+ topx width gap w6 button-gap)))
    (when (send self :iterate)
          (setf lefts (add-element-to-list lefts topx))
          (setf strings (add-element-to-list strings s7))
          (setf topx (+ topx width gap w7 button-gap)))
    (when (send self :undo)
          (setf lefts (add-element-to-list lefts topx))
          (setf strings (add-element-to-list strings s8))
          (setf topx (+ topx width gap w8 button-gap)))
    (when (send self :equate)
          (setf lefts (add-element-to-list lefts topx))
          (setf strings (add-element-to-list strings s9))
          (setf topx (+ topx width gap w9 button-gap)))
    (send self :lefts lefts)
    (send self :strings strings)
    (send self :buttons (repeat nil (length lefts)))
    ))
  
  
(defmeth vista-graph-overlay-proto :do-click (x y m1 m2)
  (let* ((graph (slot-value 'graph))
         (lefts (send self :lefts))
         (height 10)
         (width  10)
         (gap 2)
         (topx 10)
         (topy 3)
         (bottom (+ topy height gap))
         (idling (send graph :idle-on))
         (i 0)
         )
    (when (< y bottom)
          (send graph :idle-on nil)
          (when (< topy y (+ topy height))
                (when (send self :plot-help)
                      (when (< (select lefts i) x (+ width (select lefts i)))
                            (send self :draw-button t i)
                            (send graph :plot-help)
                            (send self :draw-button nil i))
                      (setf i (1+ i)))
                (when (send self :color)
                      (when (< (select lefts i) x (+ width (select lefts i)))
                            (send self :draw-button 
                                 (not (send graph :use-color)) i)
                            (send graph :switch-use-color))
                      (setf i (1+ i)))
                (when (send self :mouse-mode)
                      (when (< (select lefts i) x (+ width (select lefts i)))
                            (send self :draw-button t i)
                            (send graph :choose-mouse-mode)
                            (send self :draw-button nil i))
                       (setf i (1+ i)))
                (when (send self :bins)
                      (when (< (select lefts i) x (+ width (select lefts i)))
                            (send self :draw-button t i)
                            (send graph :new-bins)
                            (send self :draw-button nil i))
                      (setf i (1+ i)))
                (when (send self :normal)
                      (when (< (select lefts i) x (+ width (select lefts i)))
                            (send self :draw-button 
                                  (not (send graph :show-normal)) i)
                            (send graph :switch-add-normal))
                      (setf i (1+ i)))
                (when (send self :density)
                      (when (< (select lefts i) x (+ width (select lefts i)))
                            (send self :draw-button t i)
                            (send graph :choose-density)
                            (send self :draw-button nil i))
                      (setf i (1+ i)))
                (when (send self :smooth)
                      (when (< (select lefts i) x (+ width (select lefts i)))
                            (send self :draw-button 
                                  (not (send graph :show-smooth)) i)
                            (send graph :switch-add-smooth))
                      (setf i (1+ i)))
                (when (send self :box)
                      (when (< (select lefts i) x (+ width (select lefts i)))
                            (send self :draw-button 
                                  (not (send graph :show-box)) i)
                            (send graph :switch-add-box))
                      (setf i (1+ i)))
                (when (send self :new-x)
                      (when (< (select lefts i) x (+ width (select lefts i)))
                            (send self :draw-button t i)
                            (send graph :new-x)
                            (send self :draw-button nil i))
                      (setf i (1+ i)))
                (when (send self :new-y)
                      (when (< (select lefts i) x (+ width (select lefts i)))
                            (send self :draw-button t i)
                            (send graph :new-y)
                            (send self :draw-button nil i))
                      (setf i (1+ i)))
                (when (send self :new-z)
                      (when (< (select lefts i) x (+ width (select lefts i)))
                            (send self :draw-button t i)
                            (send graph :new-z)
                            (send self :draw-button nil i))
                      (setf i (1+ i)))
                (when (send self :iterate)
                      (when (< (select lefts i) x (+ width (select lefts i)))
                            (send self :draw-button t i)
                            (send graph :iter8)
                            (send self :draw-button nil i))
                      (setf i (1+ i)))
                (when (send self :undo)
                      (when (< (select lefts i) x (+ width (select lefts i)))
                            (send self :draw-button t i)
                            (send graph :undo-graph-change m1 m2)
                            (send self :draw-button nil i))
                      (setf i (1+ i)))
                (when (send self :equate)
                      (when (< (select lefts i) x (+ width (select lefts i)))
                            (send self :draw-button 
                                  (not (send graph :equate)) i)
                            (send graph :switch-equate))
                      (setf i (1+ i)))
                )
          (send graph :idle-on idling)
          t)
    ))
                
(defmeth vista-graph-overlay-proto :draw-button (paint i)
  (let* ((graph (slot-value 'graph))
         (button-list (send self :buttons))
         (a (select (send self :lefts) i))
         (on-color 'button-on-color)
         (off-color 'button-off-color)
         (b 3)
         (c 10)
         (d 10))
    (when (not button-list)
          (send self :buttons (repeat nil (length (send self :lefts)))))
    (setf (select button-list i) paint)
    (send self :buttons button-list)
    (when (or (= *color-mode* 0) (not (send graph :use-color)))
          (setf on-color 'black)
          (setf off-color 'white))
    (cond 
      (paint 
       (send (send self :graph) :draw-color on-color)
       (send (send self :graph) :paint-rect a b c d)
       (send (send self :graph) :draw-color 'black)
       (send (send self :graph) :frame-rect a b c d))
      (t
       (send (send self :graph) :draw-color off-color)
       (send (send self :graph) :paint-rect a b c d)
       (send (send self :graph) :draw-color 'black)
       (send (send self :graph) :frame-rect a b c d)))
    (send graph :draw-string (select (send self :strings) i) 
          (+ a d 2) (+ b (- c 1)))
    ))

(provide "overlay")