#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include "strerr.h"
#include "generic-conf.h"
#include "fmt.h"

static char strnum[FMT_ULONG];
static int flaglog;
static struct passwd *pw;

void service(char *dir,char *user,char *loguser,char *fatal)
{
  init(dir,fatal);

  if (loguser) {
    pw = getpwnam(loguser);
    if (!pw)
      strerr_die3x(111,fatal,"unknown account ",loguser);
    makelog(loguser,pw->pw_uid,pw->pw_gid);
  }
  else {
    if (chmod(dir,02755) == -1)
      strerr_die4sys(111,fatal,"unable to set mode of ",dir,": ");
  }

  makedir("env");
  perm(02755);

  if (user) {
    pw = getpwnam(user);
    if (!pw)
      strerr_die3x(111,fatal,"unknown account ",user);

    start("env/UID");
    out(strnum,fmt_ulong(strnum,pw->pw_uid));
    finish();
    perm(0644);

    start("env/GID");
    out(strnum,fmt_ulong(strnum,pw->pw_gid));
    finish();
    perm(0644);
  }
}
