/*
 * nasd_dux_pdev.c
 *
 * Digital Unix specific pseudodevice stuff
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>

#if NASD_NUM_KPDEV > 0

#include <nasd/nasd_pdrive_client.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_edrfs_client.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_freelist.h>
#include <nasd/nasd_pdev.h>
#include <nasd/nasd_sys.h>
#include <nasd/nasd_timer.h>

#include <kern/lock.h>
#include <vm/vm_map.h>
#include <vm/vm_kern.h>
#include <vm/vm_lock.h>
#include <sys/time.h>
#include <nfs/nfs.h>
#include <rpc/rpc.h>
#include <nfs/nfs_clnt.h>
#include <sys/mode.h>
#include <io/common/devdriver.h>

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE
#include <dce/ker/pthread_exc.h>
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

int
nasdpd_open(
  dev_t dev,
  int   flags,
  int   format)
{
  NASDpd_t *npd;
  int unit, ret;

  NASDPD_CLI_GETDEV(dev,npd,unit);
  if (npd == NULL)
    return(ENODEV);

  ret = nasdpd_real_open(npd);

  return(ret);
}

int
nasdpd_close(
  dev_t dev,
  int   flags)
{
  NASDpd_t *npd;
  int unit, ret;

  NASDPD_CLI_GETDEV(dev,npd,unit);
  if (npd == NULL)
    return(ENODEV);

  ret = nasdpd_real_close(npd);

  return(ret);
}

int
nasdpd_ioctl(
  dev_t        dev,
  int          cmd,
  caddr_t      data,
  int          flags,
  struct ucred *cred)
{
  NASDpd_t *npd;
  int unit, ret;

  NASDPD_CLI_GETDEV(dev,npd,unit);
  if (npd == NULL)
    return(ENODEV);

  ret = nasdpd_real_ioctl(npd, cmd, data);

  return(ret);
}

#endif /* NASD_NUM_KPDEV > 0 */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
