/*
 * nasd_linux_edrfs_client_fs.c
 *
 * EDRFS FS Client Linux Kernel Module
 *
 * Author: Nat Lanza
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>

#if defined(LINUX) && defined(KERNEL) && defined(MODULE) /* should always be */

#include <linux/module.h>
#include <nasd/nasd_sys.h>

EXPORT_NO_SYMBOLS;

extern int init_nasd_edrfs_fs(void);
extern int shutdown_nasd_edrfs_fs(void);

MODULE_AUTHOR("Nat Lanza <magus+@cs.cmu.edu>");
MODULE_DESCRIPTION("EDRFS Filesystem Client");

nasd_status_t nasd_edrfs_client_fs_init(void) {
  MOD_INC_USE_COUNT;
  return NASD_SUCCESS;
}

nasd_status_t nasd_edrfs_client_fs_shutdown(void) {
  MOD_DEC_USE_COUNT;
  return NASD_SUCCESS;
}

int
init_module() {
  int status = 0;
  printk("EDRFS loading\n");

  status = init_nasd_edrfs_fs();
  if (status) {
    printk("Can't initialize EDRFS: status %d\n", status);
    return status;
  }

  return 0;
}

void
cleanup_module() {
  int err = 0;

  err = shutdown_nasd_edrfs_fs();
  
  if (err) {
    printk("EDRFS: failed to shutdown cleanly! (%d)\n", err);
  }
}

#endif /* LINUX && KERNEL && MODULE */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */

