/*
 * nasd_trace_dr.h
 *
 * Drive structures and defs for NASD tracing.
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_TRACE_DR_H_
#define _NASD_TRACE_DR_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_drive_options.h>
#include <nasd/nasd_base_types.h>
#include <nasd/nasd_security.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_od.h>
#include <nasd/nasd_sys.h>
#include <nasd/nasd_control.h>
#include <nasd/nasd_shutdown.h>
#include <nasd/nasd_cache.h>
#include <nasd/nasd_trace.h>

nasd_status_t nasd_dt_trace_init(void);
nasd_status_t nasd_dt_write_trace_info(int partnum, nasd_offset_t offset,
  nasd_len_t in_len, nasd_procpipe_t *byte_pipe, nasd_len_t *out_len);
nasd_status_t nasd_dt_read_trace_info(nasd_pagebuf_t *pb,
  nasd_pagebuf_t *pb_net, int partnum, nasd_offset_t offset,
  nasd_len_t in_len, int is_read2, nasd_procpipe_t *byte_pipe,
  nasd_len_t *out_len);
nasd_status_t nasd_dt_write_trace_data(int partnum, nasd_offset_t offset,
  nasd_len_t in_len, nasd_procpipe_t *byte_pipe, nasd_len_t *out_len);
nasd_status_t nasd_dt_read_trace_data(nasd_pagebuf_t *pb,
  nasd_pagebuf_t *pb_net, int partnum, nasd_offset_t offset,
  nasd_len_t in_len, int is_read2, nasd_procpipe_t *byte_pipe,
  nasd_len_t *out_len);

#if NASD_TRACE_DR > 0

extern nasd_uint64 nasd_dt_enable;

typedef struct nasd_dt_trace_rec_s  nasd_dt_trace_rec_t;
#define NASD_DT_BUF_SIZE 16384

struct nasd_dt_trace_rec_s {
  nasd_byte_t           data[NASD_DT_BUF_SIZE];
  nasd_dt_trace_rec_t  *next;
};

#define nasd_dt_trace_enter(_class_,_type_,_len_,_data_,_seqp_,_seq_provided_) { \
  if (nasd_dt_enable&(_class_)) { \
    _nasd_dt_trace_enter(_class_, _type_, _len_, _data_, _seqp_, \
      _seq_provided_); \
  } \
}

nasd_dt_trace_rec_t *nasd_dt_getrec(void);
void nasd_dt_freerec(nasd_dt_trace_rec_t *rec);
void nasd_dt_stop(void);
void nasd_dt_freerecs(void *ignored);
void _nasd_dt_trace_enter(int trace_class, int trace_type,
  int len, nasd_byte_t *data, nasd_trace_seq_t *trace_seq,
  int seq_provided);

#define nasd_dt_noop_args(_seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_NOOP, \
    0, NULL, _seq_, 1)

#define nasd_dt_create_args(_args_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_CREATE, \
    sizeof(nasd_p_create_dr_args_otw_t), _args_, _seq_, 1)

#define nasd_dt_getattr_args(_args_,_seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_GETATTR, \
    sizeof(nasd_p_getattr_dr_args_otw_t), _args_, _seq_, 1)

#define nasd_dt_read_simple_args(_args_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_READ_SIMPLE, \
    sizeof( nasd_p_smpl_op_dr_args_otw_t), _args_, _seq_, 1)

/* not traced */
#define nasd_dt_read2_simple_args(_args_, _seq_) \
  { /* noop */ }

/* not traced */
#define nasd_dt_tread_simple_args(_args_, _seq_) \
  { /* noop */ }

#define nasd_dt_write_simple_args(_args_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_WRITE_SIMPLE, \
    sizeof(nasd_p_smpl_op_dr_args_otw_t), _args_, _seq_, 1)

#define nasd_dt_setattr_args(_args_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_SETATTR, \
    sizeof(nasd_p_setattr_dr_args_otw_t), _args_, _seq_, 1)

#define nasd_dt_flush_obj_args(_args_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_FLUSH, \
    sizeof(nasd_p_flush_obj_dr_args_otw_t), _args_, _seq_, 1)

#define nasd_dt_remove_args(_args_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_REMOVE, \
    sizeof(nasd_p_remove_dr_args_otw_t), _args_, _seq_, 1)

#define nasd_dt_eject_obj_args(_args_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_EJECT, \
    sizeof(nasd_p_eject_obj_dr_args_otw_t), _args_, _seq_, 1)

#define nasd_dt_sync_args( _seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_SYNC, \
    0, NULL, _seq_, 1)

#define nasd_dt_part_creat_args(_args_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_PART_CREAT, \
    sizeof(nasd_p_part_creat_dr_args_otw_t), _args_, _seq_, 1)

#define nasd_dt_strt_iread_args(_args_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_STRT_IREAD, \
    sizeof(nasd_p_strt_iread_dr_args_otw_t), _args_, _seq_, 1)

#define nasd_dt_stop_iread_args(_args_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_STOP_IREAD, \
    sizeof(nasd_p_stop_iread_dr_args_otw_t), _args_, _seq_, 1)

#define nasd_dt_rshutdown_args(_args_,_seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_RSHUTDOWN, \
    sizeof(nasd_p_rshutdown_dr_args_otw_t), _args_, _seq_, 1)

#define nasd_dt_remote_attach_args(_args_,_seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_REMOTE_ATTACH, \
    sizeof(nasd_p_remote_attach_dr_args_otw_t), _args_, _seq_, 0)

#define nasd_dt_remote_invoke_args(_args_,_seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_REMOTE_INVOKE, \
    sizeof(nasd_p_smpl_op_dr_args_otw_t), _args_, _seq_, 0)

#define nasd_dt_remote_detach_args(_args_,_seq_) \
  nasd_dt_trace_enter(NASD_TR_ARG, NASD_TR_REMOTE_DETACH, \
    sizeof(nasd_p_remote_detach_dr_args_otw_t), _args_, _seq_, 0)

#define nasd_dt_noop_res(_seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_NOOP, \
    0, NULL, &(_seq_), 0)

#define nasd_dt_create_res(_res_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_CREATE, \
    sizeof(nasd_p_create_dr_res_otw_t), _res_, &(_seq_), 0)

#define nasd_dt_getattr_res(_res_,_seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_GETATTR, \
    sizeof(nasd_p_getattr_dr_res_otw_t), _res_, &(_seq_), 0)

#define nasd_dt_read_simple_res(_res_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_READ_SIMPLE, \
    sizeof(nasd_p_fastread_dr_res_otw_t), _res_, &(_seq_), 0)

/* not traced */
#define nasd_dt_read2_simple_res(_res_, _seq_) \
  { /* noop */ }

/* not traced */
#define nasd_dt_tread_simple_res(_res_, _seq_) \
  { /* noop */ }

#define nasd_dt_write_simple_res(_res_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_WRITE_SIMPLE, \
    sizeof(  nasd_p_fastwrite_dr_res_t ), _res_, &(_seq_), 0)

#define nasd_dt_setattr_res(_res_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_SETATTR, \
    sizeof(nasd_p_setattr_dr_res_otw_t), _res_, &(_seq_), 0)

#define nasd_dt_flush_obj_res(_res_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_FLUSH, \
    sizeof(nasd_p_flush_obj_dr_res_otw_t), _res_, &(_seq_), 0)

#define nasd_dt_remove_res(_res_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_REMOVE, \
    sizeof(nasd_p_remove_dr_res_otw_t), _res_, &(_seq_), 0)

#define nasd_dt_eject_obj_res(_res_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_EJECT, \
    sizeof(nasd_p_eject_obj_dr_res_otw_t), _res_, &(_seq_), 0)

#define nasd_dt_sync_res( _seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_SYNC, \
    0, NULL, &(_seq_), 0)

#define nasd_dt_part_creat_res(_res_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_PART_CREAT, \
    sizeof(nasd_p_part_creat_dr_res_otw_t), _res_, &(_seq_), 0)

#define nasd_dt_strt_iread_res(_res_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_STRT_IREAD, \
    sizeof(nasd_p_strt_iread_dr_res_otw_t), _res_, &(_seq_), 0)

#define nasd_dt_stop_iread_res(_res_, _seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_STOP_IREAD, \
    sizeof(nasd_p_stop_iread_dr_res_otw_t), _res_, &(_seq_), 0)

#define nasd_dt_rshutdown_res(_res_,_seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_RSHUTDOWN, \
    sizeof(nasd_p_rshutdown_dr_res_otw_t), _res_, &(_seq_), 0)

#define nasd_dt_remote_attach_res(_res_,_seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_REMOTE_ATTACH, \
    sizeof(nasd_p_remote_attach_dr_res_otw_t), _res_, &(_seq_), 0)

#define nasd_dt_remote_invoke_res(_res_,_seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_REMOTE_INVOKE, \
    sizeof(nasd_p_fastread_dr_res_otw_t_), _res_, &(_seq_), 1)

#define nasd_dt_remote_detach_res(_res_,_seq_) \
  nasd_dt_trace_enter(NASD_TR_RES, NASD_TR_REMOTE_DETACH, \
    sizeof(nasd_p_remote_detach_dr_res_otw_t), _res_, &(_seq_), 0)



#else /* NASD_TRACE_DR > 0 */


#define nasd_dt_noop_args(_seq_) { /* noop */ }
#define nasd_dt_create_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_getattr_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_read_simple_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_read2_simple_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_tread_simple_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_write_simple_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_setattr_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_flush_obj_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_remove_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_eject_obj_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_sync_args(_seq_) { /* noop */ }
#define nasd_dt_part_creat_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_strt_iread_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_stop_iread_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_rshutdown_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_remote_attach_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_remote_invoke_args(_args_,_seq_) { /* noop */ }
#define nasd_dt_remote_detach_args(_args_,_seq_) { /* noop */ }


#define nasd_dt_noop_res(_seq_) { /* noop */ }
#define nasd_dt_create_res(_res_,_seq_) { /* noop */ }
#define nasd_dt_getattr_res(_res_,_seq_) { /* noop */ }
#define nasd_dt_read_simple_res(_res_,_seq_) { /* noop */ }
#define nasd_dt_read2_simple_res(_res_,_seq_) { /* noop */ }
#define nasd_dt_tread_simple_res(_res_,_seq_) { /* noop */ }
#define nasd_dt_write_simple_res(_res_,_seq_) { /* noop */ }
#define nasd_dt_setattr_res(_res_,_seq_) { /* noop */ }
#define nasd_dt_flush_obj_res(_res_,_seq_) { /* noop */ }
#define nasd_dt_remove_res(_res_,_seq_) { /* noop */ }
#define nasd_dt_eject_obj_res(_res_,_seq_) { /* noop */ }
#define nasd_dt_sync_res(_seq_) { /* noop */ }
#define nasd_dt_part_creat_res(_res_,_seq_) { /* noop */ }
#define nasd_dt_strt_iread_res(_res_,_seq_) { /* noop */ }
#define nasd_dt_stop_iread_res(_res_,_seq_) { /* noop */ }
#define nasd_dt_rshutdown_res(_res,_seq_) { /* noop */ }
#define nasd_dt_remote_attach_res(_res,_seq_) { /* noop */ }
#define nasd_dt_remote_invoke_res(_res,_seq_) { /* noop */ }
#define nasd_dt_remote_detach_res(_res,_seq_) { /* noop */ }

#endif /* NASD_TRACE_DR > 0 */

#endif /* !_NASD_TRACE_DR_H_ */
