/*
 * nasd_trace.h
 *
 * Shared structures and defs for NASD tracing.
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_TRACE_H_
#define _NASD_TRACE_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_base_types.h>
#include <nasd/nasd_types.h>

/*
 * Trace classes
 */
#define NASD_TR_TRACE       (1<<00)
#define NASD_TR_ARG         (1<<01)
#define NASD_TR_RES         (1<<02)

/*
 * TRACE traces
 */
#define NASD_TR_OVERFLOW       1

/*
 * ARGS and RES traces
 */
#define NASD_TR_NOOP           1
#define NASD_TR_CREATE         2
#define NASD_TR_GETATTR        3
#define NASD_TR_READ_SIMPLE    4
#define NASD_TR_WRITE_SIMPLE   5
#define NASD_TR_SETATTR        6
#define NASD_TR_FLUSH          7
#define NASD_TR_REMOVE         8
#define NASD_TR_EJECT          9
#define NASD_TR_SYNC          10
#define NASD_TR_PART_CREAT    11
#define NASD_TR_STRT_IREAD    12
#define NASD_TR_STOP_IREAD    13
#define NASD_TR_RSHUTDOWN     14
#define NASD_TR_REMOTE_ATTACH 15
#define NASD_TR_REMOTE_INVOKE 16
#define NASD_TR_REMOTE_DETACH 17

#endif /* !_NASD_TRACE_H_ */
