/*
 * nasd_timeout.h
 *
 * Structures and definitions for NASD timeout mechanism.
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_TIMEOUT_H_
#define _NASD__NASD_TIMEOUT_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_shutdown.h>

typedef nasd_int32 nasd_timeout_flags_t;
typedef nasd_int32 nasd_timeout_status_t;

/*
 * Flags
 */
#define NASD_TIMEOUT_F_PERIODIC (1<<0)
#define NASD_TIMEOUT_F_ABSOLUTE (1<<1)

/*
 * Status
 */
#define NASD_TIMEOUT_S_KNOWN     (1<<0)
#define NASD_TIMEOUT_S_RUNNING   (1<<1)
#define NASD_TIMEOUT_S_CANCELLED (1<<2)
#define NASD_TIMEOUT_S_PERIODIC  (1<<3)

#if defined(DEC_OSF) && defined(KERNEL)
#include <nasd/dux/nasd_dux_timeout_kernel.h>
#define NASD_TIMEOUT_SYS_DEFINED
#endif /* defined(DEC_OSF) && defined(KERNEL) */

#if defined(LINUX) && defined(KERNEL)
#include <nasd/linux/nasd_linux_timeout_kernel.h>
#define NASD_TIMEOUT_SYS_DEFINED
#endif /* defined(LINUX) && defined(KERNEL) */

#ifndef NASD_TIMEOUT_SYS_DEFINED
#define NASD_TIMEOUT_SYS_DEFINED

/*
 * "generic" timeout implementation
 */
typedef struct nasd_timeout_s  nasd_timeout_t;
typedef nasd_uint64            nasd_timeout_handle_t;

#define NASD_TIMEOUT_HANDLE_NULL 0

struct nasd_timeout_s {
  nasd_timespec_t          tm_time;
  nasd_timespec_t          tm_interval;
  nasd_timeout_status_t    tm_status;
  nasd_timeout_handle_t    tm_handle;
  void                   (*tm_proc)(nasd_timeout_handle_t, void *, void *);
  void                    *tm_arg1;
  void                    *tm_arg2;
  nasd_timeout_t          *tm_bprev;
  nasd_timeout_t          *tm_bnext;
  nasd_timeout_t          *tm_prev;
  nasd_timeout_t          *tm_next;
};

#endif /* !NASD_TIMEOUT_SYS_DEFINED */

typedef void (*nasd_timeout_proc_t)(
  nasd_timeout_handle_t   tm,
  void                   *arg1,
  void                   *arg2);

nasd_status_t nasd_timeout_real_init(void);
void nasd_timeout_real_shutdown(void);
void nasd_timeoutsys_init(void);
nasd_status_t nasd_timeout_init(void);
void nasd_timeout_shutdown(void);

#if NASD_TIMEOUT_TEST > 0
nasd_status_t nasd_timeout_test(nasd_timespec_t delta);
#endif /* NASD_TIMEOUT_TEST > 0 */

/* system-specific hooks */
nasd_status_t nasd_sys_timeout_init(nasd_shutdown_list_t  *sl);
nasd_status_t nasd_timeout_cancel(nasd_timeout_handle_t tmh);
nasd_status_t nasd_timeout_get_status(nasd_timeout_handle_t tmh,
  nasd_timeout_status_t *tsp);
nasd_status_t nasd_timeout_add(nasd_timeout_handle_t *tmhp,
  nasd_timeout_proc_t proc, void *arg1, void *arg2,
  nasd_timespec_t first, nasd_timespec_t interval,
  nasd_timeout_flags_t flags);
void nasd_timeout_suspend(void);
void nasd_timeout_resume(void);

#endif /* !_NASD__NASD_TIMEOUT_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
