/*
 * nasd_keymgmt_afs.h
 *
 * Routines to access keys 
 *
 * Author: Howard Gobioff
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_KEYMGMT_AFS_H_ 
#define _NASD_KEYMGMT_AFS_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>

/* default path for a file manager to find is keys */
#define NASD_DEFAULT_KEYFILE "./my_keys"

nasd_status_t nasd_security_get_red_key(int fd, nasd_key_t target);
nasd_status_t nasd_security_get_black_key(int fd, nasd_key_t target);
nasd_status_t nasd_security_get_partition_key(nasd_partnum_t part, nasd_key_t target);

nasd_status_t nasd_security_init_key_mgmt(char *keyfile,char *password,int init_from_key);

#endif /* !_NASD_KEYMGMT_AFS_H_  */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
