/*
 * nasd_getopt.h
 *
 * Header for doing getopt in platform-independent ways
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_GETOPT_H_
#define _NASD__NASD_GETOPT_H_

#include <nasd/nasd_options.h>

#include <stdlib.h>

#if !defined(SOLARIS) && !defined(FREEBSD)
#include <getopt.h>
#endif /* !SOLARIS && !FREEBSD */

#ifdef FREEBSD
#include <unistd.h>
#endif /* FREEBSD */

extern char *nasd_optarg;
extern int   nasd_optind;
extern int   nasd_optopt;

extern int nasd_getopt(int argc, char **argv, char *optstring,
  char *optchar);

#ifndef NASD_GETOPT_C
#define optarg USE_OF_WRONG_OPTARG_DETECTED
#define optind USE_OF_WRONG_OPTIND_DETECTED
#define optopt USE_OF_WRONG_OPTOPT_DETECTED
#endif /* !NASD_GETOPT_C */

#endif /* !_NASD__NASD_GETOPT_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
