/*
 * nasd_edrfs_client_dce.h
 *
 * header for EDRFS clients doing DCE
 *
 * Authors: Jim Zelenka, Nat Lanza
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_EDRFS_CLIENT_DCE_H_
#define _NASD__NASD_EDRFS_CLIENT_DCE_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_itypes.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_edrfs_client.h>

typedef struct nasd_edrfscli_handle_dce_s {
  rpc_binding_handle_t  h;
} nasd_edrfscli_handle_dce_t;

extern void nasd_edrfscli_dce_register(int counter_lock_held);
extern nasd_status_t nasd_edrfscli_dce_init(nasd_shutdown_list_t *sl);


extern void nasd_edrfsdce_null(
  nasd_edrfs_handle_t   handle,
  nasd_res_t           *res,
  error_status_t       *status);


extern void nasd_edrfsdce_mount(
  nasd_edrfs_handle_t       handle,
  nasd_edrfs_mount_args_t  *args,
  nasd_edrfs_mount_res_t   *res,
  error_status_t           *status);


extern void nasd_edrfsdce_fsstat(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_fsstat_args_t  *args,
  nasd_edrfs_fsstat_res_t   *res,
  error_status_t            *status);


extern void nasd_edrfsdce_fsinfo(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_fsinfo_args_t  *args,
  nasd_edrfs_fsinfo_res_t   *res,
  error_status_t            *status);


extern void nasd_edrfsdce_lookup_otw_provided(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_lookup_args_t  *args,
  nasd_edrfs_lookup_res_t   *res,
  nasd_otw_base_t           *args_otw_p,
  nasd_otw_base_t           *res_otw_p,
  error_status_t            *status);


extern void nasd_edrfsdce_lookup(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_lookup_args_t  *args,
  nasd_edrfs_lookup_res_t   *res,
  error_status_t            *status);


extern void nasd_edrfsdce_readdir(
  nasd_edrfs_handle_t         handle,
  nasd_edrfs_readdir_args_t  *args,
  nasd_edrfs_dirent_t        *out_entries,
  nasd_edrfs_readdir_res_t   *res,
  error_status_t             *status);


extern void nasd_edrfsdce_access(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_access_args_t  *args,
  nasd_edrfs_access_res_t   *res,
  error_status_t            *status);


extern void nasd_edrfsdce_setattr(
  nasd_edrfs_handle_t         handle,
  nasd_edrfs_setattr_args_t  *args,
  nasd_edrfs_setattr_res_t   *res,
  error_status_t             *status);


extern void nasd_edrfsdce_create_otw_provided(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_create_args_t  *args,
  nasd_edrfs_create_res_t   *res,
  nasd_otw_base_t           *args_otw_p,
  nasd_otw_base_t           *res_otw_p,
  error_status_t            *status);


extern void nasd_edrfsdce_create(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_create_args_t  *args,
  nasd_edrfs_create_res_t   *res,
  error_status_t            *status);


extern void nasd_edrfsdce_symlink(
  nasd_edrfs_handle_t         handle,
  nasd_edrfs_symlink_args_t  *args,
  nasd_edrfs_symlink_res_t   *res,
  error_status_t             *status);


extern void nasd_edrfsdce_remove(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_remove_args_t  *args,
  nasd_edrfs_remove_res_t   *res,
  error_status_t            *status);


extern void nasd_edrfsdce_mkdir(
  nasd_edrfs_handle_t       handle,
  nasd_edrfs_mkdir_args_t  *args,
  nasd_edrfs_mkdir_res_t   *res,
  error_status_t           *status);


extern void nasd_edrfsdce_rmdir(
  nasd_edrfs_handle_t       handle,
  nasd_edrfs_rmdir_args_t  *args,
  nasd_edrfs_rmdir_res_t   *res,
  error_status_t           *status);


extern void nasd_edrfsdce_newcookie(
  nasd_edrfs_handle_t           handle,
  nasd_edrfs_newcookie_args_t  *args,
  nasd_edrfs_newcookie_res_t   *res,
  error_status_t               *status);


extern void nasd_edrfsdce_rename(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_rename_args_t  *args,
  nasd_edrfs_rename_res_t   *res,
  error_status_t            *status);


extern void nasd_edrfsdce_getstats(
  nasd_edrfs_handle_t         handle,
  nasd_edrfs_getstats_res_t  *res,
  error_status_t             *status);

extern void nasd_edrfsdce_resetstats(
  nasd_edrfs_handle_t   handle,
  nasd_res_t           *res,
  error_status_t       *status);


#endif /* !_NASD__NASD_EDRFS_CLIENT_DCE_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
