/*
 * nasd_cheops_mgr_common.h 
 *
 * common CHEOPS storage manager definitions
 *
 * Authors: Khalil Amiri, CMU SCS/ECE, July 18 1997
 *          Sean Levy, CMU SCS, July 1999
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_CHEOPS_MGR_COMMON_H_
#define _NASD_CHEOPS_MGR_COMMON_H_

typedef enum { NASD_CHEOPS_OP_BS_CREATE,
	       NASD_CHEOPS_OP_BS_REMOVE,
	       NASD_CHEOPS_OP_BS_LOOKUP,
	       NASD_CHEOPS_OP_BS_GETATTR,
	       NASD_CHEOPS_OP_BS_SETATTR,
	       NASD_CHEOPS_OP_DR_LOOKUP,
	       NASD_CHEOPS_OP_MGR_LOOKUP,
	       NASD_CHEOPS_OP_FAIL_REPORT
} nasd_cheops_mgr_op_t;

/*
 * Prototypes
 */
extern int nasd_cheops_mgr_init(
  char                          *resource_file,
  char                          *dmap_file,
  char				*imap_file,
  int                            partition_id,
  int                            partition_size,
  int                            default_binding_type,
  int                            stripe_unit,
  int                            stripe_width,
  nasd_cheops_raid_level_t       raid_level,
  int                            quietude,
  int				 clear_old_state,
  int				 override_defaults);
extern int nasd_cheops_mgr_shutdown(void);

/*
 * Globals
 */
extern int Default_Stripe_Unit_Size;
extern nasd_cheops_raid_level_t Default_RAID_Level;
extern int Default_Stripe_Width;
extern int Default_Partition_Size;

#endif /* _NASD_CHEOPS_MGR_COMMON_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
