/*
 * nasd_edrfs_client_linux_ioctl.h
 *
 * ioctl requests to the kernel for NASD/EDRFS.
 *
 * Author: Nat Lanza
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_edrfs_types.h>

typedef struct nasd_edrfs_file_ident_s nasd_edrfs_file_ident_t;

struct nasd_edrfs_file_ident_s {
  nasd_identifier_t  nasd_identifier;
  nasd_cookie_t      cookie;
  nasd_int32         drive_address;
  nasd_int16         partnum;
};

#define NASD_EDRFS_GET_NASDID    _IOR('N', 80, nasd_edrfs_file_ident_t)
#define NASD_EDRFS_GET_THRESHOLD _IOR('N', 81, nasd_int32)
#define NASD_EDRFS_SET_THRESHOLD _IOR('N', 82, nasd_int32)
#define NASD_EDRFS_USER_CONTROL   _IO('N', 83)
