/*
 * nasd_dux_threads_kernel.h
 *
 * Inside-dux-kernel variant of threads portability layer
 *
 * Authors: Mark Holland, Daniel Stodolsky, Jim Zelenka, Marc Unangst
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1995,1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_DUX_THREADS_KERNEL_H_
#define _NASD__NASD_DUX_THREADS_KERNEL_H_

#include <nasd/nasd_options.h>
#include <kern/task.h>
#include <kern/thread.h>
#include <kern/lock.h>
#include <kern/sched_prim.h>

extern task_t first_task;

typedef struct nasd_once_s nasd_once_t;
struct nasd_once_s {
  int  done;
};

#define NASD_DECLARE_ONCE(_o_)                nasd_once_t _o_;

#define NASD_SYS_DECLARE_MUTEX(_m_)           decl_simple_lock_data(,(_m_))
#define NASD_SYS_DECLARE_STATIC_MUTEX(_m_)    decl_simple_lock_data(static,(_m_))
#define NASD_SYS_DECLARE_EXTERN_MUTEX(_m_)    decl_simple_lock_data(extern,(_m_))
#define NASD_SYS_DECLARE_COND(_c_)            int _c_;
#define NASD_SYS_DECLARE_STATIC_COND(_c_)     static int _c_;
#define NASD_SYS_DECLARE_EXTERN_COND(_c_)     extern int _c_;

#define NASD_SYS_LOCK_MUTEX(_m_)              simple_lock(&(_m_))
#define NASD_SYS_TRY_LOCK_MUTEX(_m_)          simple_lock_try(&(_m_))
#define NASD_SYS_UNLOCK_MUTEX(_m_)            simple_unlock(&(_m_))

extern int _nasd_once(nasd_once_t *once_block,
  void (*init_routine)(void), char *file, int line);
#define nasd_once(_o_,_i_) _nasd_once(_o_, (void (*)(void))_i_, __FILE__, __LINE__)

#define NASD_SYS_WAIT_COND(_c_,_m_) { \
  assert_wait((vm_offset_t)&(_c_), TRUE); \
  NASD_UNLOCK_MUTEX(_m_); \
  thread_block(); \
  NASD_LOCK_MUTEX(_m_); \
}
#define NASD_SYS_SIGNAL_COND(_c_) \
  thread_wakeup_one(((vm_offset_t)&(_c_)))
#define NASD_SYS_BROADCAST_COND(_c_) \
  thread_wakeup(((vm_offset_t)&(_c_)))

typedef unsigned long       nasd_thread_id_t;
#define NASD_THREAD_ID_FMT  NASD_64u_FMT
#define NASD_THREAD_ID_NULL ((nasd_thread_id_t)THREAD_NULL)

#define nasd_thread_self() ((nasd_thread_id_t)current_thread())

#define NASD_THREAD_KILL_SELF() { \
  thread_terminate(current_thread()); \
  thread_halt_self(); \
}

typedef struct nasd_sys_threadattr_s  nasd_sys_threadattr_t;
struct nasd_sys_threadattr_s {
  int  dummy;
};

typedef thread_t  nasd_sys_thread_t;
typedef void *    nasd_threadarg_t;

#if NASD_USE_DUX_RW_LOCKS > 0

#define NASD_TS_RWLOCK_DECLARED 1

#define NASD_DECLARE_RWLOCK(_name_) lock_data_t _name_ ;
#define NASD_LOCK_READ(_l_)     lock_read(&(_l_))
#define NASD_UNLOCK_READ(_l_)   lock_read_done(&(_l_))
#define NASD_LOCK_WRITE(_l_)    lock_write(&(_l_))
#define NASD_UNLOCK_WRITE(_l_)  lock_write_done(&(_l_))

#endif /* NASD_USE_DUX_RW_LOCKS > 0 */

#endif /* !_NASD__NASD_DUX_THREADS_KERNEL_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
