/*
 * libcrypt.h
 */
/*
 * This is version 1.2 of CryptoLib
 *
 * The authors of this software are Jack Lacy, Don Mitchell and Matt Blaze
 *              Copyright (c) 1991, 1992, 1993, 1994, 1995 by AT&T.
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * NOTE:
 * Some of the algorithms in cryptolib may be covered by patents.
 * It is the responsibility of the user to ensure that any required
 * licenses are obtained.
 *
 *
 * SOME PARTS OF CRYPTOLIB MAY BE RESTRICTED UNDER UNITED STATES EXPORT
 * REGULATIONS.
 *
 *
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR AT&T MAKE ANY
 * REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
 * OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */
#ifndef LIBCRYPT_H
#define LIBCRYPT_H
#include <nasd/nasd_options.h>
#include <nasd/nasd_general.h>
/* Crimes commited by H. Gobioff to get libcrypt to use standard libc calls 
and use nasd ...umm..error handling */

#define handle_exception(_foo_,_bar_)  {nasd_printf("ERROR: %s:%d  %s \n", __FILE__, __LINE__,_bar_); NASD_PANIC();}
#define clib_memzero(_ptr_,_sz_) bzero((_ptr_),(_sz_))
#define clib_memcpy(_src_,_dest_,_sz_) memcpy((_dest_), (_src_), (_sz_))
#define clib_memcmp(_arg1_,_arg2_,_sz_) memcmp((_arg1_), (_arg2_), (_sz_))


#ifndef KERNEL
#include <stdio.h>	
#endif
#define P_CRYPT(a)     a


/* HMAC & SHA1 were added by hgobioff
    SHA - 1 is from ssleay (see the header file)
    HMAC is taken from the HMAC RFC */
/* SHA-1  Stuff */
#include <cryptolib/sha.h>


/* HMAC-SHA1 STUFF */

typedef struct {
   SHA_CTX sha1_stuff;
   char k_opad[65];
} HMAC_SHA1_CTX;

void HMAC_SHA1_Init P_CRYPT ((HMAC_SHA1_CTX*,char *,int));
void HMAC_SHA1_Update P_CRYPT ((HMAC_SHA1_CTX *, unsigned char *, unsigned int)); 
void HMAC_SHA1_Final  P_CRYPT ((unsigned char [20], HMAC_SHA1_CTX *));


#endif



