/*
 * nasd_edrfs_test_common.h
 *
 * Internal definitions for the NASD EDRFS test library
 *
 * Author: Nat Lanza
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_EDRFS_TEST_COMMON_H_
#define _NASD_EDRFS_TEST_COMMON_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_error.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_pdrive_client.h>
#include <nasd/nasd_edrfs_client.h>

/* debug magic */
#define DEBUGLEVEL 0

#define DEBUG(_x_) if (DEBUGLEVEL < (_x_)) ; else 

/* convenience types */

struct nasd_edrfs_mount_info_s {
  char *server_name;
  char *path_name;
  int binding_type;
  nasd_edrfs_handle_t server_handle;
  nasd_net_address_t drive_addr;
  nasd_edrfs_identifier_t root_ident;
  nasd_cookie_t cookie;
};

typedef struct nasd_edrfs_mount_info_s nasd_edrfs_mount_info_t;


/* init the client libraries and bind to the filemanager. do this first. */
nasd_status_t nasd_edrfs_test_init(nasd_edrfs_mount_info_t *minfo);

/* try to shut down cleanly when we exit. it's polite. */
nasd_status_t nasd_edrfs_test_shutdown(nasd_edrfs_mount_info_t *minfo);

/* do the mount dance. needed before any other rpcs, since otherwise
   we don't know anything about the actual drive */
nasd_status_t nasd_edrfs_test_rpc_mount(nasd_edrfs_mount_info_t *minfo);

/* Used to excode unprintable data structures */
int nasd_edrfs_test_encode_len(int len);
nasd_status_t nasd_edrfs_test_encode(char **str, nasd_byte *data, int len);
nasd_status_t nasd_edrfs_test_decode(nasd_byte **data, int *len, char *str);

/* neat little function that converts a string to the error number */
nasd_status_t nasd_edrfs_test_rc_convert(char *arg, nasd_status_t *rc);

void nasd_edrfs_test_print_attribute(const nasd_attribute_t attr);

#endif /* !_NASD_EDRFS_TEST_COMMON_H_ */
