/*
 * nasd_linux_hostlocal_kernel.c
 *
 * Linux in-kernel version of hostlocal
 *
 * Author: Nat Lanza
 */
/*
 * Copyright (c) of Carnegie Mellon University, 2000.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */

#include <nasd/nasd_options.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_shutdown.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_srpc.h>

#include <linux/if.h>

nasd_status_t nasd_hostlocal(char *remote_name) {
  /* XXX
   *
   * This should really be fixed so that it does the right
   * thing. Iterating over the available interfaces from inside the
   * kernel shouldn't be too hard; either calling dev_ifconf or just
   * futzing with gifconf_list directly to get the ifconf structure
   * and then proceeding like in userspace should work.
   *
   * So if this is easy to do, why didn't I do it? Partially because I
   * didn't want to have to make yet another kernel patch to export some
   * more symbols that the kernel for some reason doesn't export just so
   * I can discover that I'm violating some unwritten assumption about
   * whether my argument data is in userspace or not and therefore
   * make my system crash and waste a day or so of my time debugging
   * it. Besides, this function is really only useful if the client's
   * RPC bindings list contains both colocation and a real RPC, and
   * that's never true right now. I'd like it to be, but since I just
   * spent three days in symbol resolution and preprocessor macro hell
   * trying without success to get a colocate-capable client to load
   * without the drive needing to be loaded first, I'm just not going
   * to fucking bother.
   *
   * I am amazingly sick of all the little painful "oh, we didn't
   * think of that so it's COMPLETELY BROKEN and if you complain we'll
   * tell you that OF COURSE YOU SHOULDN'T DO IT THAT WAY, YOU FOOL"
   * issues in this kernel. So I'm just going to add a little #ifdef
   * that should work for the current client, and then I am going to
   * go have a nice dinner and consume a margarita the size of my
   * head.
   *
   *   -- nat
   */

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_NONE
  /* colocation is the only RPC. so this had better succeed. */
  return NASD_SUCCESS;
#else
  /* SRPC never calls this. in fact, it should NEVER BE CALLED in
     this case. but we'll be polite and not NASD_PANIC(). */
  return NASD_FAIL;
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_NONE */
}
