/*
 * nasd_generic_gethostbyname.c
 *
 * gethostbyname() front-end for systems without gethostbyname_r().
 *
 * Authors: Marc Unangst, Jim Zelenka, Sean Levy
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_sys.h>
#include <nasd/nasd_general.h>
#include <nasd/nasd_threadstuff.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

nasd_status_t nasd_generic_gethostbyname_mutex_status = NASD_SYS_NOT_INITIALIZED;

NASD_DECLARE_ONCE(nasd_generic_gethostbyname_init_once)
NASD_DECLARE_MUTEX(nasd_generic_gethostbyname_mutex)

void
nasd_generic_gethostbyname_init()
{
  nasd_status_t rc;

  rc = nasd_mutex_init(&nasd_generic_gethostbyname_mutex);
  nasd_generic_gethostbyname_mutex_status = rc;
}

nasd_status_t
nasd_gethostbyname_r(
  char            *hostname,
  struct hostent  *hep)
{
  struct hostent *lhp;
  int rc;

  nasd_once(&nasd_generic_gethostbyname_init_once,
    nasd_generic_gethostbyname_init);

  if (nasd_generic_gethostbyname_mutex_status)
    return(nasd_generic_gethostbyname_mutex_status);

  rc = NASD_FAIL;

  NASD_LOCK_MUTEX(nasd_generic_gethostbyname_mutex);

  lhp = gethostbyname(hostname);
  if (lhp) {
    rc = NASD_SUCCESS;
    bcopy(lhp, hep, sizeof(struct hostent));
  }

  NASD_UNLOCK_MUTEX(nasd_generic_gethostbyname_mutex);

  return(rc);
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
