/*
 * sio_error_string.c
 *
 * Turn SIO error codes into ASCII strings
 *
 * Authors: Khalil Amiri, CMU SCS/ECE, July 18 1997
 *          Sean Levy, CMU SCS, July 1999
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */

#include "_sio_internal.h"
#include <stdio.h>

const char * const _sio_error_strings[] = {
	"no error",		/*  0: SIO_SUCCESS */
	"file already exists",	/*  1: SIO_ERR_ALREADY_EXISTS */
	"control failed",	/*  2: SIO_ERR_CONTROL_FAILED */
	"control not attempted",
				/*  3: SIO_ERR_CONTROL_NOT_ATTEMPTED */
	"control not possible for sio_test()",
				/*  4: SIO_ERR_CONTROL_NOT_ON_TEST */
	"control would have succeeded",
				/*  5: SIO_ERR_CONTROL_WOULD_HAVE_SUCCEEDED */
	"controls clash",	/*  6: SIO_ERR_CONTROLS_CLASH */
	"file not found",	/*  7: SIO_ERR_FILE_NOT_FOUND */
	"file open",		/*  8: SIO_ERR_FILE_OPEN */
	"incorrect mode",	/*  9: SIO_ERR_INCORRECT_MODE */
	"invalid hint class",	/* 10: SIO_ERR_INVALID_CLASS */
	"invalid file descriptor",
				/* 11: SIO_ERR_INVALID_DESCRIPTOR */
	"invalid extension",	/* 12: SIO_ERR_INVALID_EXTENSION */
	"invalid file I/O list",
				/* 13: SIO_ERR_INVALID_FILE_LIST */
	"invalid file name",	/* 14: SIO_ERR_INVALID_FILENAME */
	"invalid handle",	/* 15: SIO_ERR_INVALID_HANDLE */
	"invalid iteration",	/* 16: SIO_ERR_INVALID_ITERATION */
	"invalid memory I/O list",
				/* 17: SIO_ERR_INVALID_MEMORY_LIST */
	"invalid participant",	/* 18: SIO_ERR_INVALID_PARTICIPANT */
	"I/O canceled",		/* 19: SIO_ERR_IO_CANCELED */
	"I/O failed",		/* 20: SIO_ERR_IO_FAILED */
	"I/O in progress",	/* 21: SIO_ERR_IO_IN_PROGRESS */
	"maximum number of outstanding async I/O operations exceeded",
				/* 22: SIO_ERR_MAX_ASYNC_OUTSTANDING_EXCEEDED */
	"maximum number of collective I/O iterations exceeded",
				/* 23: SIO_ERR_MAX_COLL_ITERATIONS_EXCEEDED */
	"maximum number of outstanding collective I/O operations exceeded",
				/* 24: SIO_ERR_MAX_COLL_OUTSTANDING_EXCEEDED */
	"maximum number of collective I/O participants exceeded",
				/* 25: SIO_ERR_MAX_COLL_PARTICIPANTS_EXCEEDED */
	"maximum number of open files exceeded",
				/* 26: SIO_ERR_MAX_OPEN_EXCEEDED */
	"mixed async I/O and collective I/O handles",
				/* 27: SIO_ERR_MIXED_COLL_AND_ASYNC */
	"out of space",		/* 28: SIO_ERR_NO_SPACE */
	"control usable only when creating files",
				/* 29: SIO_ERR_ONLY_AT_CREATE */
	"control usable only when opening files",
				/* 30: SIO_ERR_ONLY_AT_OPEN */
	"operation unsupported",
				/* 31: SIO_ERR_OP_UNSUPPORTED */
	"file and mem I/O lists unequal",
				/* 32: SIO_ERR_UNEQUAL_LISTS */
	"invalid flags",	/* 33: SIO_ERR_VEND_INVALID_FLAGS */
	"async I/O status already being awaited",
				/* 34: SIO_ERR_VEND_ASYNC_ALREADY_WAITING */
	"end of file reached"
	                        /* 35: SIO_ERR_VEND_EOF */
};

const char *
sio_error_string(sio_return_t result)
{
  if (result >= 0 && result <
      (sizeof _sio_error_strings / sizeof _sio_error_strings[0]))
    return (_sio_error_strings[result]);

  if (result >= SIO_ERR_VEND_OSERR_FIRST &&
      result <= SIO_ERR_VEND_OSERR_LAST)
    return (strerror(result - SIO_ERR_VEND_OSERR_FIRST));

  return "UNKNOWN SIO ERROR CODE";
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
