/*
 * nasd_cheops_cl_srpc.c
 */
/*
 * Cheops RPC wrappers for SRPC
 *
 */
/*
 * Copyright (c) 1996,1997,1998,1999 Carnegie Mellon University.
 * All rights reserved.
 *
 * Author: Sean Levy
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND
 * FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie Mellon the
 * rights to redistribute these changes.
 */

#include <nasd/nasd_options.h>

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC

# include <nasd/nasd_threadstuff.h>
# include <nasd/nasd_shutdown.h>
# include <nasd/nasd_types.h>
# include <nasd/nasd_common.h>
# include <nasd/nasd_freelist.h>
# include <nasd/nasd_srpc_types.h>
# include <nasd/nasd_srpc.h>
# include <nasd/nasd_marshall.h>
# include <nasd/nasd_cheops_rpc.h>
# include <nasd/nasd_cheops_client.h>
# include <nasd/nasd_cheops_mgr_cstub.h>

nasd_status_t
nasd_cheops_client_srpc_init(
  nasd_shutdown_list_t          *sl)
{
  return NASD_SUCCESS;
}

nasd_status_t
nasd_cheops_client_srpc_bind(
  nasd_cheops_handle_t           handle,
  char                          *mgr_name,
  char                          *portnum,
  int                            binding_type,
  void                          *binding_param,
  int                            binding_param_len)
{
  nasd_cheops_handle_srpc_t *rpch;
  nasd_status_t rc;

  rpch = (nasd_cheops_handle_srpc_t *)handle->rpc_specific_handle;
  rc = nasd_srpc_bind_to_server(mgr_name, portnum, &rpch->h);
  return rc;
}

nasd_status_t
nasd_cheops_client_srpc_unbind(
  nasd_cheops_handle_t           handle)
{
  nasd_cheops_handle_srpc_t *rpch;
  nasd_status_t rc;

  rpch = (nasd_cheops_handle_srpc_t *)handle->rpc_specific_handle;
  rc = nasd_srpc_unbind_server(&rpch->h);
  return rc;
}

void
nasd_cheops_client_srpc_null(
  nasd_cheops_handle_t           handle,
  nasd_res_t                    *res,
  nasd_rpc_status_t             *op_status)
{
  nasd_cheops_handle_srpc_t *rpch;
  nasd_res_otw_t res_otw;
  nasd_srpc_status_t src;

  rpch = (nasd_cheops_handle_srpc_t *)handle->rpc_specific_handle;
  src = nasd_cheops_null_cm_client(rpch->h, res_otw);
  *op_status = src;
  if (src)
    res->nasd_status = NASD_RPC_FAILURE;
  else
    nasd_res_t_unmarshall(res_otw, res);
}

void
nasd_cheops_client_srpc_bs_lookup(
  nasd_cheops_handle_t           handle,
  nasd_cheops_bs_lu_args_t  *args,
  nasd_cheops_bs_lu_res_t   *res,
  nasd_rpc_status_t             *op_status)
{
  nasd_cheops_bs_lu_args_otw_t args_otw;
  nasd_cheops_bs_lu_res_otw_t res_otw;
  nasd_cheops_handle_srpc_t *rpch;
  nasd_srpc_status_t src;

  rpch = (nasd_cheops_handle_srpc_t *)handle->rpc_specific_handle;
  nasd_cheops_bs_lu_args_t_marshall(args, args_otw);
  src = nasd_cheops_bs_lookup_cm_client(rpch->h, args_otw, res_otw);
  *op_status = src;
  if (src)
    res->out_nasd_status = NASD_RPC_FAILURE;
  else
    nasd_cheops_bs_lu_res_t_unmarshall(res_otw, res);
}

void
nasd_cheops_client_srpc_mgr_lookup(
  nasd_cheops_handle_t           handle,
  nasd_cheops_mgr_lookup_args_t *args,
  nasd_cheops_mgr_lu_res_t  *res,
  nasd_rpc_status_t             *op_status)
{
  nasd_cheops_mgr_lookup_args_otw_t args_otw;
  nasd_cheops_mgr_lu_res_otw_t res_otw;
  nasd_cheops_handle_srpc_t *rpch;
  nasd_srpc_status_t src;

  rpch = (nasd_cheops_handle_srpc_t *)handle->rpc_specific_handle;
  nasd_cheops_mgr_lookup_args_t_marshall(args, args_otw);
  src = nasd_cheops_mgr_lookup_cm_client(rpch->h, args_otw, res_otw);
  *op_status = src;
  if (src)
    res->out_nasd_status = NASD_RPC_FAILURE;
  else
    nasd_cheops_mgr_lu_res_t_unmarshall(res_otw, res);
}

void
nasd_cheops_client_srpc_dr_lookup(
  nasd_cheops_handle_t           handle,
  nasd_cheops_dr_lu_args_t  *args,
  nasd_cheops_dr_lu_res_t   *res,
  nasd_rpc_status_t             *op_status)
{
  nasd_cheops_dr_lu_args_otw_t args_otw;
  nasd_cheops_dr_lu_res_otw_t res_otw;
  nasd_cheops_handle_srpc_t *rpch;
  nasd_srpc_status_t src;

  rpch = (nasd_cheops_handle_srpc_t *)handle->rpc_specific_handle;
  nasd_cheops_dr_lu_args_t_marshall(args, args_otw);
  src = nasd_cheops_dr_lookup_cm_client(rpch->h, args_otw, res_otw);
  *op_status = src;
  if (src)
    res->out_nasd_status = NASD_RPC_FAILURE;
  else
    nasd_cheops_dr_lu_res_t_unmarshall(res_otw, res);
}

void
nasd_cheops_client_srpc_bs_refresh(
  nasd_cheops_handle_t           handle,
  nasd_cheops_bs_re_args_t *args,
  nasd_cheops_bs_re_res_t  *res,
  nasd_rpc_status_t             *op_status)
{
  nasd_cheops_bs_re_args_otw_t args_otw;
  nasd_cheops_bs_re_res_otw_t res_otw;
  nasd_cheops_handle_srpc_t *rpch;
  nasd_srpc_status_t src;

  rpch = (nasd_cheops_handle_srpc_t *)handle->rpc_specific_handle;
  nasd_cheops_bs_re_args_t_marshall(args, args_otw);
  src = nasd_cheops_bs_refresh_cm_client(rpch->h, args_otw, res_otw);
  *op_status = src;
  if (src)
    res->out_nasd_status = NASD_RPC_FAILURE;
  else
    nasd_cheops_bs_re_res_t_unmarshall(res_otw, res);
}

void
nasd_cheops_client_srpc_bs_qos_create(
  nasd_cheops_handle_t                   handle,
  nasd_cheops_bs_qc_args_t      *args,
  nasd_cheops_bs_qc_res_t       *res,
  nasd_rpc_status_t                     *op_status)
{
  nasd_cheops_bs_qc_args_otw_t args_otw;
  nasd_cheops_bs_qc_res_otw_t res_otw;
  nasd_cheops_handle_srpc_t *rpch;
  nasd_srpc_status_t src;

  rpch = (nasd_cheops_handle_srpc_t *)handle->rpc_specific_handle;
  nasd_cheops_bs_qc_args_t_marshall(args, args_otw);
  src = nasd_cheops_bs_qos_create_cm_client(rpch->h, args_otw, res_otw);
  *op_status = src;
  if (src)
    res->out_nasd_status = NASD_RPC_FAILURE;
  else
    nasd_cheops_bs_qc_res_t_unmarshall(res_otw, res);
}

void
nasd_cheops_client_srpc_bs_create(
  nasd_cheops_handle_t           handle,
  nasd_cheops_bs_cr_args_t  *args,
  nasd_cheops_bs_cr_res_t   *res,
  nasd_rpc_status_t             *op_status)
{
  nasd_cheops_bs_cr_args_otw_t args_otw;
  nasd_cheops_bs_cr_res_otw_t res_otw;
  nasd_cheops_handle_srpc_t *rpch;
  nasd_srpc_status_t src;

  rpch = (nasd_cheops_handle_srpc_t *)handle->rpc_specific_handle;
  nasd_cheops_bs_cr_args_t_marshall(args, args_otw);
  src = nasd_cheops_bs_create_cm_client(rpch->h, args_otw, res_otw);
  *op_status = src;
  if (src)
    res->out_nasd_status = NASD_RPC_FAILURE;
  else
    nasd_cheops_bs_cr_res_t_unmarshall(res_otw, res);
}

void
nasd_cheops_client_srpc_bs_remove(
  nasd_cheops_handle_t           handle,
  nasd_cheops_bs_rm_args_t  *args,
  nasd_cheops_bs_rm_res_t   *res,
  nasd_rpc_status_t             *op_status)
{
  nasd_cheops_bs_rm_args_otw_t args_otw;
  nasd_cheops_bs_rm_res_otw_t res_otw;
  nasd_cheops_handle_srpc_t *rpch;
  nasd_srpc_status_t src;

  rpch = (nasd_cheops_handle_srpc_t *)handle->rpc_specific_handle;
  nasd_cheops_bs_rm_args_t_marshall(args, args_otw);
  src = nasd_cheops_bs_remove_cm_client(rpch->h, args_otw, res_otw);
  *op_status = src;
  if (src)
    res->out_nasd_status = NASD_RPC_FAILURE;
  else
    nasd_cheops_bs_rm_res_t_unmarshall(res_otw, res);
}

void
nasd_cheops_client_srpc_bs_getattr(
  nasd_cheops_handle_t           handle,
  nasd_cheops_bs_ga_args_t *args,
  nads_cheops_bs_ga_res_t  *res,
  nasd_rpc_status_t             *op_status)
{
  nasd_cheops_bs_ga_args_otw_t args_otw;
  nads_cheops_bs_ga_res_otw_t res_otw;
  nasd_cheops_handle_srpc_t *rpch;
  nasd_srpc_status_t src;

  rpch = (nasd_cheops_handle_srpc_t *)handle->rpc_specific_handle;
  nasd_cheops_bs_ga_args_t_marshall(args, args_otw);
  src = nasd_cheops_bs_getattr_cm_client(rpch->h, args_otw, res_otw);
  *op_status = src;
  if (src)
    res->out_nasd_status = NASD_RPC_FAILURE;
  else
    nads_cheops_bs_ga_res_t_unmarshall(res_otw, res);
}

void
nasd_cheops_client_srpc_bs_setattr(
  nasd_cheops_handle_t           handle,
  nasd_cheops_bs_sa_args_t *args,
  nads_cheops_bs_sa_res_t  *res,
  nasd_rpc_status_t             *op_status)
{
  nasd_cheops_bs_sa_args_otw_t args_otw;
  nads_cheops_bs_sa_res_otw_t res_otw;
  nasd_cheops_handle_srpc_t *rpch;
  nasd_srpc_status_t src;

  rpch = (nasd_cheops_handle_srpc_t *)handle->rpc_specific_handle;
  nasd_cheops_bs_sa_args_t_marshall(args, args_otw);
  src = nasd_cheops_bs_setattr_cm_client(rpch->h, args_otw, res_otw);
  *op_status = src;
  if (src)
    res->out_nasd_status = NASD_RPC_FAILURE;
  else
    nads_cheops_bs_sa_res_t_unmarshall(res_otw, res);
}

nasd_cheops_client_rpcmod_tab_t nasd_cheops_client_srpc_mod = {
  NULL,
  NASD_RPCMOD_INIT_FAIL,

  nasd_cheops_client_srpc_bind,
  nasd_cheops_client_srpc_unbind,

  nasd_cheops_client_srpc_null,
  nasd_cheops_client_srpc_bs_lookup,
  nasd_cheops_client_srpc_mgr_lookup,
  nasd_cheops_client_srpc_dr_lookup,
  nasd_cheops_client_srpc_bs_refresh,
  nasd_cheops_client_srpc_bs_qos_create,
  nasd_cheops_client_srpc_bs_create,
  nasd_cheops_client_srpc_bs_remove,
  nasd_cheops_client_srpc_bs_getattr,
  nasd_cheops_client_srpc_bs_setattr,

  NASD_BIND_SRPC,
  "SRPC",
  sizeof(nasd_cheops_handle_srpc_t),

  NULL
};

void
nasd_cheops_client_srpc_register(
  int   counter_lock_held)
{
  nasd_cheops_client_mod_register(&nasd_cheops_client_srpc_mod,
                                  counter_lock_held);
}

#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
