/*
 * nasd_cheops_cl_dce.c
 */
/*
 * Cheops RPC wrappers for DCE
 *
 */
/*
 * Copyright (c) 1996,1997,1998,1999 Carnegie Mellon University.
 * All rights reserved.
 *
 * Author: Sean Levy
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND
 * FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie Mellon the
 * rights to redistribute these changes.
 */

#include <nasd/nasd_options.h>

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE

# include <dce/dce_error.h>
# include <nasd/nasd_freelist.h>
# include <nasd/nasd_cheops_client.h>
# include <nasd/nasd_cheops_client_dce.h>
# include <nasd/nasd_cheops_rpc.h>
# include <nasd/nasd_cheops_mgr.h>
# include <nasd/nasd_error.h>
# include <nasd/nasd_marshall.h>
# include <sys/errno.h>

# ifdef _KERNEL
#  include <dce/ker/pthread_exc.h>
/* this doesnt exist in the kernel DCE header files for whatever reason */
#  define exc_get_status(e,s) ( \
   (e)->kind == _exc_kind_status ? \
        (*(s) = (e)->match.value, 0) : \
        -1)
# endif /* _KERNEL */

nasd_status_t
nasd_cheops_client_dce_init(
  nasd_shutdown_list_t *sl)
{
  return NASD_SUCCESS;
}

nasd_status_t
nasd_cheops_dce_bind(
  nasd_cheops_handle_t   handle,
  char                  *mgr_name,
  char                  *portnum,
  int                    binding_type,
  void                  *binding_param,
  int                    binding_param_len)
{
  nasd_cheops_handle_dce_t *rpch;
  nasd_status_t rc;

  rpch = (nasd_cheops_handle_dce_t *)handle->rpc_specific_handle;
  if (binding_type == NASD_BIND_DCE_DIRECT_TCP) {
    rc = nasd_dce_direct_bind_to_server((unsigned_char_t *)"ncadg_ip_tcp",
      (unsigned_char_t *)mgr_name, (unsigned_char_t *)portnum,
      &rpch->h);
  } else if (binding_type == NASD_BIND_DCE_DIRECT_UDP) {
    rc = nasd_dce_direct_bind_to_server((unsigned_char_t *)"ncadg_ip_udp",
      (unsigned_char_t *)mgr_name, (unsigned_char_t *)portnum,
      &rpch->h);
  } else
    rc = NASD_BAD_HANDLE_TYPE;

  return rc;
}

nasd_status_t
nasd_cheops_dce_unbind(
  nasd_cheops_handle_t  handle)
{
  nasd_cheops_handle_dce_t *rpch;
  int rc;

  rpch = (nasd_cheops_handle_dce_t *)handle->rpc_specific_handle;
  rc = nasd_dce_direct_unbind_server(&rpch->h);
  if (rc)
    rc = NASD_FAIL;                     /* XXX why do this? */
  return rc;
}

void
nasd_cheops_dce_null(
  nasd_cheops_handle_t   handle,
  nasd_res_t            *res,
  error_status_t        *op_status)
{
  nasd_cheops_handle_dce_t *rpch;
  nasd_res_otw_t res_otw;

  rpch = (nasd_cheops_handle_dce_t *)handle->rpc_specific_handle;
  TRY {
    nasd_cheops_null_cm(rpch->h, res_otw, op_status);
    nasd_res_t_unmarshall(res_otw, res);
  } CATCH_ALL {
    res->nasd_status = NASD_RPC_TRAP;
    exc_get_status(THIS_CATCH, (int *)op_status);
  } ENDTRY
}

void
nasd_cheops_dce_bs_lookup(
  nasd_cheops_handle_t           handle,
  nasd_cheops_bs_lu_args_t  *args,
  nasd_cheops_bs_lu_res_t   *res,
  error_status_t                *op_status)
{
  nasd_cheops_bs_lu_args_otw_t args_otw;
  nasd_cheops_bs_lu_res_otw_t res_otw;
  nasd_cheops_handle_dce_t *rpch;

  rpch = (nasd_cheops_handle_dce_t *)handle->rpc_specific_handle;
  nasd_cheops_bs_lu_args_t_marshall(args, args_otw);
  TRY {
    nasd_cheops_bs_lookup_cm(rpch->h, args_otw, res_otw, op_status);
    nasd_cheops_bs_lu_res_t_unmarshall(res_otw, res);
  } CATCH_ALL {
    res->out_nasd_status = NASD_RPC_TRAP;
    exc_get_status(THIS_CATCH, (int *)op_status);
  } ENDTRY
}

void
nasd_cheops_dce_mgr_lookup(
  nasd_cheops_handle_t           handle,
  nasd_cheops_mgr_lu_args_t *args,
  nasd_cheops_mgr_lu_res_t  *res,
  error_status_t                *op_status)
{
  nasd_cheops_mgr_lu_args_otw_t args_otw;
  nasd_cheops_mgr_lu_res_otw_t res_otw;
  nasd_cheops_handle_dce_t *rpch;

  rpch = (nasd_cheops_handle_dce_t *)handle->rpc_specific_handle;
  nasd_cheops_mgr_lu_args_t_marshall(args, args_otw);
  TRY {
    nasd_cheops_mgr_lookup_cm(rpch->h, args_otw, res_otw, op_status);
    nasd_cheops_mgr_lu_res_t_unmarshall(res_otw, res);
  } CATCH_ALL {
    res->out_nasd_status = NASD_RPC_TRAP;
    exc_get_status(THIS_CATCH, (int *)op_status);
  } ENDTRY
}

void
nasd_cheops_dce_dr_lookup(
  nasd_cheops_handle_t           handle,
  nasd_cheops_dr_lu_args_t  *args,
  nasd_cheops_dr_lu_res_t   *res,
  error_status_t                *op_status)
{
  nasd_cheops_dr_lu_args_otw_t args_otw;
  nasd_cheops_dr_lu_res_otw_t res_otw;
  nasd_cheops_handle_dce_t *rpch;

  rpch = (nasd_cheops_handle_dce_t *)handle->rpc_specific_handle;
  nasd_cheops_dr_lu_args_t_marshall(args, args_otw);
  TRY {
    nasd_cheops_dr_lookup_cm(rpch->h, args_otw, res_otw, op_status);
    nasd_cheops_dr_lu_res_t_unmarshall(res_otw, res);
  } CATCH_ALL {
    res->out_nasd_status = NASD_RPC_TRAP;
    exc_get_status(THIS_CATCH, (int *)op_status);
  } ENDTRY
}

void
nasd_cheops_dce_bs_refresh(
  nasd_cheops_handle_t           handle,
  nasd_cheops_bs_re_args_t *args,
  nasd_cheops_bs_re_res_t  *res,
  error_status_t                *op_status)
{
  nasd_cheops_bs_re_args_otw_t args_otw;
  nasd_cheops_bs_re_res_otw_t res_otw;
  nasd_cheops_handle_dce_t *rpch;

  rpch = (nasd_cheops_handle_dce_t *)handle->rpc_specific_handle;
  nasd_cheops_bs_re_args_t_marshall(args, args_otw);
  TRY {
    nasd_cheops_bs_refresh_cm(rpch->h, args_otw, res_otw, op_status);
    nasd_cheops_bs_re_res_t_unmarshall(res_otw, res);
  } CATCH_ALL {
    res->out_nasd_status = NASD_RPC_TRAP;
    exc_get_status(THIS_CATCH, (int *)op_status);
  } ENDTRY
}

void
nasd_cheops_dce_bs_qos_create(
  nasd_cheops_handle_t              handle,
  nasd_cheops_bs_qc_args_t *args,
  nasd_cheops_bs_qc_res_t  *res,
  error_status_t                   *op_status)
{
  nasd_cheops_bs_qc_args_otw_t args_otw;
  nasd_cheops_bs_qc_res_otw_t res_otw;
  nasd_cheops_handle_dce_t *rpch;

  rpch = (nasd_cheops_handle_dce_t *)handle->rpc_specific_handle;
  nasd_cheops_bs_qc_args_t_marshall(args, args_otw);
  TRY {
    nasd_cheops_bs_qos_create_cm(rpch->h, args_otw, res_otw, op_status);
    nasd_cheops_bs_qc_res_t_unmarshall(res_otw, res);
  } CATCH_ALL {
    res->out_nasd_status = NASD_RPC_TRAP;
    exc_get_status(THIS_CATCH, (int *)op_status);
  } ENDTRY
}

void
nasd_cheops_dce_bs_create(
  nasd_cheops_handle_t           handle,
  nasd_cheops_bs_cr_args_t  *args,
  nasd_cheops_bs_cr_res_t   *res,
  error_status_t                *op_status)
{
  nasd_cheops_bs_cr_args_otw_t args_otw;
  nasd_cheops_bs_cr_res_otw_t res_otw;
  nasd_cheops_handle_dce_t *rpch;

  rpch = (nasd_cheops_handle_dce_t *)handle->rpc_specific_handle;
  nasd_cheops_bs_cr_args_t_marshall(args, args_otw);
  TRY {
    nasd_cheops_bs_create_cm(rpch->h, args_otw, res_otw, op_status);
    nasd_cheops_bs_cr_res_t_unmarshall(res_otw, res);
  } CATCH_ALL {
    res->out_nasd_status = NASD_RPC_TRAP;
    exc_get_status(THIS_CATCH, (int *)op_status);
  } ENDTRY
}

void
nasd_cheops_dce_bs_remove(
  nasd_cheops_handle_t           handle,
  nasd_cheops_bs_rm_args_t  *args,
  nasd_cheops_bs_rm_res_t   *res,
  error_status_t                *op_status)
{
  nasd_cheops_bs_rm_args_otw_t args_otw;
  nasd_cheops_bs_rm_res_otw_t res_otw;
  nasd_cheops_handle_dce_t *rpch;

  rpch = (nasd_cheops_handle_dce_t *)handle->rpc_specific_handle;
  nasd_cheops_bs_rm_args_t_marshall(args, args_otw);
  TRY {
    nasd_cheops_bs_remove_cm(rpch->h, args_otw, res_otw, op_status);
    nasd_cheops_bs_rm_res_t_unmarshall(res_otw, res);
  } CATCH_ALL {
    res->out_nasd_status = NASD_RPC_TRAP;
    exc_get_status(THIS_CATCH, (int *)op_status);
  } ENDTRY
}

void
nasd_cheops_dce_bs_getattr(
  nasd_cheops_handle_t           handle,
  nasd_cheops_bs_ga_args_t *args,
  nads_cheops_bs_ga_res_t  *res,
  error_status_t                *op_status)
{
  nasd_cheops_bs_ga_args_otw_t args_otw;
  nads_cheops_bs_ga_res_otw_t res_otw;
  nasd_cheops_handle_dce_t *rpch;

  rpch = (nasd_cheops_handle_dce_t *)handle->rpc_specific_handle;
  nasd_cheops_bs_ga_args_t_marshall(args, args_otw);
  TRY {
    nasd_cheops_bs_getattr_cm(rpch->h, args_otw, res_otw, op_status);
    nads_cheops_bs_ga_res_t_unmarshall(res_otw, res);
  } CATCH_ALL {
    res->out_nasd_status = NASD_RPC_TRAP;
    exc_get_status(THIS_CATCH, (int *)op_status);
  } ENDTRY
}

void
nasd_cheops_dce_bs_setattr(
  nasd_cheops_handle_t           handle,
  nasd_cheops_bs_sa_args_t *args,
  nads_cheops_bs_sa_res_t  *res,
  error_status_t                *op_status)
{
  nasd_cheops_bs_sa_args_otw_t args_otw;
  nads_cheops_bs_sa_res_otw_t res_otw;
  nasd_cheops_handle_dce_t *rpch;

  rpch = (nasd_cheops_handle_dce_t *)handle->rpc_specific_handle;
  nasd_cheops_bs_sa_args_t_marshall(args, args_otw);
  TRY {
    nasd_cheops_bs_setattr_cm(rpch->h, args_otw, res_otw, op_status);
    nads_cheops_bs_sa_res_t_unmarshall(res_otw, res);
  } CATCH_ALL {
    res->out_nasd_status = NASD_RPC_TRAP;
    exc_get_status(THIS_CATCH, (int *)op_status);
  } ENDTRY
}

nasd_cheops_client_rpcmod_tab_t nasd_cheops_client_dce_udp_mod = {
  NULL,
  NASD_RPCMOD_INIT_FAIL,

  nasd_cheops_dce_bind,
  nasd_cheops_dce_unbind,

  nasd_cheops_dce_null,
  nasd_cheops_dce_bs_lookup,
  nasd_cheops_dce_mgr_lookup,
  nasd_cheops_dce_dr_lookup,
  nasd_cheops_dce_bs_refresh,
  nasd_cheops_dce_bs_qos_create,
  nasd_cheops_dce_bs_create,
  nasd_cheops_dce_bs_remove,
  nasd_cheops_dce_bs_getattr,
  nasd_cheops_dce_bs_setattr,

  NASD_BIND_DCE_DIRECT_UDP,
  "DCE-UDP",
  sizeof(nasd_cheops_handle_dce_t),

  NULL
};

nasd_cheops_client_rpcmod_tab_t nasd_cheops_client_dce_tcp_mod = {
  NULL,
  NASD_RPCMOD_INIT_FAIL,

  nasd_cheops_dce_bind,
  nasd_cheops_dce_unbind,

  nasd_cheops_dce_null,
  nasd_cheops_dce_bs_lookup,
  nasd_cheops_dce_mgr_lookup,
  nasd_cheops_dce_dr_lookup,
  nasd_cheops_dce_bs_refresh,
  nasd_cheops_dce_bs_qos_create,
  nasd_cheops_dce_bs_create,
  nasd_cheops_dce_bs_remove,
  nasd_cheops_dce_bs_getattr,
  nasd_cheops_dce_bs_setattr,

  NASD_BIND_DCE_DIRECT_UDP,
  "DCE-TCP",
  sizeof(nasd_cheops_handle_dce_t),

  NULL
};

void
nasd_cheops_client_dce_register(int counter_lock_held)
{
  nasd_cheops_client_mod_register(&nasd_cheops_client_dce_udp_mod,
                                  counter_lock_held);
  nasd_cheops_client_mod_register(&nasd_cheops_client_dce_tcp_mod,
                                  counter_lock_held);
}

#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
