 /*-
 * Copyright (c) 2015 Taylor R. Campbell
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	PICOPBC_SYNTAX_H
#define	PICOPBC_SYNTAX_H

#include <stdio.h>

#include "ast.h"
#include "attribute.h"

enum comment_style {
	CMTSTY_CPP,
	CMTSTY_SH,
};

struct syntaxopts {
	enum comment_style	so_cmtsty;
};

#define	DEFAULT_SYNTAXOPTS	{ .so_cmtsty = CMTSTY_CPP }

/* XXX Stupid &@!#^ parser/lexer generators don't declare these.  */
int		yylex(void);
void		yyerror(const char *);

void		yyerrorf(const char *, ...) attr_printflike(1, 2);

void		picopbc_scan(FILE *, const char *, const struct syntaxopts *);
void		picopbc_parse(FILE *, const char *, const struct syntaxopts *);
void		picopbc_parsed(int, struct ast_proto *);
int		picopbc_compile(FILE *, struct string, FILE *, struct string,
		    struct ast_proto *);
void		picopbc_dump(FILE *, struct ast_proto *);

void		picopbc_scan_init(FILE *, const char *,
		    const struct syntaxopts *);

#endif	/* PICOPBC_SYNTAX_H */
