/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AllPermission;
import java.security.KeyStore;
import java.security.Policy;
import java.security.Security;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.jnlp.ServiceManager;
import javax.naming.ConfigurationException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.swing.UIManager;
import javax.swing.text.html.parser.ParserDelegator;
import net.sourceforge.jnlp.DefaultLaunchHandler;
import net.sourceforge.jnlp.GuiLaunchHandler;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.browser.BrowserAwareProxySelector;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.DefaultDownloadIndicator;
import net.sourceforge.jnlp.cache.DownloadIndicator;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.CachedJarFileCallback;
import net.sourceforge.jnlp.runtime.JNLPPolicy;
import net.sourceforge.jnlp.runtime.JNLPSecurityManager;
import net.sourceforge.jnlp.security.JNLPAuthenticator;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.security.SecurityDialogMessageHandler;
import net.sourceforge.jnlp.services.XServiceManagerStub;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.JavaConsole;
import net.sourceforge.jnlp.util.logging.LogConfig;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.net.www.protocol.jar.URLJarFile;

public class JNLPRuntime {
    private static ResourceBundle resources;
    private static JNLPSecurityManager security;
    private static JNLPPolicy policy;
    private static SecurityDialogMessageHandler securityDialogMessageHandler;
    private static LaunchHandler handler;
    private static DownloadIndicator indicator;
    private static UpdatePolicy updatePolicy;
    private static boolean initialized;
    private static boolean headless;
    private static boolean verify;
    private static boolean securityEnabled;
    private static boolean debug;
    private static Boolean pluginDebug;
    public static Object initMutex;
    private static boolean isWebstartApplication;
    private static boolean forksAllowed;
    private static boolean trustAll;
    private static boolean ignoreHeaders;
    private static List<String> initialArguments;
    private static FileLock fileLock;

    public static boolean isInitialized() {
        return initialized;
    }

    public static void initialize(boolean bl) throws IllegalStateException {
        Object object;
        JNLPRuntime.checkInitialized();
        if (JavaConsole.canShowOnStartup(bl)) {
            JavaConsole.getConsole().showConsoleLater();
        }
        if (bl && JNLPRuntime.getConfiguration().getLoadingException() != null) {
            OutputController.getLogger().log(OutputController.Level.WARNING_ALL, JNLPRuntime.getMessage("RConfigurationError") + ": " + JNLPRuntime.getConfiguration().getLoadingException().getMessage());
        }
        KeyStores.setConfiguration(JNLPRuntime.getConfiguration());
        isWebstartApplication = bl;
        System.setProperty("javawebstart.version", "javaws-" + System.getProperty("java.version"));
        if (!headless) {
            JNLPRuntime.checkHeadless();
        }
        if (!headless && indicator == null) {
            indicator = new DefaultDownloadIndicator();
        }
        if (handler == null) {
            handler = headless ? new DefaultLaunchHandler(OutputController.getLogger()) : new GuiLaunchHandler(OutputController.getLogger());
        }
        ServiceManager.setServiceManagerStub(new XServiceManagerStub());
        policy = new JNLPPolicy();
        security = new JNLPSecurityManager();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
        }
        JNLPRuntime.doMainAppContextHacks();
        if (securityEnabled) {
            Policy.setPolicy(policy);
            System.setSecurityManager(security);
        }
        securityDialogMessageHandler = JNLPRuntime.startSecurityThreads();
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            KeyStore keyStore = KeyStores.getKeyStore(KeyStores.Level.USER, KeyStores.Type.CLIENT_CERTS);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, KeyStores.getPassword());
            TrustManager[] trustManagerArray = new TrustManager[]{JNLPRuntime.getSSLSocketTrustManager()};
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, null);
            object = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)object);
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Unable to set SSLSocketfactory (may _prevent_ access to sites that should be trusted)! Continuing anyway...");
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
        }
        Authenticator.setDefault(new JNLPAuthenticator());
        object = new BrowserAwareProxySelector(JNLPRuntime.getConfiguration());
        ((BrowserAwareProxySelector)object).initialize();
        ProxySelector.setDefault((ProxySelector)object);
        Security.setProperty("package.access", Security.getProperty("package.access") + ",net.sourceforge.jnlp");
        URLJarFile.setCallBack(CachedJarFileCallback.getInstance());
        initialized = true;
    }

    private static TrustManager getSSLSocketTrustManager() throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        try {
            Class<?> clazz;
            Constructor<?> constructor = null;
            if (System.getProperty("java.version").startsWith("1.6")) {
                try {
                    clazz = Class.forName("net.sourceforge.jnlp.security.VariableX509TrustManagerJDK6");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Unable to find class net.sourceforge.jnlp.security.VariableX509TrustManagerJDK6");
                    return null;
                }
            }
            try {
                clazz = Class.forName("net.sourceforge.jnlp.security.VariableX509TrustManagerJDK7");
            }
            catch (ClassNotFoundException classNotFoundException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Unable to find class net.sourceforge.jnlp.security.VariableX509TrustManagerJDK7");
                return null;
            }
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            constructor = constructorArray[0];
            for (Constructor<?> constructor2 : constructorArray) {
                if (constructor.getGenericParameterTypes().length != 0) continue;
                constructor = constructor2;
                break;
            }
            return (TrustManager)constructor.newInstance(new Object[0]);
        }
        catch (RuntimeException runtimeException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Unable to load JDK-specific TrustManager. Was this version of IcedTea-Web compiled with JDK 6 or 7?");
            OutputController.getLogger().log(runtimeException);
            throw runtimeException;
        }
    }

    private static SecurityDialogMessageHandler startSecurityThreads() {
        ThreadGroup threadGroup = new ThreadGroup("NetxSecurityThreadGroup");
        SecurityDialogMessageHandler securityDialogMessageHandler = new SecurityDialogMessageHandler();
        Thread thread = new Thread(threadGroup, securityDialogMessageHandler, "NetxSecurityThread");
        thread.setDaemon(true);
        thread.start();
        return securityDialogMessageHandler;
    }

    private static void doMainAppContextHacks() {
        new ParserDelegator();
    }

    public static DeploymentConfiguration getConfiguration() {
        return DeploymentConfigurationHolder.INSTANCE;
    }

    public static boolean isWebstartApplication() {
        return isWebstartApplication;
    }

    public static boolean isHeadless() {
        return headless;
    }

    public static boolean isVerifying() {
        return verify;
    }

    public static void setHeadless(boolean bl) {
        JNLPRuntime.checkInitialized();
        headless = bl;
    }

    public static void setVerify(boolean bl) {
        JNLPRuntime.checkInitialized();
        verify = bl;
    }

    public static boolean isSecurityEnabled() {
        return securityEnabled;
    }

    public static void setSecurityEnabled(boolean bl) {
        JNLPRuntime.checkInitialized();
        securityEnabled = bl;
    }

    public static SecurityDialogMessageHandler getSecurityDialogHandler() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        return securityDialogMessageHandler;
    }

    public static void setExitClass(Class<?> clazz) {
        JNLPRuntime.checkExitClass();
        security.setExitClass(clazz);
    }

    public static void disableExit() {
        security.disableExit();
    }

    public static ApplicationInstance getApplication() {
        return security.getApplication();
    }

    public static boolean isDebug() {
        return JNLPRuntime.isSetDebug() || JNLPRuntime.isPluginDebug() || LogConfig.getLogConfig().isEnableLogging();
    }

    public static boolean isSetDebug() {
        return debug;
    }

    public static void setDebug(boolean bl) {
        JNLPRuntime.checkExitClass();
        debug = bl;
    }

    public static void setDefaultUpdatePolicy(UpdatePolicy updatePolicy) {
        JNLPRuntime.checkExitClass();
        JNLPRuntime.updatePolicy = updatePolicy;
    }

    public static UpdatePolicy getDefaultUpdatePolicy() {
        return updatePolicy;
    }

    public static void setDefaultLaunchHandler(LaunchHandler launchHandler) {
        JNLPRuntime.checkExitClass();
        handler = launchHandler;
    }

    public static LaunchHandler getDefaultLaunchHandler() {
        return handler;
    }

    public static void setDefaultDownloadIndicator(DownloadIndicator downloadIndicator) {
        JNLPRuntime.checkExitClass();
        indicator = downloadIndicator;
    }

    public static DownloadIndicator getDefaultDownloadIndicator() {
        return indicator;
    }

    public static String getMessage(String string) {
        try {
            String string2 = resources.getString(string);
            if (string2.length() == 0) {
                return null;
            }
            return string2;
        }
        catch (Exception exception) {
            if (!string.equals("RNoResource")) {
                return JNLPRuntime.getMessage("RNoResource", string);
            }
            return "Missing resource: " + string;
        }
    }

    public static String getMessage(String string, Object ... objectArray) {
        return MessageFormat.format(JNLPRuntime.getMessage(string), objectArray);
    }

    public static boolean getForksAllowed() {
        return forksAllowed;
    }

    public static void setForksAllowed(boolean bl) {
        JNLPRuntime.checkInitialized();
        forksAllowed = bl;
    }

    private static void checkInitialized() {
        if (initialized) {
            throw new IllegalStateException("JNLPRuntime already initialized.");
        }
    }

    private static void checkExitClass() {
        if (securityEnabled && initialized && !security.isExitClass()) {
            throw new IllegalStateException("Caller is not the exit class");
        }
    }

    private static void checkHeadless() {
        try {
            if ("true".equalsIgnoreCase(System.getProperty("java.awt.headless"))) {
                headless = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static void loadResources() {
        try {
            resources = ResourceBundle.getBundle("net.sourceforge.jnlp.resources.Messages");
        }
        catch (Exception exception) {
            throw new IllegalStateException("Missing resource bundle in netx.jar:net/sourceforge/jnlp/resource/Messages.properties");
        }
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith("Windows");
    }

    public static boolean isUnix() {
        String string = System.getProperty("file.separator");
        return string != null && string.equals("/");
    }

    public static void setInitialArgments(List<String> list) {
        JNLPRuntime.checkInitialized();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        initialArguments = list;
    }

    public static List<String> getInitialArguments() {
        return initialArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void markNetxRunning() {
        if (fileLock != null) {
            return;
        }
        try {
            FileChannel fileChannel;
            Closeable closeable;
            String string = "This file is used to check if netx is running";
            File file = new File(JNLPRuntime.getConfiguration().getProperty("deployment.user.runningfile"));
            if (!file.exists()) {
                FileUtils.createParentDir(file);
                FileUtils.createRestrictedFile(file, true);
                closeable = new FileOutputStream(file);
                try {
                    ((FileOutputStream)closeable).write(string.getBytes());
                }
                finally {
                    ((FileOutputStream)closeable).close();
                }
            }
            if (!(fileLock = (fileChannel = ((FileInputStream)(closeable = new FileInputStream(file))).getChannel()).lock(0L, 1L, true)).isShared()) {
                FileLock fileLock = null;
                for (long i = 1L; fileLock == null && i < 0x7FFFFFFFFFFFFFFEL; ++i) {
                    fileLock = fileChannel.tryLock(i, 1L, false);
                }
                JNLPRuntime.fileLock.release();
                JNLPRuntime.fileLock = fileLock;
            }
            if (fileLock != null && fileLock.isShared()) {
                OutputController.getLogger().log("Acquired shared lock on " + file.toString() + " to indicate javaws is running");
            }
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
        }
        Runtime.getRuntime().addShutdownHook(new Thread("JNLPRuntimeShutdownHookThread"){

            @Override
            public void run() {
                JNLPRuntime.markNetxStopped();
                CacheUtil.cleanCache();
            }
        });
    }

    private static void markNetxStopped() {
        if (fileLock == null) {
            return;
        }
        try {
            fileLock.release();
            fileLock.channel().close();
            fileLock = null;
            OutputController.getLogger().log("Release shared lock on " + JNLPRuntime.getConfiguration().getProperty("deployment.user.runningfile"));
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(iOException);
        }
    }

    static void setTrustAll(boolean bl) {
        trustAll = bl;
    }

    public static boolean isTrustAll() {
        return trustAll;
    }

    public static boolean isIgnoreHeaders() {
        return ignoreHeaders;
    }

    public static void setIgnoreHeaders(boolean bl) {
        ignoreHeaders = bl;
    }

    private static boolean isPluginDebug() {
        if (pluginDebug == null) {
            try {
                pluginDebug = System.getenv().containsKey("ICEDTEAPLUGIN_DEBUG");
            }
            catch (Exception exception) {
                pluginDebug = false;
                OutputController.getLogger().log(exception);
            }
        }
        return pluginDebug;
    }

    public static void exit(int n) {
        OutputController.getLogger().close();
        System.exit(n);
    }

    static {
        JNLPRuntime.loadResources();
        handler = null;
        indicator = null;
        updatePolicy = UpdatePolicy.ALWAYS;
        initialized = false;
        headless = false;
        verify = true;
        securityEnabled = true;
        debug = false;
        pluginDebug = null;
        initMutex = new Object();
        forksAllowed = true;
        trustAll = false;
        ignoreHeaders = false;
    }

    private static class DeploymentConfigurationHolder {
        private static final DeploymentConfiguration INSTANCE = DeploymentConfigurationHolder.initConfiguration();

        private DeploymentConfigurationHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static DeploymentConfiguration initConfiguration() {
            DeploymentConfiguration deploymentConfiguration = new DeploymentConfiguration();
            try {
                deploymentConfiguration.load();
                deploymentConfiguration.copyTo(System.getProperties());
            }
            catch (ConfigurationException configurationException) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, JNLPRuntime.getMessage("RConfigurationError"));
                deploymentConfiguration.setLoadingException(configurationException);
            }
            finally {
                OutputController.getLogger().startConsumer();
            }
            return deploymentConfiguration;
        }
    }
}

