/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.config;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import net.sourceforge.jnlp.config.ValueValidator;
import net.sourceforge.jnlp.runtime.Translator;

public class BasicValueValidators {
    public static ValueValidator getBooleanValidator() {
        return new BooleanValidator();
    }

    public static ValueValidator getFilePathValidator() {
        return new FilePathValidator();
    }

    public static ValueValidator getRangedIntegerValidator(int n, int n2) {
        return new RangedIntegerValidator(n, n2);
    }

    public static ValueValidator getStringValidator(String[] stringArray) {
        return new StringValueValidator(stringArray);
    }

    public static ValueValidator getUrlValidator() {
        return new UrlValidator();
    }

    private static class UrlValidator
    implements ValueValidator {
        private UrlValidator() {
        }

        @Override
        public void validate(Object object) throws IllegalArgumentException {
            if (object == null) {
                return;
            }
            try {
                new URL((String)object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public String getPossibleValues() {
            return Translator.R("VVPossibleUrlValues");
        }
    }

    private static class StringValueValidator
    implements ValueValidator {
        String[] options = null;

        public StringValueValidator(String[] stringArray) {
            this.options = stringArray;
        }

        @Override
        public void validate(Object object) throws IllegalArgumentException {
            Object object2 = object;
            if (!(object2 instanceof String)) {
                throw new IllegalArgumentException("Must be a string");
            }
            String string = (String)object2;
            boolean bl = false;
            for (String string2 : this.options) {
                if (!string2.equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public String getPossibleValues() {
            return Arrays.toString(this.options);
        }
    }

    private static class RangedIntegerValidator
    implements ValueValidator {
        private int low = 0;
        private int high = 0;

        public RangedIntegerValidator(int n, int n2) {
            this.low = n;
            this.high = n2;
        }

        @Override
        public void validate(Object object) throws IllegalArgumentException {
            long l;
            block6: {
                Object object2 = object;
                l = 0L;
                try {
                    if (object2 instanceof String) {
                        l = Long.valueOf((String)object2);
                        break block6;
                    }
                    if (object2 instanceof Integer) {
                        l = ((Integer)object2).intValue();
                        break block6;
                    }
                    if (object2 instanceof Long) {
                        l = (Long)object2;
                        break block6;
                    }
                    throw new IllegalArgumentException("Must be an integer");
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Must be an integer");
                }
            }
            if (l < (long)this.low || l > (long)this.high) {
                throw new IllegalArgumentException("Not in range from " + this.low + " to " + this.high);
            }
        }

        @Override
        public String getPossibleValues() {
            return Translator.R("VVPossibleRangedIntegerValues", this.low, this.high);
        }
    }

    static class FilePathValidator
    implements ValueValidator {
        FilePathValidator() {
        }

        @Override
        public void validate(Object object) throws IllegalArgumentException {
            if (object == null) {
                return;
            }
            Object object2 = object;
            if (!(object2 instanceof String)) {
                throw new IllegalArgumentException("Value should be string!");
            }
            String string = (String)object2;
            boolean bl = new File(string).isAbsolute();
            if (!bl) {
                throw new IllegalArgumentException("File must be absolute");
            }
        }

        @Override
        public String getPossibleValues() {
            return Translator.R("VVPossibleFileValues");
        }
    }

    private static class BooleanValidator
    implements ValueValidator {
        private BooleanValidator() {
        }

        @Override
        public void validate(Object object) throws IllegalArgumentException {
            String string;
            Object object2 = object;
            if (object2 instanceof String && ((string = ((String)object2).toLowerCase(Locale.ENGLISH)).equals(Boolean.TRUE.toString()) || string.equals(Boolean.FALSE.toString()))) {
                object2 = Boolean.valueOf(string);
            }
            if (!(object2 instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public String getPossibleValues() {
            return Translator.R("VVPossibleBooleanValues", Boolean.TRUE.toString(), Boolean.FALSE.toString());
        }
    }
}

