/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import com.sun.jndi.toolkit.url.UrlUtil;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.JNLPProxySelector;
import net.sourceforge.jnlp.util.TimedHashMap;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginDebug;

public class PluginProxySelector
extends JNLPProxySelector {
    private TimedHashMap<String, Proxy> proxyCache = new TimedHashMap();

    public PluginProxySelector(DeploymentConfiguration deploymentConfiguration) {
        super(deploymentConfiguration);
    }

    @Override
    protected List<Proxy> getFromBrowser(URI uRI) {
        String string;
        ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
        Proxy proxy = this.checkCache(uRI);
        if (proxy != null) {
            arrayList.add(proxy);
            return arrayList;
        }
        try {
            string = PluginProxySelector.convertUriSchemeForProxyQuery(uRI);
        }
        catch (Exception exception) {
            PluginDebug.debug("Cannot construct URL from ", uRI.toString(), " ... falling back to DIRECT proxy");
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
            arrayList.add(Proxy.NO_PROXY);
            return arrayList;
        }
        Proxy proxy2 = Proxy.NO_PROXY;
        Object object = this.getProxyFromRemoteCallToBrowser(string);
        try {
            if (object != null) {
                PluginDebug.debug("Proxy URI = ", object);
                URI uRI2 = (URI)object;
                if (uRI.getScheme().startsWith("http") || uRI.getScheme().equals("ftp") || uRI2.getScheme().startsWith("socks")) {
                    Proxy.Type type = uRI2.getScheme().equals("http") ? Proxy.Type.HTTP : Proxy.Type.SOCKS;
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(uRI2.getHost(), uRI2.getPort());
                    proxy2 = new Proxy(type, inetSocketAddress);
                    String string2 = this.computeKey(uRI);
                    this.proxyCache.put(string2, proxy2);
                } else {
                    PluginDebug.debug("Proxy ", uRI2, " cannot be used for ", uRI, ". Falling back to DIRECT");
                }
            }
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
        }
        arrayList.add(proxy2);
        PluginDebug.debug("Proxy for ", uRI.toString(), " is ", proxy2);
        return arrayList;
    }

    protected Object getProxyFromRemoteCallToBrowser(String string) {
        return PluginAppletViewer.requestPluginProxyInfo(string);
    }

    private Proxy checkCache(URI uRI) {
        String string = this.computeKey(uRI);
        if (this.proxyCache.get(string) != null) {
            return this.proxyCache.get(string);
        }
        return null;
    }

    private String computeKey(URI uRI) {
        return uRI.getScheme() + "://" + uRI.getHost();
    }

    public static String convertUriSchemeForProxyQuery(URI uRI) throws URISyntaxException, UnsupportedEncodingException {
        String string = uRI.getScheme();
        if (!string.startsWith("http") && !string.equals("ftp")) {
            string = "http";
        }
        URI uRI2 = new URI(string, uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath(), uRI.getQuery(), uRI.getFragment());
        return UrlUtil.encode(uRI2.toString(), "UTF-8");
    }
}

