/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

public final class FileUtils {
    private static final char[] INVALID_CHARS = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
    private static final char SANITIZED_CHAR = '_';

    public static String sanitizePath(String string) {
        for (int i = 0; i < INVALID_CHARS.length; ++i) {
            if (INVALID_CHARS[i] == File.separatorChar || -1 == string.indexOf(INVALID_CHARS[i])) continue;
            string = string.replace(INVALID_CHARS[i], '_');
        }
        return string;
    }

    public static String sanitizeFileName(String string) {
        for (int i = 0; i < INVALID_CHARS.length; ++i) {
            if (-1 == string.indexOf(INVALID_CHARS[i])) continue;
            string = string.replace(INVALID_CHARS[i], '_');
        }
        return string;
    }

    public static void createRestrictedDirectory(File file) throws IOException {
        FileUtils.createRestrictedFile(file, true, true);
    }

    public static void createRestrictedFile(File file, boolean bl) throws IOException {
        FileUtils.createRestrictedFile(file, false, bl);
    }

    public static void createParentDir(File file, String string) throws IOException {
        File file2 = file.getParentFile();
        if (!file2.isDirectory() && !file2.mkdirs()) {
            throw new IOException(Translator.R("RCantCreateDir", string == null ? file2 : string));
        }
    }

    public static void createParentDir(File file) throws IOException {
        FileUtils.createParentDir(file, null);
    }

    public static void deleteWithErrMesg(File file, String string) {
        if (file.exists() && !file.delete()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RCantDeleteFile", string == null ? file : string));
        }
    }

    public static void deleteWithErrMesg(File file) {
        FileUtils.deleteWithErrMesg(file, null);
    }

    private static void createRestrictedFile(File file, boolean bl, boolean bl2) throws IOException {
        File file2 = null;
        file2 = new File(file.getCanonicalPath() + ".temp");
        if (bl) {
            if (!file2.mkdir()) {
                throw new IOException(Translator.R("RCantCreateDir", file2));
            }
        } else if (!file2.createNewFile()) {
            throw new IOException(Translator.R("RCantCreateFile", file2));
        }
        if (JNLPRuntime.isWindows()) {
            if (!file2.setExecutable(false, false)) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RRemoveXPermFailed", file2));
            }
            if (!file2.setReadable(false, false)) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RRemoveRPermFailed", file2));
            }
            if (!file2.setWritable(false, false)) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RRemoveWPermFailed", file2));
            }
            if (!file2.setReadable(true, true)) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RGetRPermFailed", file2));
            }
            if (bl2 && !file2.setWritable(true, true)) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RGetWPermFailed", file2));
            }
            if (bl && !file2.setExecutable(true, true)) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RGetXPermFailed", file2));
            }
            if (!file2.renameTo(file)) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RCantRename", file2, file));
            }
        } else {
            if (!file2.setExecutable(false, false)) {
                throw new IOException(Translator.R("RRemoveXPermFailed", file2));
            }
            if (!file2.setReadable(false, false)) {
                throw new IOException(Translator.R("RRemoveRPermFailed", file2));
            }
            if (!file2.setWritable(false, false)) {
                throw new IOException(Translator.R("RRemoveWPermFailed", file2));
            }
            if (!file2.setReadable(true, true)) {
                throw new IOException(Translator.R("RGetRPermFailed", file2));
            }
            if (bl2 && !file2.setWritable(true, true)) {
                throw new IOException(Translator.R("RGetWPermFailed", file2));
            }
            if (bl && !file2.setExecutable(true, true)) {
                throw new IOException(Translator.R("RGetXPermFailed", file2));
            }
            if (!file2.renameTo(file)) {
                throw new IOException(Translator.R("RCantRename", file2, file));
            }
        }
    }

    public static String displayablePath(String string) {
        return FileUtils.displayablePath(string, 40);
    }

    public static String displayablePath(String string, int n) {
        if (string == null || string.length() <= n) {
            return string;
        }
        int n2 = "...".length();
        if (n < n2 + 4 + 4) {
            return string.substring(string.length() - n);
        }
        int n3 = (n - n2) / 2;
        String string2 = string.substring(0, n3);
        String string3 = string.substring(string.length() - n3);
        return string2 + "..." + string3;
    }

    public static void recursiveDelete(File file, File file2) throws IOException {
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Deleting: " + file);
        if (!file.getCanonicalPath().startsWith(file2.getCanonicalPath())) {
            throw new IOException("Trying to delete a file outside Netx's basedir: " + file.getCanonicalPath());
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                FileUtils.recursiveDelete(fileArray[i], file2);
            }
        }
        if (!file.delete()) {
            throw new IOException("Unable to delete file: " + file);
        }
    }

    public static FileLock getFileLock(String string, boolean bl, boolean bl2) throws FileNotFoundException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        FileChannel fileChannel = randomAccessFile.getChannel();
        FileLock fileLock = null;
        try {
            if (!bl) {
                fileLock = bl2 ? fileChannel.lock(0L, Long.MAX_VALUE, false) : fileChannel.tryLock(0L, Long.MAX_VALUE, false);
            } else {
                fileLock = fileChannel.lock(0L, 1L, true);
                if (!fileLock.isShared()) {
                    FileLock fileLock2 = null;
                    for (long i = 1L; fileLock2 == null && i < 0x7FFFFFFFFFFFFFFEL; ++i) {
                        fileLock2 = fileChannel.tryLock(i, 1L, false);
                    }
                    fileLock.release();
                    fileLock = fileLock2;
                }
            }
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
        }
        return fileLock;
    }

    public static void saveFile(String string, File file) throws IOException {
        FileUtils.saveFile(string, file, "utf-8");
    }

    public static void saveFile(String string, File file, String string2) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2));
        bufferedWriter.write(string);
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentOfStream(InputStream inputStream, String string) throws IOException {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\n");
            }
            string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            inputStream.close();
        }
    }

    public static String getContentOfStream(InputStream inputStream) throws IOException {
        return FileUtils.getContentOfStream(inputStream, "UTF-8");
    }

    public static String loadFileAsString(File file) throws IOException {
        return FileUtils.getContentOfStream(new FileInputStream(file));
    }

    public static String loadFileAsString(File file, String string) throws IOException {
        return FileUtils.getContentOfStream(new FileInputStream(file), string);
    }
}

