/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.security.KeyStore;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.security.AppVerifier;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.CertificateUtils;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.tools.CertInformation;
import net.sourceforge.jnlp.util.JarFile;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.NetscapeCertTypeExtension;

public class JarCertVerifier
implements CertVerifier {
    private static final String META_INF = "META-INF/";
    private static final String SIG_PREFIX = "META-INF/SIG-";
    private static final long SIX_MONTHS = 15552000000L;
    private List<String> verifiedJars = new ArrayList<String>();
    private List<String> unverifiedJars = new ArrayList<String>();
    private Map<CertPath, CertInformation> certs = new HashMap<CertPath, CertInformation>();
    private CertPath currentlyUsed;
    private Map<String, Integer> jarSignableEntries = new HashMap<String, Integer>();
    private AppVerifier appVerifier;

    public JarCertVerifier(AppVerifier appVerifier) {
        this.appVerifier = appVerifier;
    }

    public boolean isTriviallySigned() {
        return JarCertVerifier.getTotalJarEntries(this.jarSignableEntries) <= 0 && this.certs.size() <= 0;
    }

    @Override
    public boolean getAlreadyTrustPublisher() {
        boolean bl = this.appVerifier.hasAlreadyTrustedPublisher(this.certs, this.jarSignableEntries);
        OutputController.getLogger().log("App already has trusted publisher: " + bl);
        return bl;
    }

    @Override
    public boolean getRootInCacerts() {
        boolean bl = this.appVerifier.hasRootInCacerts(this.certs, this.jarSignableEntries);
        OutputController.getLogger().log("App has trusted root CA: " + bl);
        return bl;
    }

    @Override
    public CertPath getCertPath(CertPath certPath) {
        return this.currentlyUsed;
    }

    @Override
    public boolean hasSigningIssues(CertPath certPath) {
        return this.certs.get(certPath).hasSigningIssues();
    }

    @Override
    public List<String> getDetails(CertPath certPath) {
        if (certPath != null) {
            this.currentlyUsed = certPath;
        }
        return this.certs.get(this.currentlyUsed).getDetailsAsStrings();
    }

    public List<CertPath> getCertsList() {
        return new ArrayList<CertPath>(this.certs.keySet());
    }

    public CertInformation getCertInformation(CertPath certPath) {
        return this.certs.get(certPath);
    }

    public boolean isFullySigned() {
        if (this.isTriviallySigned()) {
            return true;
        }
        boolean bl = this.appVerifier.isFullySigned(this.certs, this.jarSignableEntries);
        OutputController.getLogger().log("App already has trusted publisher: " + bl);
        return bl;
    }

    public static boolean isJarSigned(JARDesc jARDesc, AppVerifier appVerifier, ResourceTracker resourceTracker) throws Exception {
        JarCertVerifier jarCertVerifier = new JarCertVerifier(appVerifier);
        ArrayList<JARDesc> arrayList = new ArrayList<JARDesc>();
        arrayList.add(jARDesc);
        jarCertVerifier.add(arrayList, resourceTracker);
        return jarCertVerifier.allJarsSigned();
    }

    public void add(List<JARDesc> list, ResourceTracker resourceTracker) throws Exception {
        this.verifyJars(list, resourceTracker);
    }

    private void verifyJars(List<JARDesc> list, ResourceTracker resourceTracker) throws Exception {
        for (JARDesc object : list) {
            String string;
            File file = resourceTracker.getCacheFile(object.getLocation());
            if (file == null || this.verifiedJars.contains(string = file.getAbsolutePath()) || this.unverifiedJars.contains(string)) continue;
            VerifyResult verifyResult = this.verifyJar(string);
            if (verifyResult == VerifyResult.UNSIGNED) {
                this.unverifiedJars.add(string);
                continue;
            }
            if (verifyResult == VerifyResult.SIGNED_NOT_OK) {
                this.verifiedJars.add(string);
                continue;
            }
            if (verifyResult != VerifyResult.SIGNED_OK) continue;
            this.verifiedJars.add(string);
        }
        for (CertPath certPath : this.certs.keySet()) {
            this.checkTrustedCerts(certPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VerifyResult verifyJar(String string) throws Exception {
        try (JarFile jarFile = null;){
            Object object;
            jarFile = new JarFile(string, true);
            Vector<JarEntry> vector = new Vector<JarEntry>();
            byte[] byArray = new byte[8192];
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                vector.addElement((JarEntry)object);
                InputStream inputStream = jarFile.getInputStream((ZipEntry)object);
                try {
                    while (inputStream.read(byArray, 0, byArray.length) != -1) {
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            object = this.verifyJarEntryCerts(string, jarFile.getManifest() != null, vector);
            return object;
        }
    }

    /*
     * WARNING - void declaration
     */
    VerifyResult verifyJarEntryCerts(String string, boolean bl, Vector<JarEntry> vector) throws Exception {
        void var9_17;
        HashMap<CertPath, Integer> hashMap = new HashMap<CertPath, Integer>();
        int n = 0;
        long l = System.currentTimeMillis();
        if (bl) {
            for (JarEntry object2 : vector) {
                boolean bl2;
                Object object = object2.getName();
                CodeSigner[] codeSignerArray = object2.getCodeSigners();
                boolean bl3 = codeSignerArray != null;
                boolean bl4 = bl2 = !object2.isDirectory() && !JarCertVerifier.isMetaInfFile((String)object);
                if (bl2) {
                    ++n;
                }
                if (!bl2 || !bl3) continue;
                for (int i = 0; i < codeSignerArray.length; ++i) {
                    CertPath certPath = codeSignerArray[i].getSignerCertPath();
                    if (!hashMap.containsKey(certPath)) {
                        hashMap.put(certPath, 1);
                        continue;
                    }
                    hashMap.put(certPath, (Integer)hashMap.get(certPath) + 1);
                }
            }
        } else {
            ++n;
        }
        this.jarSignableEntries.put(string, n);
        boolean bl5 = false;
        for (Object object : hashMap.keySet()) {
            if ((Integer)hashMap.get(object) != n) continue;
            bl5 = true;
            boolean bl6 = this.certs.containsKey(object);
            if (!bl6) {
                this.certs.put((CertPath)object, new CertInformation());
            }
            CertInformation certInformation = this.certs.get(object);
            if (bl6) {
                certInformation.resetForReverification();
            }
            certInformation.setNumJarEntriesSigned(string, n);
            Certificate certificate = ((CertPath)object).getCertificates().get(0);
            if (!(certificate instanceof X509Certificate)) continue;
            this.checkCertUsage((CertPath)object, (X509Certificate)certificate, null);
            long l2 = ((X509Certificate)certificate).getNotBefore().getTime();
            long l3 = ((X509Certificate)certificate).getNotAfter().getTime();
            if (l < l2) {
                certInformation.setNotYetValidCert();
            }
            if (l3 < l) {
                certInformation.setHasExpiredCert();
                continue;
            }
            if (l3 >= l + 15552000000L) continue;
            certInformation.setHasExpiringCert();
        }
        Object var9_11 = null;
        if (n == 0) {
            VerifyResult verifyResult = VerifyResult.SIGNED_OK;
        } else if (bl5) {
            void var9_14;
            for (CertPath certPath : hashMap.keySet()) {
                if (!this.certs.containsKey(certPath) || this.hasSigningIssues(certPath)) continue;
                VerifyResult verifyResult = VerifyResult.SIGNED_OK;
                break;
            }
            if (var9_14 == null) {
                VerifyResult verifyResult = VerifyResult.SIGNED_NOT_OK;
            }
        } else {
            VerifyResult verifyResult = VerifyResult.UNSIGNED;
        }
        OutputController.getLogger().log("Jar found at " + string + "has been verified as " + var9_17);
        return var9_17;
    }

    private void checkTrustedCerts(CertPath certPath) throws Exception {
        CertInformation certInformation = this.certs.get(certPath);
        try {
            X509Certificate x509Certificate = (X509Certificate)this.getPublisher(certPath);
            KeyStore[] keyStoreArray = KeyStores.getCertKeyStores();
            if (CertificateUtils.inKeyStores(x509Certificate, keyStoreArray)) {
                certInformation.setAlreadyTrustPublisher();
            }
            KeyStore[] keyStoreArray2 = KeyStores.getCAKeyStores();
            for (Certificate certificate : certPath.getCertificates()) {
                if (!CertificateUtils.inKeyStores((X509Certificate)certificate, keyStoreArray2)) continue;
                certInformation.setRootInCacerts();
                return;
            }
        }
        catch (Exception exception) {
            OutputController.getLogger().log("WARNING: Unable to read through cert store files.");
            throw exception;
        }
        certInformation.setUntrusted();
    }

    public void setCurrentlyUsedCertPath(CertPath certPath) {
        this.currentlyUsed = certPath;
    }

    @Override
    public Certificate getPublisher(CertPath certPath) {
        if (certPath != null) {
            this.currentlyUsed = certPath;
        }
        if (this.currentlyUsed != null) {
            List<? extends Certificate> list = this.currentlyUsed.getCertificates();
            if (list.size() > 0) {
                return list.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public Certificate getRoot(CertPath certPath) {
        if (certPath != null) {
            this.currentlyUsed = certPath;
        }
        if (this.currentlyUsed != null) {
            List<? extends Certificate> list = this.currentlyUsed.getCertificates();
            if (list.size() > 0) {
                return list.get(list.size() - 1);
            }
            return null;
        }
        return null;
    }

    static boolean isMetaInfFile(String string) {
        String string2 = string.toUpperCase();
        return string2.startsWith(META_INF);
    }

    void checkCertUsage(CertPath certPath, X509Certificate x509Certificate, boolean[] blArray) {
        Object object;
        boolean[] blArray2;
        if (blArray != null) {
            blArray[2] = false;
            blArray[1] = false;
            blArray[0] = false;
        }
        if (!((blArray2 = x509Certificate.getKeyUsage()) == null || blArray2.length >= 1 && blArray2[0])) {
            if (blArray != null) {
                blArray[0] = true;
            } else {
                this.certs.get(certPath).setBadKeyUsage();
            }
        }
        try {
            object = x509Certificate.getExtendedKeyUsage();
            if (object != null && !object.contains("2.5.29.37.0") && !object.contains("1.3.6.1.5.5.7.3.3")) {
                if (blArray != null) {
                    blArray[1] = true;
                } else {
                    this.certs.get(certPath).setBadExtendedKeyUsage();
                }
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        try {
            object = x509Certificate.getExtensionValue("2.16.840.1.113730.1.1");
            if (object != null) {
                DerInputStream derInputStream = new DerInputStream((byte[])object);
                byte[] byArray = derInputStream.getOctetString();
                NetscapeCertTypeExtension netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray = new DerValue(byArray).getUnalignedBitString().toByteArray());
                Boolean bl = (Boolean)netscapeCertTypeExtension.get("object_signing");
                if (!bl.booleanValue()) {
                    if (blArray != null) {
                        blArray[2] = true;
                    } else {
                        this.certs.get(certPath).setBadNetscapeCertType();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean allJarsSigned() {
        return this.unverifiedJars.size() == 0;
    }

    public void checkTrustWithUser(JNLPFile jNLPFile) throws LaunchException {
        this.appVerifier.checkTrustWithUser(this, jNLPFile);
    }

    public Map<String, Integer> getJarSignableEntries() {
        return Collections.unmodifiableMap(this.jarSignableEntries);
    }

    public static int getTotalJarEntries(Map<String, Integer> map) {
        int n = 0;
        for (int n2 : map.values()) {
            n += n2;
        }
        return n;
    }

    static enum VerifyResult {
        UNSIGNED,
        SIGNED_OK,
        SIGNED_NOT_OK;

    }
}

