/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertificateUtils;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.SecurityUtil;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class CertificatePane
extends JPanel {
    private ArrayList<X509Certificate> certs = null;
    private static final Dimension TABLE_DIMENSION = new Dimension(500, 200);
    private String[][] issuedToAndBy = null;
    private final String[] columnNames = new String[]{Translator.R("CVIssuedTo"), Translator.R("CVIssuedBy")};
    private final CertificateType[] certificateTypes = new CertificateType[]{new CertificateType(KeyStores.Type.CA_CERTS), new CertificateType(KeyStores.Type.JSSE_CA_CERTS), new CertificateType(KeyStores.Type.CERTS), new CertificateType(KeyStores.Type.JSSE_CERTS), new CertificateType(KeyStores.Type.CLIENT_CERTS)};
    JTabbedPane tabbedPane;
    private final JTable userTable;
    private final JTable systemTable;
    private JComboBox certificateTypeCombo;
    private KeyStores.Type currentKeyStoreType;
    private KeyStores.Level currentKeyStoreLevel;
    private final List<JComponent> disableForSystem;
    private JDialog parent;
    private JComponent defaultFocusComponent = null;
    private KeyStore keyStore = null;

    public CertificatePane(JDialog jDialog) {
        this.parent = jDialog;
        this.userTable = new JTable(null);
        this.systemTable = new JTable(null);
        this.disableForSystem = new ArrayList<JComponent>();
        this.addComponents();
        this.currentKeyStoreType = ((CertificateType)this.certificateTypeCombo.getSelectedItem()).getType();
        this.currentKeyStoreLevel = this.tabbedPane.getSelectedIndex() == 0 ? KeyStores.Level.USER : KeyStores.Level.SYSTEM;
        this.repopulateTables();
    }

    private void initializeKeyStore() {
        try {
            this.keyStore = KeyStores.getKeyStore(this.currentKeyStoreLevel, this.currentKeyStoreType);
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
        }
    }

    private void addComponents() {
        JButton jButton;
        int n;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel = new JLabel(Translator.R("CVCertificateType"));
        this.certificateTypeCombo = new JComboBox<CertificateType>(this.certificateTypes);
        this.certificateTypeCombo.addActionListener(new CertificateTypeListener());
        jPanel2.add((Component)jLabel, "Before");
        jPanel2.add((Component)this.certificateTypeCombo, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        DefaultTableModel defaultTableModel = new DefaultTableModel(this.issuedToAndBy, this.columnNames);
        this.userTable.setModel(defaultTableModel);
        this.userTable.getTableHeader().setReorderingAllowed(false);
        this.userTable.setFillsViewportHeight(true);
        JScrollPane jScrollPane = new JScrollPane(this.userTable);
        jScrollPane.setPreferredSize(TABLE_DIMENSION);
        jScrollPane.setSize(TABLE_DIMENSION);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        DefaultTableModel defaultTableModel2 = new DefaultTableModel(this.issuedToAndBy, this.columnNames);
        this.systemTable.setModel(defaultTableModel2);
        this.systemTable.getTableHeader().setReorderingAllowed(false);
        this.systemTable.setFillsViewportHeight(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.systemTable);
        jScrollPane2.setPreferredSize(TABLE_DIMENSION);
        jScrollPane2.setSize(TABLE_DIMENSION);
        jScrollPane2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(Translator.R("CVUser"), jScrollPane);
        this.tabbedPane.addTab(Translator.R("CVSystem"), jScrollPane2);
        this.tabbedPane.addChangeListener(new TabChangeListener());
        JPanel jPanel4 = new JPanel(new FlowLayout());
        String[] stringArray = new String[]{Translator.R("CVImport"), Translator.R("CVExport"), Translator.R("CVRemove"), Translator.R("CVDetails")};
        char[] cArray = new char[]{'I', 'E', 'M', 'D'};
        ActionListener[] actionListenerArray = new ActionListener[]{new ImportButtonListener(), new ExportButtonListener(), new RemoveButtonListener(), new DetailsButtonListener()};
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            jButton = new JButton(stringArray[n]);
            n2 = Math.max(n2, jButton.getMinimumSize().width);
        }
        for (n = 0; n < stringArray.length; ++n) {
            jButton = new JButton(stringArray[n]);
            jButton.setMnemonic(cArray[n]);
            jButton.addActionListener(actionListenerArray[n]);
            jButton.setSize(n2, jButton.getSize().height);
            if (n == 0 || n == 2) {
                this.disableForSystem.add(jButton);
            }
            jPanel4.add(jButton);
        }
        jPanel3.add((Component)this.tabbedPane, "Center");
        jPanel3.add((Component)jPanel4, "South");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        if (this.parent != null) {
            JPanel jPanel5 = new JPanel(new BorderLayout());
            jPanel5.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
            JButton jButton2 = new JButton(Translator.R("ButClose"));
            jButton2.addActionListener(new CloseButtonListener());
            this.defaultFocusComponent = jButton2;
            jPanel5.add((Component)jButton2, "East");
            jPanel.add((Component)jPanel5, "South");
        }
        this.setLayout(new GridLayout(0, 1));
        this.add(jPanel);
    }

    private void readKeyStore() {
        Enumeration<String> enumeration = null;
        this.certs = new ArrayList();
        try {
            enumeration = this.keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Certificate certificate = this.keyStore.getCertificate(enumeration.nextElement());
                if (!(certificate instanceof X509Certificate)) continue;
                this.certs.add((X509Certificate)certificate);
            }
            this.issuedToAndBy = new String[this.certs.size()][2];
            for (int i = 0; i < this.certs.size(); ++i) {
                X509Certificate x509Certificate = this.certs.get(i);
                this.issuedToAndBy[i][0] = SecurityUtil.getCN(x509Certificate.getSubjectX500Principal().getName());
                this.issuedToAndBy[i][1] = SecurityUtil.getCN(x509Certificate.getIssuerX500Principal().getName());
            }
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
        }
    }

    private void repopulateTables() {
        this.initializeKeyStore();
        this.readKeyStore();
        DefaultTableModel defaultTableModel = new DefaultTableModel(this.issuedToAndBy, this.columnNames);
        this.userTable.setModel(defaultTableModel);
        defaultTableModel = new DefaultTableModel(this.issuedToAndBy, this.columnNames);
        this.systemTable.setModel(defaultTableModel);
    }

    public void focusOnDefaultButton() {
        if (this.defaultFocusComponent != null) {
            this.defaultFocusComponent.requestFocusInWindow();
        }
    }

    private char[] getPassword(String string) {
        JPasswordField jPasswordField = new JPasswordField();
        int n = JOptionPane.showConfirmDialog(this.parent, new Object[]{string, jPasswordField}, Translator.R("CVPasswordTitle"), 2, 1);
        if (n == 0) {
            return jPasswordField.getPassword();
        }
        return null;
    }

    private class CloseButtonListener
    implements ActionListener {
        private CloseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CertificatePane.this.parent.dispose();
        }
    }

    private class DetailsButtonListener
    implements ActionListener {
        private DetailsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = CertificatePane.this.currentKeyStoreLevel == KeyStores.Level.USER ? CertificatePane.this.userTable : CertificatePane.this.systemTable;
            int n = jTable.getSelectedRow();
            if (n != -1 && n >= 0) {
                X509Certificate x509Certificate = (X509Certificate)CertificatePane.this.certs.get(n);
                SecurityDialog.showSingleCertInfoDialog(x509Certificate, CertificatePane.this.parent);
            }
        }
    }

    private class RemoveButtonListener
    implements ActionListener {
        private RemoveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = CertificatePane.this.currentKeyStoreLevel == KeyStores.Level.USER ? CertificatePane.this.userTable : CertificatePane.this.systemTable;
            try {
                int n = jTable.getSelectedRow();
                if (n != -1) {
                    int n2;
                    String string = CertificatePane.this.keyStore.getCertificateAlias((Certificate)CertificatePane.this.certs.get(n));
                    if (string != null && (n2 = JOptionPane.showConfirmDialog(CertificatePane.this.parent, Translator.R("CVRemoveConfirmMessage"), Translator.R("CVRemoveConfirmTitle"), 0)) == 0) {
                        CertificatePane.this.keyStore.deleteEntry(string);
                        File file = new File(KeyStores.getKeyStoreLocation(CertificatePane.this.currentKeyStoreLevel, CertificatePane.this.currentKeyStoreType));
                        if (!file.isFile()) {
                            FileUtils.createRestrictedFile(file, true);
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        CertificatePane.this.keyStore.store(fileOutputStream, KeyStores.getPassword());
                        fileOutputStream.close();
                    }
                    CertificatePane.this.repopulateTables();
                }
            }
            catch (Exception exception) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
            }
        }
    }

    private class ExportButtonListener
    implements ActionListener {
        private ExportButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = CertificatePane.this.currentKeyStoreLevel == KeyStores.Level.USER ? CertificatePane.this.userTable : CertificatePane.this.systemTable;
            try {
                String string;
                JFileChooser jFileChooser;
                int n;
                int n2 = jTable.getSelectedRow();
                if (n2 != -1 && (n = (jFileChooser = new JFileChooser()).showOpenDialog(CertificatePane.this.parent)) == 0 && (string = CertificatePane.this.keyStore.getCertificateAlias((Certificate)CertificatePane.this.certs.get(n2))) != null) {
                    if (CertificatePane.this.currentKeyStoreType == KeyStores.Type.CLIENT_CERTS) {
                        char[] cArray = CertificatePane.this.getPassword(Translator.R("CVExportPasswordMessage"));
                        if (cArray != null) {
                            CertificateUtils.dumpPKCS12(string, jFileChooser.getSelectedFile(), CertificatePane.this.keyStore, cArray);
                        }
                    } else {
                        Certificate certificate = CertificatePane.this.keyStore.getCertificate(string);
                        PrintStream printStream = new PrintStream(jFileChooser.getSelectedFile().getAbsolutePath());
                        CertificateUtils.dump(certificate, printStream);
                    }
                    CertificatePane.this.repopulateTables();
                }
            }
            catch (Exception exception) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
            }
        }
    }

    private class ImportButtonListener
    implements ActionListener {
        private ImportButtonListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showOpenDialog(CertificatePane.this.parent);
            if (n != 0) return;
            try {
                KeyStore keyStore = CertificatePane.this.keyStore;
                if (CertificatePane.this.currentKeyStoreType == KeyStores.Type.CLIENT_CERTS) {
                    char[] cArray = CertificatePane.this.getPassword(Translator.R("CVImportPasswordMessage"));
                    if (cArray == null) return;
                    CertificateUtils.addPKCS12ToKeyStore(jFileChooser.getSelectedFile(), keyStore, cArray);
                } else {
                    CertificateUtils.addToKeyStore(jFileChooser.getSelectedFile(), keyStore);
                }
                File file = new File(KeyStores.getKeyStoreLocation(CertificatePane.this.currentKeyStoreLevel, CertificatePane.this.currentKeyStoreType));
                if (!file.isFile()) {
                    FileUtils.createRestrictedFile(file, true);
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    keyStore.store(fileOutputStream, KeyStores.getPassword());
                }
                CertificatePane.this.repopulateTables();
                return;
            }
            catch (Exception exception) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
            }
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            switch (jTabbedPane.getSelectedIndex()) {
                case 0: {
                    CertificatePane.this.currentKeyStoreLevel = KeyStores.Level.USER;
                    for (JComponent jComponent : CertificatePane.this.disableForSystem) {
                        jComponent.setEnabled(true);
                    }
                    break;
                }
                case 1: {
                    CertificatePane.this.currentKeyStoreLevel = KeyStores.Level.SYSTEM;
                    for (JComponent jComponent : CertificatePane.this.disableForSystem) {
                        jComponent.setEnabled(false);
                    }
                    break;
                }
            }
            CertificatePane.this.repopulateTables();
        }
    }

    private class CertificateTypeListener
    implements ActionListener {
        private CertificateTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            CertificateType certificateType = (CertificateType)jComboBox.getSelectedItem();
            CertificatePane.this.currentKeyStoreType = certificateType.getType();
            CertificatePane.this.repopulateTables();
        }
    }

    private static class CertificateType {
        private final KeyStores.Type type;

        public CertificateType(KeyStores.Type type) {
            this.type = type;
        }

        public KeyStores.Type getType() {
            return this.type;
        }

        public String toString() {
            return KeyStores.toDisplayableString(null, this.type);
        }
    }
}

