/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.SecurityDialogMessage;
import net.sourceforge.jnlp.util.logging.OutputController;

public final class SecurityDialogMessageHandler
implements Runnable {
    private BlockingQueue<SecurityDialogMessage> queue = new LinkedBlockingQueue<SecurityDialogMessage>();

    @Override
    public void run() {
        OutputController.getLogger().log("Starting security dialog thread");
        while (true) {
            try {
                while (true) {
                    SecurityDialogMessage securityDialogMessage = this.queue.take();
                    this.handleMessage(securityDialogMessage);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void handleMessage(SecurityDialogMessage securityDialogMessage) {
        final SecurityDialogMessage securityDialogMessage2 = securityDialogMessage;
        final SecurityDialog securityDialog = new SecurityDialog(securityDialogMessage.dialogType, securityDialogMessage.accessType, securityDialogMessage.file, securityDialogMessage.certVerifier, securityDialogMessage.certificate, securityDialogMessage.extras);
        securityDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                securityDialogMessage2.userResponse = securityDialog.getValue();
                if (securityDialogMessage2.toDispose != null) {
                    securityDialogMessage2.toDispose.dispose();
                }
                if (securityDialogMessage2.lock != null) {
                    securityDialogMessage2.lock.release();
                }
            }
        });
        securityDialog.setVisible(true);
    }

    public void postMessage(SecurityDialogMessage securityDialogMessage) {
        try {
            this.queue.put(securityDialogMessage);
        }
        catch (InterruptedException interruptedException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, interruptedException);
        }
    }
}

