/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.browser;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sourceforge.jnlp.browser.FirefoxPreferencesFinder;
import net.sourceforge.jnlp.browser.FirefoxPreferencesParser;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.JNLPProxySelector;
import net.sourceforge.jnlp.runtime.PacEvaluator;
import net.sourceforge.jnlp.runtime.PacEvaluatorFactory;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

public class BrowserAwareProxySelector
extends JNLPProxySelector {
    public static final int BROWSER_PROXY_TYPE_NONE = 0;
    public static final int BROWSER_PROXY_TYPE_MANUAL = 1;
    public static final int BROWSER_PROXY_TYPE_PAC = 2;
    public static final int BROWSER_PROXY_TYPE_NONE2 = 3;
    public static final int BROWSER_PROXY_TYPE_AUTO = 4;
    public static final int BROWSER_PROXY_TYPE_SYSTEM = 5;
    private int browserProxyType = 0;
    private URL browserAutoConfigUrl;
    private Boolean browserUseSameProxy;
    private String browserHttpProxyHost;
    private int browserHttpProxyPort;
    private String browserHttpsProxyHost;
    private int browserHttpsProxyPort;
    private String browserFtpProxyHost;
    private int browserFtpProxyPort;
    private String browserSocks4ProxyHost;
    private int browserSocks4ProxyPort;
    private PacEvaluator browserProxyAutoConfig = null;

    public BrowserAwareProxySelector(DeploymentConfiguration deploymentConfiguration) {
        super(deploymentConfiguration);
    }

    public void initialize() {
        try {
            this.initFromBrowserConfig();
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(iOException);
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("RProxyFirefoxNotFound"));
            this.browserProxyType = 0;
        }
    }

    private void initFromBrowserConfig() throws IOException {
        Map<String, String> map = this.parseBrowserPreferences();
        String string = map.get("network.proxy.type");
        this.browserProxyType = string != null ? Integer.valueOf(string) : 4;
        try {
            String string2 = map.get("network.proxy.autoconfig_url");
            if (string2 != null) {
                this.browserAutoConfigUrl = new URL(string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, malformedURLException);
        }
        if (this.browserProxyType == 2 && this.browserAutoConfigUrl != null) {
            this.browserProxyAutoConfig = PacEvaluatorFactory.getPacEvaluator(this.browserAutoConfigUrl);
        }
        this.browserUseSameProxy = Boolean.valueOf(map.get("network.proxy.share_proxy_settings"));
        this.browserHttpProxyHost = map.get("network.proxy.http");
        this.browserHttpProxyPort = this.stringToPort(map.get("network.proxy.http_port"));
        this.browserHttpsProxyHost = map.get("network.proxy.ssl");
        this.browserHttpsProxyPort = this.stringToPort(map.get("network.proxy.ssl_port"));
        this.browserFtpProxyHost = map.get("network.proxy.ftp");
        this.browserFtpProxyPort = this.stringToPort(map.get("network.proxy.ftp_port"));
        this.browserSocks4ProxyHost = map.get("network.proxy.socks");
        this.browserSocks4ProxyPort = this.stringToPort(map.get("network.proxy.socks_port"));
    }

    Map<String, String> parseBrowserPreferences() throws IOException {
        File file = FirefoxPreferencesFinder.find();
        FirefoxPreferencesParser firefoxPreferencesParser = new FirefoxPreferencesParser(file);
        firefoxPreferencesParser.parse();
        return firefoxPreferencesParser.getPreferences();
    }

    private int stringToPort(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MIN_VALUE;
        }
    }

    @Override
    protected List<Proxy> getFromBrowser(URI uRI) {
        ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
        String string = null;
        switch (this.browserProxyType) {
            case 2: {
                arrayList.addAll(this.getFromBrowserPAC(uRI));
                break;
            }
            case 1: {
                arrayList.addAll(this.getFromBrowserConfiguration(uRI));
                break;
            }
            case 0: {
                arrayList.add(Proxy.NO_PROXY);
                break;
            }
            case 4: {
                if (string == null) {
                    string = "Automatic";
                }
            }
            case 5: {
                if (string == null) {
                    string = "System";
                }
            }
            default: {
                if (string == null) {
                    string = "Unknown";
                }
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, Translator.R("RProxyFirefoxOptionNotImplemented", this.browserProxyType, string));
                arrayList.add(Proxy.NO_PROXY);
            }
        }
        OutputController.getLogger().log("Browser selected proxies: " + ((Object)arrayList).toString());
        return arrayList;
    }

    private List<Proxy> getFromBrowserPAC(URI uRI) {
        if (this.browserAutoConfigUrl == null || uRI.getScheme().equals("socket")) {
            return Arrays.asList(Proxy.NO_PROXY);
        }
        ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
        try {
            String string = this.browserProxyAutoConfig.getProxies(uRI.toURL());
            arrayList.addAll(BrowserAwareProxySelector.getProxiesFromPacResult(string));
        }
        catch (MalformedURLException malformedURLException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, malformedURLException);
            arrayList.add(Proxy.NO_PROXY);
        }
        return arrayList;
    }

    private List<Proxy> getFromBrowserConfiguration(URI uRI) {
        return BrowserAwareProxySelector.getFromArguments(uRI, this.browserUseSameProxy, true, this.browserHttpsProxyHost, this.browserHttpsProxyPort, this.browserHttpProxyHost, this.browserHttpProxyPort, this.browserFtpProxyHost, this.browserFtpProxyPort, this.browserSocks4ProxyHost, this.browserSocks4ProxyPort);
    }
}

