/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.about;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.sourceforge.jnlp.about.HTMLPanel;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ScreenFinder;

public class AboutDialog
extends JPanel
implements Runnable,
ActionListener {
    private static final String about_url = "/net/sourceforge/jnlp/resources/about.html";
    private static final String authors_url = "/net/sourceforge/jnlp/resources/AUTHORS.html";
    private static final String changelog_url = "/net/sourceforge/jnlp/resources/ChangeLog.html";
    private static final String copying_url = "/net/sourceforge/jnlp/resources/COPYING.html";
    private static final String news_url = "/net/sourceforge/jnlp/resources/NEWS.html";
    private JDialog frame;
    private JPanel contentPane;
    private HTMLPanel aboutPanel;
    private HTMLPanel authorsPanel;
    private HTMLPanel newsPanel;
    private HTMLPanel changelogPanel;
    private HTMLPanel copyingPanel;
    private JButton aboutButton;
    private JButton authorsButton;
    private JButton newsButton;
    private JButton changelogButton;
    private JButton copyingButton;

    public AboutDialog(boolean bl) {
        super(new GridBagLayout());
        this.frame = new JDialog((Frame)null, Translator.R("AboutDialogueTabAbout") + " IcedTea-Web", bl);
        this.frame.setContentPane(this);
        this.frame.setDefaultCloseOperation(2);
        URL uRL = this.getClass().getResource(about_url);
        URL uRL2 = this.getClass().getResource(authors_url);
        URL uRL3 = this.getClass().getResource(news_url);
        URL uRL4 = this.getClass().getResource(changelog_url);
        URL uRL5 = this.getClass().getResource(copying_url);
        this.aboutPanel = new HTMLPanel(uRL, Translator.R("AboutDialogueTabAbout"));
        this.authorsPanel = new HTMLPanel(uRL2, Translator.R("AboutDialogueTabAuthors"));
        this.newsPanel = new HTMLPanel(uRL3, Translator.R("AboutDialogueTabNews"));
        this.changelogPanel = new HTMLPanel(uRL4, Translator.R("AboutDialogueTabChangelog"));
        this.copyingPanel = new HTMLPanel(uRL5, Translator.R("AboutDialogueTabGPLv2"));
        this.aboutButton = new JButton(this.aboutPanel.getIdentifier());
        this.aboutButton.setActionCommand(this.aboutPanel.getIdentifier());
        this.aboutButton.addActionListener(this);
        this.authorsButton = new JButton(this.authorsPanel.getIdentifier());
        this.authorsButton.setActionCommand(this.authorsPanel.getIdentifier());
        this.authorsButton.addActionListener(this);
        this.newsButton = new JButton(this.newsPanel.getIdentifier());
        this.newsButton.setActionCommand(this.newsPanel.getIdentifier());
        this.newsButton.addActionListener(this);
        this.changelogButton = new JButton(this.changelogPanel.getIdentifier());
        this.changelogButton.setActionCommand(this.changelogPanel.getIdentifier());
        this.changelogButton.addActionListener(this);
        this.copyingButton = new JButton(this.copyingPanel.getIdentifier());
        this.copyingButton.setActionCommand(this.copyingPanel.getIdentifier());
        this.copyingButton.addActionListener(this);
        this.contentPane = this.aboutPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(((HTMLPanel)this.contentPane).getIdentifier())) {
            return;
        }
        if (string.equals(this.aboutPanel.getIdentifier())) {
            this.contentPane = this.aboutPanel;
        } else if (string.equals(this.authorsPanel.getIdentifier())) {
            this.contentPane = this.authorsPanel;
        } else if (string.equals(this.newsPanel.getIdentifier())) {
            this.contentPane = this.newsPanel;
        } else if (string.equals(this.changelogPanel.getIdentifier())) {
            this.contentPane = this.changelogPanel;
        } else if (string.equals(this.copyingPanel.getIdentifier())) {
            this.contentPane = this.copyingPanel;
        }
        this.layoutWindow();
    }

    private void layoutWindow() {
        this.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.contentPane, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipady = 16;
        this.add((Component)this.aboutButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.authorsButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.newsButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.add((Component)this.changelogButton, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        this.add((Component)this.copyingButton, gridBagConstraints);
        Dimension dimension = new Dimension(640, 480);
        this.contentPane.setMinimumSize(dimension);
        this.contentPane.setPreferredSize(dimension);
        this.contentPane.setBorder(new EmptyBorder(0, 0, 8, 0));
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.frame.pack();
    }

    @Override
    public void run() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.layoutWindow();
        ScreenFinder.centerWindowsToCurrentScreen(this.frame);
        this.frame.setVisible(true);
    }

    public static void display() {
        AboutDialog.display(false);
    }

    public static void display(boolean bl) {
        SwingUtilities.invokeLater(new AboutDialog(bl));
    }
}

