/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import net.sourceforge.jnlp.util.logging.OutputController;
import sun.applet.PluginDebug;
import sun.applet.PluginException;
import sun.applet.PluginMessageConsumer;
import sun.applet.PluginStreamHandler;

class PluginMessageHandlerWorker
extends Thread {
    private boolean free = true;
    private final boolean isPriorityWorker;
    private final int id;
    private volatile String message;
    private PluginStreamHandler streamHandler;
    private PluginMessageConsumer consumer;

    public synchronized void notifyHasWork() {
        this.notifyAll();
    }

    public synchronized void waitForWork() {
        try {
            this.wait(1000L);
        }
        catch (InterruptedException interruptedException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, interruptedException);
        }
    }

    public PluginMessageHandlerWorker(PluginMessageConsumer pluginMessageConsumer, PluginStreamHandler pluginStreamHandler, int n, boolean bl) {
        super("PluginMessageHandlerWorker" + n);
        this.id = n;
        this.streamHandler = pluginStreamHandler;
        this.isPriorityWorker = bl;
        this.consumer = pluginMessageConsumer;
        PluginDebug.debug("Worker ", this.id, " (priority=", bl, ") created.");
    }

    public void setmessage(String string) {
        this.message = string;
    }

    @Override
    public void run() {
        while (true) {
            if (this.message != null) {
                PluginDebug.debug("Consumer (priority=", this.isPriorityWorker, ") thread ", this.id, " consuming ", this.message);
                this.busy();
                try {
                    this.streamHandler.handleMessage(this.message);
                }
                catch (PluginException pluginException) {
                    // empty catch block
                }
                this.message = null;
                PluginDebug.debug("Consumption (priority=", this.isPriorityWorker, ") completed by consumer thread ", this.id);
                this.free();
                continue;
            }
            this.waitForWork();
        }
    }

    public int getWorkerId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void busy() {
        PluginMessageHandlerWorker pluginMessageHandlerWorker = this;
        synchronized (pluginMessageHandlerWorker) {
            this.free = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        PluginMessageHandlerWorker pluginMessageHandlerWorker = this;
        synchronized (pluginMessageHandlerWorker) {
            this.free = true;
        }
    }

    public boolean isPriority() {
        return this.isPriorityWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFree(boolean bl) {
        PluginMessageHandlerWorker pluginMessageHandlerWorker = this;
        synchronized (pluginMessageHandlerWorker) {
            return this.free && bl == this.isPriorityWorker;
        }
    }

    @Override
    public String toString() {
        return "Worker #" + this.id + "/IsPriority=" + this.isPriorityWorker + "/IsFree=" + this.free + "/Message=" + this.message;
    }
}

