/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.jnlp.util.logging.JavaConsole;
import net.sourceforge.jnlp.util.logging.OutputController;

public class BasicExceptionDialog {
    public static void show(Exception exception) {
        String string = OutputController.exceptionToString(exception);
        final JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JOptionPane jOptionPane = new JOptionPane(jPanel, 0);
        final JDialog jDialog = jOptionPane.createDialog(Translator.R("Error"));
        jDialog.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 1);
        jPanel2.setLayout(boxLayout);
        jPanel.add((Component)jPanel2, "First");
        JLabel jLabel = new JLabel(exception.getMessage());
        jLabel.setAlignmentY(0.0f);
        jPanel2.add(jLabel);
        final JButton jButton = new JButton(Translator.R("ButShowDetails"));
        jButton.setAlignmentY(0.0f);
        jButton.setActionCommand("show");
        jPanel2.add(jButton);
        JButton jButton2 = BasicExceptionDialog.getShowButton(jDialog);
        jButton2.setAlignmentY(0.0f);
        jPanel2.add(jButton2);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jTextArea.setEditable(false);
        jTextArea.setText(string);
        final JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(100, 200));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jButton.getActionCommand().equals("show")) {
                    jPanel.add((Component)jScrollPane, "Center");
                    jButton.setActionCommand("hide");
                    jButton.setText(Translator.R("ButHideDetails"));
                    jDialog.pack();
                } else {
                    jPanel.remove(jScrollPane);
                    jButton.setActionCommand("show");
                    jButton.setText(Translator.R("ButShowDetails"));
                    jDialog.pack();
                }
            }
        });
        jDialog.pack();
        jDialog.setResizable(true);
        ScreenFinder.centerWindowsToCurrentScreen(jDialog);
        jDialog.setVisible(true);
        jDialog.dispose();
    }

    public static JButton getShowButton(final Component component) {
        JButton jButton = new JButton();
        jButton.setText(Translator.R("DPJavaConsole"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JavaConsole.getConsole().showConsoleLater(true);
                }
                catch (Exception exception) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
                    JOptionPane.showConfirmDialog(component, exception);
                }
            }
        });
        if (!JavaConsole.isEnabled()) {
            jButton.setEnabled(false);
            jButton.setToolTipText(Translator.R("DPJavaConsoleDisabledHint"));
        }
        return jButton;
    }
}

