/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.AbstractLaunchHandler;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JNLPSplashScreen;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.util.BasicExceptionDialog;
import net.sourceforge.jnlp.util.logging.OutputController;

public class GuiLaunchHandler
extends AbstractLaunchHandler {
    private volatile JNLPSplashScreen splashScreen = null;
    private final Object mutex = new Object();
    private UpdatePolicy policy = UpdatePolicy.ALWAYS;

    public GuiLaunchHandler(OutputController outputController) {
        super(outputController);
    }

    @Override
    public void launchCompleted(ApplicationInstance applicationInstance) {
    }

    @Override
    public void launchError(final LaunchException launchException) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiLaunchHandler.this.closeSplashScreen();
                BasicExceptionDialog.show(launchException);
            }
        });
        this.printMessage(launchException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSplashScreen() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.splashScreen != null) {
                if (this.splashScreen.isSplashScreenValid()) {
                    this.splashScreen.setVisible(false);
                    this.splashScreen.stopAnimation();
                }
                this.splashScreen.dispose();
            }
        }
    }

    @Override
    public void launchStarting(ApplicationInstance applicationInstance) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiLaunchHandler.this.closeSplashScreen();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launchInitialized(final JNLPFile jNLPFile) {
        int n = 500;
        int n2 = 400;
        final URL uRL = jNLPFile.getInformation().getIconLocation(IconDesc.SPLASH, n, n2);
        final ResourceTracker resourceTracker = new ResourceTracker(true);
        if (uRL != null) {
            resourceTracker.addResource(uRL, jNLPFile.getFileVersion(), null, this.policy);
        }
        Object object = this.mutex;
        synchronized (object) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GuiLaunchHandler.this.splashScreen = new JNLPSplashScreen(resourceTracker, jNLPFile);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                while (this.splashScreen == null) {
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, invocationTargetException);
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GuiLaunchHandler.this.splashScreen.setSplashImageURL(uRL);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                while (!this.splashScreen.isSplashImageLoaded()) {
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, invocationTargetException);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (GuiLaunchHandler.this.splashScreen != null) {
                    Object object = GuiLaunchHandler.this.mutex;
                    synchronized (object) {
                        if (GuiLaunchHandler.this.splashScreen.isSplashScreenValid()) {
                            GuiLaunchHandler.this.splashScreen.setVisible(true);
                        }
                    }
                }
            }
        });
    }

    @Override
    public boolean launchWarning(LaunchException launchException) {
        this.printMessage(launchException);
        return true;
    }

    @Override
    public boolean validationError(LaunchException launchException) {
        this.closeSplashScreen();
        this.printMessage(launchException);
        return true;
    }
}

