/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jnlp.PluginParameters;

class PluginParameterParser {
    private static final char DELIMITER_ESCAPE = ':';
    private static final String KEY_VALUE_DELIMITER = ";";

    PluginParameterParser() {
    }

    static String unescapeString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\\') {
                stringBuilder.append(c);
                continue;
            }
            if ((c = string.charAt(++i)) == 'n') {
                stringBuilder.append('\n');
                continue;
            }
            if (c == '\\') {
                stringBuilder.append('\\');
                continue;
            }
            if (c != ':') continue;
            stringBuilder.append(KEY_VALUE_DELIMITER);
        }
        return stringBuilder.toString();
    }

    static Map<String, String> parseEscapedKeyValuePairs(String string) {
        String[] stringArray = string.split(KEY_VALUE_DELIMITER, -1);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length - 1; i += 2) {
            String string2 = PluginParameterParser.unescapeString(stringArray[i]).toLowerCase();
            String string3 = PluginParameterParser.unescapeString(stringArray[i + 1]);
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    static boolean isInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public PluginParameters parse(String string, String string2, String string3) {
        Map<String, String> map = PluginParameterParser.parseEscapedKeyValuePairs(string3);
        if (map.get("width") == null || !PluginParameterParser.isInt(map.get("width"))) {
            map.put("width", string);
        }
        if (map.get("height") == null || !PluginParameterParser.isInt(map.get("height"))) {
            map.put("height", string2);
        }
        return new PluginParameters(map);
    }
}

