/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.StreamEater;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class XDesktopEntry {
    public static final String JAVA_ICON_NAME = "java";
    private JNLPFile file = null;
    private int iconSize = -1;
    private String iconLocation = null;
    private int[] VALID_ICON_SIZES = new int[]{16, 22, 32, 48, 64, 128};
    static final String XDG_DESKTOP_DIR = "XDG_DESKTOP_DIR";
    private static final String MIC = "MAGIC_QUOTIN_ITW_CONSTANT_FOR_DUMMIES";

    public XDesktopEntry(JNLPFile jNLPFile) {
        this.file = jNLPFile;
        this.iconSize = this.VALID_ICON_SIZES[2];
    }

    public Reader getContentsAsReader() {
        String string = JNLPRuntime.getConfiguration().getProperty("deployment.user.cachedir");
        File file = CacheUtil.getCacheFile(this.file.getSourceLocation(), null);
        String string2 = "[Desktop Entry]\n";
        string2 = string2 + "Version=1.0\n";
        string2 = string2 + "Name=" + this.getDesktopIconName() + "\n";
        string2 = string2 + "GenericName=Java Web Start Application\n";
        string2 = string2 + "Comment=" + XDesktopEntry.sanitize(this.file.getInformation().getDescription()) + "\n";
        string2 = string2 + "Type=Application\n";
        string2 = this.iconLocation != null ? string2 + "Icon=" + this.iconLocation + "\n" : string2 + "Icon=java\n";
        if (this.file.getInformation().getVendor() != null) {
            string2 = string2 + "Vendor=" + XDesktopEntry.sanitize(this.file.getInformation().getVendor()) + "\n";
        }
        string2 = string2 + "Exec=javaws \"" + file.getAbsolutePath() + "\"\n";
        return new StringReader(string2);
    }

    private static String sanitize(String string) {
        if (string == null) {
            return "";
        }
        return string.split("\n")[0];
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public File getShortcutTmpFile() {
        String string = JNLPRuntime.getConfiguration().getProperty("deployment.user.tmp");
        File file = new File(string + File.separator + FileUtils.sanitizeFileName(this.file.getTitle()) + ".desktop");
        return file;
    }

    public void setIconSize(int n) {
        this.iconSize = n;
    }

    public void createDesktopShortcut() {
        try {
            this.cacheIcon();
            this.installDesktopLauncher();
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
        }
    }

    private void installDesktopLauncher() {
        File file = this.getShortcutTmpFile();
        try {
            if (!file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
                throw new IOException(file.getParentFile().toString());
            }
            FileUtils.createRestrictedFile(file, true);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8"));
            Reader reader = this.getContentsAsReader();
            char[] cArray = new char[1024];
            int n = 0;
            while (-1 != (n = reader.read(cArray))) {
                outputStreamWriter.write(cArray, 0, n);
            }
            reader.close();
            outputStreamWriter.close();
            Object[] objectArray = new String[]{"xdg-desktop-icon", "install", "--novendor", file.getCanonicalPath()};
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Execing: " + Arrays.toString(objectArray));
            Process process = Runtime.getRuntime().exec((String[])objectArray);
            new StreamEater(process.getInputStream()).start();
            new StreamEater(process.getErrorStream()).start();
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, interruptedException);
            }
            if (!file.delete()) {
                throw new IOException("Unable to delete temporary file:" + file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, fileNotFoundException);
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
        }
    }

    private void cacheIcon() {
        URL uRL = this.file.getInformation().getIconLocation(IconDesc.SHORTCUT, this.iconSize, this.iconSize);
        if (uRL == null) {
            uRL = this.file.getInformation().getIconLocation(IconDesc.DEFAULT, this.iconSize, this.iconSize);
        }
        if (uRL != null) {
            String string = CacheUtil.getCachedResource(uRL, null, UpdatePolicy.SESSION).toString();
            if (!string.startsWith("file:")) {
                throw new RuntimeException("Unable to cache icon");
            }
            this.iconLocation = string.substring("file:".length());
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Cached desktop shortcut icon: " + this.iconLocation);
        }
    }

    public String getDesktopIconName() {
        return XDesktopEntry.sanitize(this.file.getTitle());
    }

    public File getLinuxDesktopIconFile() {
        return new File(XDesktopEntry.findFreedesktopOrgDesktopPathCatch() + "/" + this.getDesktopIconName() + ".desktop");
    }

    private static String findFreedesktopOrgDesktopPathCatch() {
        try {
            return XDesktopEntry.findFreedesktopOrgDesktopPath();
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
            return System.getProperty("user.home") + "/Desktop/";
        }
    }

    private static String findFreedesktopOrgDesktopPath() throws IOException {
        File file = new File(System.getProperty("user.home") + "/.config/user-dirs.dirs");
        if (!file.exists()) {
            return System.getProperty("user.home") + "/Desktop/";
        }
        return XDesktopEntry.getFreedesktopOrgDesktopPathFrom(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFreedesktopOrgDesktopPathFrom(File file) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string = XDesktopEntry.getFreedesktopOrgDesktopPathFrom(bufferedReader);
            return string;
        }
    }

    static String getFreedesktopOrgDesktopPathFrom(BufferedReader bufferedReader) throws IOException {
        String string;
        do {
            if ((string = bufferedReader.readLine()) != null) continue;
            throw new IOException("End of user-dirs found, but no XDG_DESKTOP_DIR key found");
        } while (!(string = string.trim()).startsWith(XDG_DESKTOP_DIR));
        if (!string.contains("=")) {
            throw new IOException("XDG_DESKTOP_DIR has no value");
        }
        String[] stringArray = string.split("=");
        stringArray[1] = stringArray[1].trim();
        String string2 = XDesktopEntry.filterQuotes(stringArray[1]);
        return XDesktopEntry.evaluateLinuxVariables(string2);
    }

    private static String filterQuotes(String string) {
        String string2 = string.replaceAll("\\\\\"", MIC);
        string2 = string2.replaceAll("\"", "");
        string2 = string2.replaceAll(MIC, "\\\"");
        return string2;
    }

    private static String evaluateLinuxVariables(String string) {
        return XDesktopEntry.evaluateLinuxVariables(string, System.getenv());
    }

    private static String evaluateLinuxVariables(String string, Map<String, String> map) {
        String string2;
        Set<Map.Entry<String, String>> set = map.entrySet();
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(set);
        Collections.sort(arrayList, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> entry, Map.Entry<String, String> entry2) {
                return entry2.getKey().length() - entry.getKey().length();
            }
        });
        do {
            string2 = string;
            for (Map.Entry entry : arrayList) {
                string = string.replaceAll("\\$" + (String)entry.getKey(), (String)entry.getValue());
            }
        } while (!string2.equals(string));
        return string;
    }
}

