/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;

public class TextOutlineRenderer {
    private Image img;
    private Font font;
    private Color outlineColor;
    private final String text;

    public TextOutlineRenderer(Font font, String string) {
        this.font = font;
        this.outlineColor = Color.black;
        this.text = string;
    }

    public TextOutlineRenderer(Font font, String string, Color color) {
        this(font, string);
        this.outlineColor = color;
    }

    public int getWidth() {
        if (this.img == null) {
            return -1;
        }
        return this.img.getWidth(null);
    }

    public int getHeight() {
        if (this.img == null) {
            return -1;
        }
        return this.img.getHeight(null);
    }

    public void cutTo(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(this.getText(), this.getFont(), fontRenderContext);
        float f = (float)textLayout.getBounds().getWidth();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(n, n2);
        Shape shape = textLayout.getOutline(affineTransform);
        Rectangle rectangle = shape.getBounds();
        graphics2D.setColor(this.getTextOutline());
        graphics2D.draw(shape);
        graphics2D.setClip(shape);
        graphics2D.drawImage(this.getImg(), rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
    }

    public Image getImg() {
        return this.img;
    }

    public void setImg(Image image) {
        this.img = image;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getTextOutline() {
        return this.outlineColor;
    }

    public void setTextOutline(Color color) {
        this.outlineColor = color;
    }

    public String getText() {
        return this.text;
    }
}

